/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.custom;

import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableTimeSignature
extends TGUndoableEditBase {
    private int doAction;
    private TGSong song;
    private long tsStart;
    private boolean tsToEnd;
    private TGTimeSignature ts;

    private TGUndoableTimeSignature(TGContext context) {
        super(context);
    }

    public void redo() throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.changeTimeSignature(this.getSong(), this.getMeasureHeaderAt(this.tsStart), this.ts, this.tsToEnd);
        this.doAction = 1;
    }

    public void undo() throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.copySongFrom(this.getSong(), this.song);
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableTimeSignature startUndo(TGContext context) {
        TGFactory factory = new TGFactory();
        TGSong song = TGUndoableTimeSignature.getSong(context);
        TGUndoableTimeSignature undoable = new TGUndoableTimeSignature(context);
        undoable.doAction = 1;
        undoable.song = song.clone(factory);
        return undoable;
    }

    public TGUndoableTimeSignature endUndo(TGTimeSignature timeSignature, long start, boolean toEnd) {
        this.ts = timeSignature;
        this.tsStart = start;
        this.tsToEnd = toEnd;
        return this;
    }

    public TGMeasureHeader getMeasureHeaderAt(Long start) {
        return this.getSongManager().getMeasureHeaderAt(this.getSong(), start.longValue());
    }

    public void changeTimeSignature(TGSong song, TGMeasureHeader header, TGTimeSignature timeSignature, Boolean toEnd) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.composition.change-time-signature");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, header);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TIME_SIGNATURE, timeSignature);
        tgActionProcessor.setAttribute("applyToEnd", toEnd);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void copySongFrom(TGSong song, TGSong from) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.song.copy.from");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute("from", from);
        this.processByPassUndoableAction(tgActionProcessor);
    }
}

