/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.custom;

import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableTempo
extends TGUndoableEditBase {
    private int doAction;
    private long position;
    private TGTempo undoableTempo;
    private TGTempo redoableTempo;

    private TGUndoableTempo(TGContext context) {
        super(context);
    }

    public void redo() throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.changeTempo(this.getMeasureHeaderAt(this.position), this.redoableTempo);
        this.doAction = 1;
    }

    public void undo() throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.changeTempo(this.getMeasureHeaderAt(this.position), this.undoableTempo);
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableTempo startUndo(TGContext context, TGMeasureHeader header) {
        TGUndoableTempo undoable = new TGUndoableTempo(context);
        undoable.doAction = 1;
        undoable.position = header.getStart();
        undoable.undoableTempo = undoable.createTempoClone(header);
        return undoable;
    }

    public TGUndoableTempo endUndo(TGMeasureHeader header) {
        this.redoableTempo = this.createTempoClone(header);
        return this;
    }

    public TGMeasureHeader getMeasureHeaderAt(Long start) {
        return this.getSongManager().getMeasureHeaderAt(this.getSong(), start.longValue());
    }

    public TGTempo createTempoClone(TGMeasureHeader header) {
        return header.getTempo().clone(this.getSongManager().getFactory());
    }

    public void changeTempo(TGMeasureHeader header, TGTempo tempo) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.composition.change-tempo");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, header);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TEMPO, tempo);
        this.processByPassUndoableAction(tgActionProcessor);
    }
}

