/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.custom.converter;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.custom.converter.TGConverter;
import org.herac.tuxguitar.app.tools.custom.converter.TGConverterFormat;
import org.herac.tuxguitar.app.tools.custom.converter.TGConverterListener;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGConverterProcess
implements TGConverterListener,
TGEventListener {
    private static final int SHELL_WIDTH = 650;
    private static final int SHELL_HEIGHT = 350;
    protected static final String EOL = "\n";
    protected static final Color COLOR_INFO = TuxGuitar.getInstance().getDisplay().getSystemColor(9);
    protected static final Color COLOR_ERROR = TuxGuitar.getInstance().getDisplay().getSystemColor(3);
    private TGContext context;
    protected Shell dialog;
    protected StyledText output;
    protected Button buttonCancel;
    protected Button buttonClose;
    protected TGConverter converter;
    protected boolean finished;

    public TGConverterProcess(TGContext context) {
        this.context = context;
    }

    public void start(String initFolder, String destFolder, TGConverterFormat format) {
        this.converter = new TGConverter(this.context, initFolder, destFolder);
        this.converter.setFormat(format);
        this.converter.setListener(this);
        this.showProcess();
        new Thread(new Runnable(){

            public void run() throws TGException {
                TGConverterProcess.this.converter.process();
            }
        }).start();
    }

    protected void showProcess() {
        this.finished = false;
        this.dialog = DialogUtils.newDialog((Shell)TuxGuitar.getInstance().getShell(), (int)1264);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setSize(650, 350);
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TuxGuitar.getInstance().getIconManager().removeLoader((TGEventListener)TGConverterProcess.this);
                TuxGuitar.getInstance().getLanguageManager().removeLoader((TGEventListener)TGConverterProcess.this);
            }
        });
        this.dialog.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = TGConverterProcess.this.finished;
            }
        });
        Composite composite = new Composite((Composite)this.dialog, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.output = new StyledText(composite, 2818);
        this.output.setLayoutData((Object)new GridData(4, 4, true, true));
        this.output.setEditable(false);
        Composite buttons = new Composite((Composite)this.dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(131072, 1024, true, false));
        this.buttonCancel = new Button(buttons, 8);
        this.buttonCancel.setEnabled(false);
        this.buttonCancel.setLayoutData((Object)this.getButtonsData());
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGConverterProcess.this.converter.setCancelled(true);
            }
        });
        this.buttonClose = new Button(buttons, 8);
        this.buttonClose.setEnabled(false);
        this.buttonClose.setLayoutData((Object)this.getButtonsData());
        this.buttonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGConverterProcess.this.dialog.dispose();
            }
        });
        this.loadIcons(false);
        this.loadProperties(false);
        TuxGuitar.getInstance().getIconManager().addLoader((TGEventListener)this);
        TuxGuitar.getInstance().getLanguageManager().addLoader((TGEventListener)this);
        DialogUtils.openDialog((Shell)this.dialog, (int)8);
    }

    private GridData getButtonsData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void loadProperties() {
        this.loadProperties(true);
    }

    public void loadProperties(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty((String)"batch.converter"));
            this.buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
            this.buttonClose.setText(TuxGuitar.getProperty((String)"close"));
            if (layout) {
                this.dialog.layout(true, true);
            }
        }
    }

    public void loadIcons() {
        this.loadIcons(true);
    }

    public void loadIcons(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            if (layout) {
                this.dialog.layout(true, true);
            }
        }
    }

    public void notifyFileProcess(final String filename) {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() throws TGException {
                    if (!TGConverterProcess.this.isDisposed()) {
                        TGConverterProcess.this.output.append(TuxGuitar.getProperty((String)"batch.converter.messages.converting", (String[])new String[]{filename}));
                        TGConverterProcess.this.output.setSelection(TGConverterProcess.this.output.getCharCount());
                    }
                }
            });
        }
    }

    public void notifyFileResult(final String filename, final int result) {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() throws TGException {
                    if (!TGConverterProcess.this.isDisposed()) {
                        TGConverterProcess.this.appendLogMessage(result, filename);
                        TGConverterProcess.this.output.setSelection(TGConverterProcess.this.output.getCharCount());
                    }
                }
            });
        }
    }

    public void notifyStart() {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() throws TGException {
                    if (!TGConverterProcess.this.isDisposed()) {
                        TGConverterProcess.this.finished = false;
                        TGConverterProcess.this.buttonClose.setEnabled(TGConverterProcess.this.finished);
                        TGConverterProcess.this.buttonCancel.setEnabled(!TGConverterProcess.this.finished);
                        TGConverterProcess.this.output.setCursor(TGConverterProcess.this.dialog.getDisplay().getSystemCursor(1));
                    }
                }
            });
        }
    }

    public void notifyFinish() {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() throws TGException {
                    if (!TGConverterProcess.this.isDisposed()) {
                        TGConverterProcess.this.finished = true;
                        TGConverterProcess.this.buttonClose.setEnabled(TGConverterProcess.this.finished);
                        TGConverterProcess.this.buttonCancel.setEnabled(!TGConverterProcess.this.finished);
                        TGConverterProcess.this.output.setCursor(TGConverterProcess.this.dialog.getDisplay().getSystemCursor(0));
                    }
                }
            });
        }
    }

    protected void appendLogMessage(int result, String fileName) {
        String message = TuxGuitar.getProperty((String)("batch.converter.messages." + (result == 250 ? "ok" : "failed"))) + EOL;
        switch (result) {
            case 401: {
                message = message + TuxGuitar.getProperty((String)"batch.converter.messages.couldnt-write", (String[])new String[]{fileName}) + EOL;
                break;
            }
            case 403: {
                message = message + TuxGuitar.getProperty((String)"batch.converter.messages.bad-file", (String[])new String[]{fileName}) + EOL;
                break;
            }
            case 404: {
                message = message + TuxGuitar.getProperty((String)"batch.converter.messages.file-not-found", (String[])new String[]{fileName}) + EOL;
                break;
            }
            case 500: {
                message = message + TuxGuitar.getProperty((String)"batch.converter.messages.out-of-memory", (String[])new String[]{fileName}) + EOL;
                break;
            }
            case 590: {
                message = message + TuxGuitar.getProperty((String)"batch.converter.messages.exporter-not-found", (String[])new String[]{fileName}) + EOL;
                break;
            }
            case 666: {
                message = message + TuxGuitar.getProperty((String)"batch.converter.messages.unknown-error", (String[])new String[]{fileName}) + EOL;
            }
        }
        StyleRange range = new StyleRange();
        range.foreground = result == 250 ? COLOR_INFO : COLOR_ERROR;
        range.start = this.output.getCharCount();
        range.length = message.length();
        this.output.append(message);
        this.output.setStyleRange(range);
    }

    public void processEvent(TGEvent event) {
        if ("ui-icon".equals(event.getEventType())) {
            this.loadIcons();
        } else if ("language".equals(event.getEventType())) {
            this.loadProperties();
        }
    }
}

