/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.custom.tuner;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.graphics.TGColorImpl;
import org.herac.tuxguitar.app.graphics.TGFontImpl;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTunerRoughWidget;
import org.herac.tuxguitar.graphics.TGColor;
import org.herac.tuxguitar.graphics.TGFont;

public class TGTunerFineWidget
extends Composite {
    private static final int MIN_HEIGHT = 60;
    private static final int MIN_WIDTH = 80;
    private final float bottomY = 10.0f;
    private Composite composite = null;
    protected String currentNoteString = null;
    protected int currentNoteValue = -1;
    protected double currentFrequency = 0.0;
    protected Font letterFont = null;
    protected final float FINE_TUNING_RANGE = 1.5f;

    public TGTunerFineWidget(Composite parent) {
        super(parent, 0);
        this.setEnabled(false);
        this.init();
    }

    protected void init() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.composite = new Composite((Composite)this, 0x20000800);
        this.composite.setBackground(this.getDisplay().getSystemColor(1));
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TGPainterImpl painter = new TGPainterImpl(e.gc);
                TGTunerFineWidget.this.paintWidget(painter);
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 60;
        data.minimumWidth = 80;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.composite.setLayoutData((Object)data);
        this.letterFont = new Font((Device)this.getDisplay(), TuxGuitar.getInstance().getConfig().getFontDataConfigValue("matrix.font").getName(), 14, 1);
    }

    public void paintWidget(TGPainterImpl painter) {
        Point compositeSize = this.composite.getSize();
        painter.setForeground((TGColor)new TGColorImpl(this.getDisplay().getSystemColor(2)));
        painter.initPath();
        painter.setLineWidth(2.0f);
        float height = (float)compositeSize.y - this.bottomY - 25.0f;
        painter.moveTo((float)(compositeSize.x / 2), (float)compositeSize.y - this.bottomY);
        painter.lineTo((float)(compositeSize.x / 2), 25.0f);
        painter.closePath();
        painter.initPath();
        height = Math.min(height, (float)(compositeSize.x / 2));
        painter.moveTo((float)(compositeSize.x / 2) - height, (float)compositeSize.y - this.bottomY);
        painter.lineTo((float)(compositeSize.x / 2) + height, (float)compositeSize.y - this.bottomY);
        painter.closePath();
        if (this.isEnabled()) {
            painter.setForeground((TGColor)new TGColorImpl(this.getDisplay().getSystemColor(9)));
            painter.setFont((TGFont)new TGFontImpl(this.letterFont));
            painter.drawString(this.currentNoteString, (float)(compositeSize.x * 12 / 15), 10.0f);
            if (this.currentFrequency != -1.0) {
                painter.setLineWidth(3.0f);
                painter.setForeground((TGColor)new TGColorImpl(this.getDisplay().getSystemColor(3)));
                painter.initPath();
                painter.moveTo((float)(compositeSize.x / 2), (float)compositeSize.y - this.bottomY);
                painter.lineTo((float)((double)(compositeSize.x / 2) + (double)height * Math.cos(this.getAngleRad())), (float)((double)((float)compositeSize.y - this.bottomY) - (double)height * Math.sin(this.getAngleRad())));
                painter.closePath();
            }
        }
    }

    public void setWantedTone(int tone) {
        this.setEnabled(true);
        this.currentNoteValue = tone;
        this.currentNoteString = TGTunerRoughWidget.TONESSTRING[tone % 12] + (int)Math.floor(tone / 12);
        this.redraw();
    }

    public void setCurrentFrequency(double freq) {
        this.currentFrequency = freq;
        this.redraw();
    }

    public void redraw() {
        super.redraw();
        this.composite.redraw();
    }

    protected double getAngleRad() {
        double d = this.stickDistance(this.getTone(this.currentFrequency) - (float)this.currentNoteValue);
        ((Object)((Object)this)).getClass();
        return Math.PI * (1.0 - (d + 1.5) / (double)(2.0f * this.FINE_TUNING_RANGE));
    }

    private float getTone(double frequency) {
        return (float)(45.0 + 12.0 * (Math.log(frequency / 110.0) / Math.log(2.0)));
    }

    private double stickDistance(double diff) {
        double d = Math.abs(diff);
        ((Object)((Object)this)).getClass();
        if (d > 1.5) {
            if (diff > 0.0) {
                ((Object)((Object)this)).getClass();
                return 1.5;
            }
            return -this.FINE_TUNING_RANGE;
        }
        return diff;
    }
}

