/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.custom.tuner;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTuner;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTunerFineWidget;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTunerListener;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTunerRoughWidget;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTunerSettingsDialog;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTuningString;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;
import org.herac.tuxguitar.util.error.TGErrorManager;

public class TGTunerDialog
implements TGTunerListener {
    private static final int SHELL_WIDTH = 400;
    private TGContext context;
    protected TGTuner tuner = null;
    protected int[] tuning = null;
    protected Label currentFrequency = null;
    protected Shell dialog = null;
    protected TGTunerRoughWidget roughTuner = null;
    protected List<TGTuningString> allStringButtons = null;
    protected TGTunerFineWidget fineTuner = null;

    public TGTunerDialog(TGContext context, int[] tuning) {
        this.context = context;
        this.tuning = tuning;
    }

    public void show() {
        this.dialog = DialogUtils.newDialog((Shell)TuxGuitar.getInstance().getShell(), (int)2160);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        this.dialog.setText(TuxGuitar.getProperty((String)"tuner.instrument-tuner"));
        this.dialog.setMinimumSize(400, -1);
        this.dialog.setSize(700, 400);
        Group group = new Group((Composite)this.dialog, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"tuner.tuner"));
        Composite specialComposite = new Composite((Composite)group, 0);
        specialComposite.setLayout((Layout)new GridLayout(2, false));
        specialComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.allStringButtons = new ArrayList<TGTuningString>(this.tuning.length);
        this.fineTuner = new TGTunerFineWidget(specialComposite);
        Composite buttonsComposite = new Composite(specialComposite, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < this.tuning.length; ++i) {
            this.createTuningString(this.tuning[i], buttonsComposite);
        }
        Composite tunComposite = new Composite((Composite)group, 0);
        tunComposite.setLayout((Layout)new GridLayout(1, false));
        tunComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.currentFrequency = new Label(tunComposite, 16384);
        this.currentFrequency.setLayoutData((Object)new GridData(4, 4, true, true));
        this.roughTuner = new TGTunerRoughWidget((Composite)group);
        Composite btnComposite = new Composite((Composite)group, 0);
        btnComposite.setLayout((Layout)new GridLayout(2, false));
        btnComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Button buttonSettings = new Button(btnComposite, 8);
        buttonSettings.setText(TuxGuitar.getProperty((String)"settings"));
        buttonSettings.setLayoutData((Object)TGTunerDialog.getGridData(80, 25));
        buttonSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGTunerDialog.this.getTuner().pause();
                new TGTunerSettingsDialog(TGTunerDialog.this).show();
            }
        });
        Button buttonExit = new Button(btnComposite, 8);
        buttonExit.setText(TuxGuitar.getProperty((String)"close"));
        buttonExit.setLayoutData((Object)TGTunerDialog.getGridData(80, 25));
        buttonExit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGTunerDialog.this.getTuner().setCanceled(true);
                TGTunerDialog.this.dialog.dispose();
            }
        });
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                TGTunerDialog.this.getTuner().setCanceled(true);
                TGTunerDialog.this.dialog.dispose();
            }
        });
        DialogUtils.openDialog((Shell)this.dialog, (int)10);
        this.tuner = new TGTuner(this);
        this.getTuner().start();
    }

    static GridData getGridData(int minimumWidth, int minimumHeight) {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = minimumWidth;
        data.minimumHeight = minimumHeight;
        return data;
    }

    public void fireFrequency(final double freq) {
        if (!this.dialog.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() {
                    if (!TGTunerDialog.this.dialog.isDisposed() && !TGTunerDialog.this.roughTuner.isDisposed()) {
                        TGTunerDialog.this.currentFrequency.setText(Math.floor(freq) + " Hz");
                        TGTunerDialog.this.roughTuner.setCurrentFrequency(freq);
                    }
                    if (!TGTunerDialog.this.dialog.isDisposed() && !TGTunerDialog.this.fineTuner.isDisposed()) {
                        TGTunerDialog.this.fineTuner.setCurrentFrequency(freq);
                    }
                }
            });
        }
    }

    public TGTuner getTuner() {
        return this.tuner;
    }

    public int[] getTuning() {
        return this.tuning;
    }

    public void fireException(Exception ex) {
        TGErrorManager.getInstance((TGContext)this.context).handleError((Throwable)ex);
    }

    public void fireCurrentString(int string) {
        this.tuner.pause();
        if (string == 0) {
            this.tuner.setWantedRange();
            this.fineTuner.setEnabled(false);
        } else {
            this.tuner.setWantedNote(string);
            this.fineTuner.setWantedTone(string);
        }
        this.tuner.resumeFromPause();
    }

    protected void createTuningString(int midiNote, Composite parent) {
        TGTuningString tempString = new TGTuningString(midiNote, parent, this);
        this.allStringButtons.add(tempString);
        tempString.getStringButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGTunerDialog.this.fineTuner.setCurrentFrequency(-1.0);
                for (TGTuningString tmp : TGTunerDialog.this.allStringButtons) {
                    tmp.getStringButton().setSelection(false);
                }
            }
        });
        tempString.addListener();
    }

    public TGContext getContext() {
        return this.context;
    }
}

