/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import org.herac.tuxguitar.graphics.TGColor;
import org.herac.tuxguitar.graphics.TGImage;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.TGResourceFactory;
import org.herac.tuxguitar.graphics.control.TGResourceBuffer;

public class TGMeasureBuffer {
    private float width;
    private float height;

    public Object getRegistryKey() {
        return this;
    }

    public void register(TGResourceBuffer resourceBuffer) {
        resourceBuffer.register(this.getRegistryKey());
    }

    public TGPainter createBuffer(TGResourceBuffer resourceBuffer, TGResourceFactory resourceFactory, float width, float height, TGColor background) {
        TGImage buffer = resourceFactory.createImage(width, height);
        this.width = buffer.getWidth();
        this.height = buffer.getHeight();
        TGPainter bufferedPainter = buffer.createPainter();
        bufferedPainter.setBackground(background);
        bufferedPainter.initPath(2);
        bufferedPainter.addRectangle(0.0f, 0.0f, this.width, this.height);
        bufferedPainter.closePath();
        resourceBuffer.setResource(this.getRegistryKey(), buffer);
        return bufferedPainter;
    }

    public void paintBuffer(TGResourceBuffer resourceBuffer, TGPainter painter, float x, float y, float srcY) {
        TGImage buffer = (TGImage)resourceBuffer.getResource(this.getRegistryKey());
        painter.drawImage(buffer, 0.0f, srcY, this.width, this.height - srcY, x, y + srcY, this.width, this.height - srcY);
    }

    public boolean isDisposed(TGResourceBuffer resourceBuffer) {
        return resourceBuffer.isResourceDisposed(this.getRegistryKey());
    }
}

