/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.TGRectangle;
import org.herac.tuxguitar.graphics.control.TGController;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGLyricImpl;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.graphics.control.TGTrackSpacing;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGLayoutVertical
extends TGLayout {
    private float maximumWidth;
    private float marginLeft;
    private float marginRight;

    public TGLayoutVertical(TGController controller, int style) {
        super(controller, style);
    }

    public int getMode() {
        return 1;
    }

    public void paintSong(TGPainter painter, TGRectangle clientArea, float fromX, float fromY) {
        this.marginLeft = this.getFirstMeasureSpacing();
        this.marginRight = 10.0f;
        this.maximumWidth = clientArea.getWidth() - (this.marginLeft + this.marginRight);
        this.setHeight(0.0f);
        this.setWidth(0.0f);
        this.clearTrackPositions();
        int style = this.getStyle();
        int number = this.getComponent().getTrackSelection();
        float posY = Math.round(fromY + this.getFirstTrackSpacing());
        float height = this.getFirstTrackSpacing();
        float lineHeight = 0.0f;
        int measureCount = this.getSong().countMeasureHeaders();
        int nextMeasureIndex = 0;
        while (measureCount > nextMeasureIndex) {
            TempLine line = null;
            Iterator<TGTrack> tracks = this.getSong().getTracks();
            while (tracks.hasNext()) {
                TGTrackImpl track = (TGTrackImpl)tracks.next();
                if (number >= 0 && track.getNumber() != number) continue;
                TGTrackSpacing ts = new TGTrackSpacing(this);
                ts.setSize(8, (style & 4) != 0 ? this.getScoreLineSpacing() * 5.0f : 0.0f);
                if (nextMeasureIndex == 0) {
                    ((TGLyricImpl)track.getLyrics()).start();
                }
                line = this.getTempLines(track, nextMeasureIndex, ts);
                if ((style & 4) != 0) {
                    ts.setSize(7, Math.abs(line.minY));
                    if (line.maxY > track.getScoreHeight()) {
                        ts.setSize(9, line.maxY - track.getScoreHeight());
                    }
                }
                if ((style & 8) != 0) {
                    ts.setSize(12, (style & 4) != 0 ? this.getMinScoreTabSpacing() : Math.max(Math.abs(line.minY), this.getStringSpacing()));
                    ts.setSize(13, (style & 4) != 0 ? track.getTabHeight() + this.getStringSpacing() + 1.0f : Math.max(line.maxY, track.getTabHeight() + this.getStringSpacing() + 1.0f));
                }
                ts.setSize(14, 10.0f);
                this.checkDefaultSpacing(ts);
                this.paintLine(track, line, painter, fromX, posY, ts, clientArea);
                lineHeight = ts.getSize();
                this.addTrackPosition(track.getNumber(), posY, lineHeight);
                float emptyX = this.marginLeft + fromX + line.tempWith + 2.0f;
                float emptyWith = this.maximumWidth - emptyX;
                if (emptyWith - 20.0f > 0.0f && line.lastIndex + 1 >= measureCount && emptyX < clientArea.getX() + clientArea.getWidth()) {
                    emptyX = emptyX < clientArea.getX() ? clientArea.getX() : emptyX;
                    emptyWith = emptyWith > clientArea.getWidth() ? clientArea.getWidth() : emptyWith;
                    this.paintLines(track, ts, painter, emptyX, posY, emptyWith);
                }
                float lineHeightWithSpacing = Math.round(lineHeight + this.getTrackSpacing() + 0.5f);
                posY += lineHeightWithSpacing;
                height += lineHeightWithSpacing;
            }
            if (line == null) continue;
            nextMeasureIndex = line.lastIndex + 1;
        }
        this.setHeight(height);
        this.setWidth(this.getWidth() + this.marginRight);
    }

    public void paintLine(TGTrackImpl track, TempLine line, TGPainter painter, float fromX, float fromY, TGTrackSpacing ts, TGRectangle clientArea) {
        float diff;
        float posX = Math.round(this.marginLeft + fromX);
        float posY = Math.round(fromY);
        float width = this.marginLeft;
        boolean isAtY = posY + ts.getSize() > clientArea.getY() && posY < clientArea.getY() + clientArea.getHeight() + this.getScale() * 80.0f;
        float defaultMeasureSpacing = 0.0f;
        if (line.fullLine && (diff = this.maximumWidth - line.tempWith) != 0.0f && line.measures.size() > 0) {
            defaultMeasureSpacing = diff / (float)line.measures.size();
        }
        float measureSpacing = defaultMeasureSpacing;
        for (int i = 0; i < line.measures.size(); ++i) {
            boolean isAtX;
            int index = line.measures.get(i);
            TGMeasureImpl currMeasure = (TGMeasureImpl)track.getMeasure(index);
            currMeasure.setPosX(posX);
            currMeasure.setPosY(posY);
            currMeasure.setTs(ts);
            ((TGLyricImpl)track.getLyrics()).setCurrentMeasure(currMeasure);
            currMeasure.setFirstOfLine(i == 0);
            float measureWidth = currMeasure.getWidth(this);
            float measureWidthWithSpacing = this.isBufferEnabled() ? (float)Math.round(measureWidth + measureSpacing) : measureWidth + measureSpacing;
            float measureSpacingAfterRound = measureWidthWithSpacing - measureWidth;
            boolean bl = isAtX = posX + measureWidthWithSpacing > clientArea.getX() && posX < clientArea.getX() + clientArea.getWidth();
            if (isAtX && isAtY) {
                this.paintMeasure(currMeasure, painter, measureSpacingAfterRound);
                ((TGLyricImpl)track.getLyrics()).paintCurrentNoteBeats(painter, this, currMeasure, posX, posY);
            } else {
                currMeasure.setOutOfBounds(true);
            }
            posX += measureWidthWithSpacing;
            width += measureWidthWithSpacing;
            measureSpacing = defaultMeasureSpacing + (measureSpacing - measureSpacingAfterRound);
        }
        this.setWidth(Math.max(this.getWidth(), width));
    }

    public TempLine getTempLines(TGTrack track, int fromIndex, TGTrackSpacing ts) {
        int style = this.getStyle();
        TempLine line = new TempLine();
        line.maxY = 0.0f;
        line.minY = 0.0f;
        if ((style & 8) == 0 && (style & 4) != 0) {
            line.maxY = this.getScoreLineSpacing() * 4.0f + this.getScoreLineSpacing() * 4.0f;
            line.minY = -(this.getScoreLineSpacing() * 3.0f);
        }
        int measureCount = track.countMeasures();
        for (int measureIdx = fromIndex; measureIdx < measureCount; ++measureIdx) {
            TGMeasureImpl measure = (TGMeasureImpl)track.getMeasure(measureIdx);
            if (line.tempWith + measure.getWidth(this) >= this.maximumWidth) {
                if (line.measures.isEmpty()) {
                    this.addToTempLine(line, ts, measure, measureIdx);
                }
                line.fullLine = true;
                return line;
            }
            this.addToTempLine(line, ts, measure, measureIdx);
        }
        return line;
    }

    public void addToTempLine(TempLine line, TGTrackSpacing ts, TGMeasureImpl measure, int measureIdx) {
        line.tempWith += measure.getWidth(this);
        line.maxY = measure.getMaxY() > line.maxY ? measure.getMaxY() : line.maxY;
        line.minY = measure.getMinY() < line.minY ? measure.getMinY() : line.minY;
        line.addMeasure(measureIdx);
        measure.registerSpacing(this, ts);
    }

    private class TempLine {
        protected float tempWith;
        protected int lastIndex;
        protected boolean fullLine;
        protected float maxY = 0.0f;
        protected float minY = 0.0f;
        protected List<Integer> measures = new ArrayList<Integer>();

        protected void addMeasure(int index) {
            this.measures.add(new Integer(index));
            this.lastIndex = index;
        }
    }
}

