/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.app.view.toolbar.TGToolBar;
import org.herac.tuxguitar.app.view.toolbar.TGToolBarSection;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGLayoutHorizontal;
import org.herac.tuxguitar.graphics.control.TGLayoutVertical;

public class TGToolBarSectionLayout
implements TGToolBarSection {
    private ToolItem menuItem;

    public void createSection(final TGToolBar toolBar) {
        this.menuItem = new ToolItem(toolBar.getControl(), 8);
        this.menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TGToolBarSectionLayout.this.createMenu(toolBar, (ToolItem)event.widget);
            }
        });
        this.loadIcons(toolBar);
        this.loadProperties(toolBar);
    }

    public void loadProperties(TGToolBar toolBar) {
        this.menuItem.setToolTipText(toolBar.getText("view.layout"));
    }

    public void loadIcons(TGToolBar toolBar) {
        this.menuItem.setImage(toolBar.getIconManager().getLayoutScore());
    }

    public void updateItems(TGToolBar toolBar) {
    }

    public void createMenu(TGToolBar toolBar, ToolItem item) {
        TGLayout layout = toolBar.getTablature().getViewLayout();
        int style = layout.getStyle();
        Menu menu = new Menu((Control)item.getParent().getShell());
        MenuItem pageLayout = new MenuItem(menu, 8);
        pageLayout.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.view.layout-set-page"));
        pageLayout.setText(toolBar.getText("view.layout.page", layout instanceof TGLayoutVertical));
        pageLayout.setImage(toolBar.getIconManager().getLayoutPage());
        MenuItem linearLayout = new MenuItem(menu, 8);
        linearLayout.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.view.layout-set-linear"));
        linearLayout.setText(toolBar.getText("view.layout.linear", layout instanceof TGLayoutHorizontal));
        linearLayout.setImage(toolBar.getIconManager().getLayoutLinear());
        MenuItem multitrack = new MenuItem(menu, 8);
        multitrack.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.view.layout-set-multitrack"));
        multitrack.setText(toolBar.getText("view.layout.multitrack", (style & 2) != 0));
        multitrack.setImage(toolBar.getIconManager().getLayoutMultitrack());
        MenuItem scoreEnabled = new MenuItem(menu, 8);
        scoreEnabled.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.view.layout-set-score-enabled"));
        scoreEnabled.setText(toolBar.getText("view.layout.score-enabled", (style & 4) != 0));
        scoreEnabled.setImage(toolBar.getIconManager().getLayoutScore());
        MenuItem compact = new MenuItem(menu, 8);
        compact.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.view.layout-set-compact"));
        compact.setText(toolBar.getText("view.layout.compact", (style & 1) != 0));
        compact.setImage(toolBar.getIconManager().getLayoutCompact());
        compact.setEnabled((style & 2) == 0 || toolBar.getSong().countTracks() == 1);
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        menu.setLocation(pt.x, pt.y + rect.height);
        menu.setVisible(true);
    }
}

