/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.toolbar.TGToolBar;
import org.herac.tuxguitar.app.view.toolbar.TGToolBarSection;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.util.TGContext;

public class TGToolBarSectionEffect
implements TGToolBarSection {
    private ToolItem menuItem;

    public void createSection(final TGToolBar toolBar) {
        this.menuItem = new ToolItem(toolBar.getControl(), 8);
        this.menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TGToolBarSectionEffect.this.createMenu(toolBar, (ToolItem)event.widget);
            }
        });
        this.loadIcons(toolBar);
        this.loadProperties(toolBar);
    }

    public void loadProperties(TGToolBar toolBar) {
        this.menuItem.setToolTipText(toolBar.getText("effects"));
    }

    public void loadIcons(TGToolBar toolBar) {
        this.menuItem.setImage(toolBar.getIconManager().getEffectVibrato());
    }

    public void updateItems(TGToolBar toolBar) {
        boolean running = MidiPlayer.getInstance((TGContext)toolBar.getContext()).isRunning();
        TGNote note = TablatureEditor.getInstance(toolBar.getContext()).getTablature().getCaret().getSelectedNote();
        this.menuItem.setEnabled(!running && note != null);
    }

    public void createMenu(TGToolBar toolBar, ToolItem item) {
        boolean running = MidiPlayer.getInstance((TGContext)toolBar.getContext()).isRunning();
        TGNote note = TablatureEditor.getInstance(toolBar.getContext()).getTablature().getCaret().getSelectedNote();
        Menu menu = new Menu((Control)item.getParent().getShell());
        MenuItem deadNote = new MenuItem(menu, 8);
        deadNote.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.effect.change-dead"));
        deadNote.setEnabled(!running && note != null);
        deadNote.setText(toolBar.getText("effects.deadnote", note != null && note.getEffect().isDeadNote()));
        deadNote.setImage(TuxGuitar.getInstance().getIconManager().getEffectDead());
        MenuItem ghostNote = new MenuItem(menu, 8);
        ghostNote.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.effect.change-ghost"));
        ghostNote.setEnabled(!running && note != null);
        ghostNote.setImage(TuxGuitar.getInstance().getIconManager().getEffectGhost());
        ghostNote.setText(toolBar.getText("effects.ghostnote", note != null && note.getEffect().isGhostNote()));
        MenuItem accentuatedNote = new MenuItem(menu, 8);
        accentuatedNote.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.effect.change-accentuated"));
        accentuatedNote.setEnabled(!running && note != null);
        accentuatedNote.setText(toolBar.getText("effects.accentuatednote", note != null && note.getEffect().isAccentuatedNote()));
        accentuatedNote.setImage(TuxGuitar.getInstance().getIconManager().getEffectAccentuated());
        MenuItem heavyAccentuatedNote = new MenuItem(menu, 8);
        heavyAccentuatedNote.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.effect.change-heavy-accentuated"));
        heavyAccentuatedNote.setEnabled(!running && note != null);
        heavyAccentuatedNote.setText(toolBar.getText("effects.heavyaccentuatednote", note != null && note.getEffect().isHeavyAccentuatedNote()));
        heavyAccentuatedNote.setImage(TuxGuitar.getInstance().getIconManager().getEffectHeavyAccentuated());
        MenuItem harmonicNote = new MenuItem(menu, 8);
        harmonicNote.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.open-harmonic-dialog"));
        harmonicNote.setEnabled(!running && note != null);
        harmonicNote.setText(toolBar.getText("effects.harmonic", note != null && note.getEffect().isHarmonic()));
        harmonicNote.setImage(TuxGuitar.getInstance().getIconManager().getEffectHarmonic());
        MenuItem graceNote = new MenuItem(menu, 8);
        graceNote.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.open-grace-dialog"));
        graceNote.setEnabled(!running && note != null);
        graceNote.setText(toolBar.getText("effects.grace", note != null && note.getEffect().isGrace()));
        graceNote.setImage(TuxGuitar.getInstance().getIconManager().getEffectGrace());
        new MenuItem(menu, 2);
        MenuItem vibrato = new MenuItem(menu, 8);
        vibrato.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.effect.change-vibrato"));
        vibrato.setEnabled(!running && note != null);
        vibrato.setText(toolBar.getText("effects.vibrato", note != null && note.getEffect().isVibrato()));
        vibrato.setImage(TuxGuitar.getInstance().getIconManager().getEffectVibrato());
        MenuItem bend = new MenuItem(menu, 8);
        bend.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.open-bend-dialog"));
        bend.setEnabled(!running && note != null);
        bend.setText(toolBar.getText("effects.bend", note != null && note.getEffect().isBend()));
        bend.setImage(TuxGuitar.getInstance().getIconManager().getEffectBend());
        MenuItem tremoloBar = new MenuItem(menu, 8);
        tremoloBar.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.open-tremolo-bar-dialog"));
        tremoloBar.setEnabled(!running && note != null);
        tremoloBar.setText(toolBar.getText("effects.tremolo-bar", note != null && note.getEffect().isTremoloBar()));
        tremoloBar.setImage(TuxGuitar.getInstance().getIconManager().getEffectTremoloBar());
        MenuItem slide = new MenuItem(menu, 8);
        slide.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.effect.change-slide"));
        slide.setEnabled(!running && note != null);
        slide.setText(toolBar.getText("effects.slide", note != null && note.getEffect().isSlide()));
        slide.setImage(TuxGuitar.getInstance().getIconManager().getEffectSlide());
        MenuItem hammer = new MenuItem(menu, 8);
        hammer.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.effect.change-hammer"));
        hammer.setEnabled(!running && note != null);
        hammer.setText(toolBar.getText("effects.hammer", note != null && note.getEffect().isHammer()));
        hammer.setImage(TuxGuitar.getInstance().getIconManager().getEffectHammer());
        new MenuItem(menu, 2);
        MenuItem trill = new MenuItem(menu, 8);
        trill.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.open-trill-dialog"));
        trill.setEnabled(!running && note != null);
        trill.setText(toolBar.getText("effects.trill", note != null && note.getEffect().isTrill()));
        trill.setImage(TuxGuitar.getInstance().getIconManager().getEffectTrill());
        MenuItem tremoloPicking = new MenuItem(menu, 8);
        tremoloPicking.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.open-tremolo-picking-dialog"));
        tremoloPicking.setEnabled(!running && note != null);
        tremoloPicking.setText(toolBar.getText("effects.tremolo-picking", note != null && note.getEffect().isTremoloPicking()));
        tremoloPicking.setImage(TuxGuitar.getInstance().getIconManager().getEffectTremoloPicking());
        MenuItem palmMute = new MenuItem(menu, 8);
        palmMute.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.effect.change-palm-mute"));
        palmMute.setEnabled(!running && note != null);
        palmMute.setText(toolBar.getText("effects.palm-mute", note != null && note.getEffect().isPalmMute()));
        palmMute.setImage(TuxGuitar.getInstance().getIconManager().getEffectPalmMute());
        MenuItem staccato = new MenuItem(menu, 8);
        staccato.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.effect.change-staccato"));
        staccato.setEnabled(!running && note != null);
        staccato.setText(toolBar.getText("effects.staccato", note != null && note.getEffect().isStaccato()));
        staccato.setImage(TuxGuitar.getInstance().getIconManager().getEffectStaccato());
        new MenuItem(menu, 2);
        MenuItem tapping = new MenuItem(menu, 8);
        tapping.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.effect.change-tapping"));
        tapping.setEnabled(!running && note != null);
        tapping.setText(toolBar.getText("effects.tapping", note != null && note.getEffect().isTapping()));
        tapping.setImage(TuxGuitar.getInstance().getIconManager().getEffectTapping());
        MenuItem slapping = new MenuItem(menu, 8);
        slapping.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.effect.change-slapping"));
        slapping.setEnabled(!running && note != null);
        slapping.setText(toolBar.getText("effects.slapping", note != null && note.getEffect().isSlapping()));
        slapping.setImage(TuxGuitar.getInstance().getIconManager().getEffectSlapping());
        MenuItem popping = new MenuItem(menu, 8);
        popping.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.effect.change-popping"));
        popping.setEnabled(!running && note != null);
        popping.setText(toolBar.getText("effects.popping", note != null && note.getEffect().isPopping()));
        popping.setImage(TuxGuitar.getInstance().getIconManager().getEffectPopping());
        new MenuItem(menu, 2);
        MenuItem fadeIn = new MenuItem(menu, 8);
        fadeIn.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.effect.change-fade-in"));
        fadeIn.setEnabled(!running && note != null);
        fadeIn.setText(toolBar.getText("effects.fade-in", note != null && note.getEffect().isFadeIn()));
        fadeIn.setImage(TuxGuitar.getInstance().getIconManager().getEffectFadeIn());
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        menu.setLocation(pt.x, pt.y + rect.height);
        menu.setVisible(true);
    }
}

