/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.view.component.tab.Caret;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.app.view.toolbar.TGToolBar;
import org.herac.tuxguitar.app.view.toolbar.TGToolBarSection;
import org.herac.tuxguitar.song.models.TGNote;

public class TGToolBarSectionDynamic
implements TGToolBarSection {
    private ToolItem menuItem;
    private Map<Integer, String> dynamicNameKeys = new HashMap<Integer, String>();
    private Integer dynamicValue;

    public TGToolBarSectionDynamic() {
        this.dynamicNameKeys.put(15, "dynamic.piano-pianissimo");
        this.dynamicNameKeys.put(31, "dynamic.pianissimo");
        this.dynamicNameKeys.put(47, "dynamic.piano");
        this.dynamicNameKeys.put(63, "dynamic.mezzo-piano");
        this.dynamicNameKeys.put(79, "dynamic.mezzo-forte");
        this.dynamicNameKeys.put(95, "dynamic.forte");
        this.dynamicNameKeys.put(111, "dynamic.fortissimo");
        this.dynamicNameKeys.put(127, "dynamic.forte-fortissimo");
    }

    public void createSection(final TGToolBar toolBar) {
        this.menuItem = new ToolItem(toolBar.getControl(), 8);
        this.menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TGToolBarSectionDynamic.this.createMenu(toolBar, (ToolItem)event.widget);
            }
        });
        this.loadIcons(toolBar);
        this.loadProperties(toolBar);
    }

    public void loadProperties(TGToolBar toolBar) {
        this.menuItem.setToolTipText(toolBar.getText("dynamic"));
    }

    public void loadIcons(TGToolBar toolBar) {
        this.loadDynamicIcon(toolBar, true);
    }

    public void loadDynamicIcon(TGToolBar toolBar, boolean force) {
        Image icon;
        int dynamicValue = 95;
        Tablature tablature = toolBar.getTablature();
        if (tablature != null) {
            Caret caret = tablature.getCaret();
            TGNote selectedNote = caret.getSelectedNote();
            int n = dynamicValue = selectedNote != null ? selectedNote.getVelocity() : caret.getVelocity();
        }
        if ((force || this.dynamicValue == null || !this.dynamicValue.equals(dynamicValue)) && (icon = this.getDynamicIcon(toolBar, dynamicValue)) != null) {
            this.menuItem.setImage(icon);
            this.dynamicValue = dynamicValue;
        }
    }

    public void updateItems(TGToolBar toolBar) {
        this.loadDynamicIcon(toolBar, false);
    }

    public void createMenu(TGToolBar toolBar, ToolItem item) {
        Caret caret = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret();
        int selection = caret.getSelectedNote() != null ? caret.getSelectedNote().getVelocity() : caret.getVelocity();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        Menu menu = new Menu((Control)item.getParent().getShell());
        this.createMenuItem(toolBar, menu, 15, selection, running);
        this.createMenuItem(toolBar, menu, 31, selection, running);
        this.createMenuItem(toolBar, menu, 47, selection, running);
        this.createMenuItem(toolBar, menu, 63, selection, running);
        this.createMenuItem(toolBar, menu, 79, selection, running);
        this.createMenuItem(toolBar, menu, 95, selection, running);
        this.createMenuItem(toolBar, menu, 111, selection, running);
        this.createMenuItem(toolBar, menu, 127, selection, running);
        menu.setLocation(pt.x, pt.y + rect.height);
        menu.setVisible(true);
    }

    private void createMenuItem(TGToolBar toolBar, Menu menu, int velocity, int selection, boolean running) {
        Image icon;
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setEnabled(!running);
        menuItem.addSelectionListener((SelectionListener)this.createChangeVelocityAction(toolBar, velocity));
        String nameKey = this.getNameKey(velocity);
        if (nameKey != null) {
            menuItem.setText(toolBar.getText(nameKey, velocity == selection));
        }
        if ((icon = this.getDynamicIcon(toolBar, velocity)) != null) {
            menuItem.setImage(icon);
        }
    }

    private String getNameKey(int velocity) {
        if (this.dynamicNameKeys.containsKey(velocity)) {
            return this.dynamicNameKeys.get(velocity);
        }
        return null;
    }

    private Image getDynamicIcon(TGToolBar toolBar, int velocity) {
        TGIconManager iconManager = toolBar.getIconManager();
        if (velocity == 15) {
            return iconManager.getDynamicPPP();
        }
        if (velocity == 31) {
            return iconManager.getDynamicPP();
        }
        if (velocity == 47) {
            return iconManager.getDynamicP();
        }
        if (velocity == 63) {
            return iconManager.getDynamicMP();
        }
        if (velocity == 79) {
            return iconManager.getDynamicMF();
        }
        if (velocity == 95) {
            return iconManager.getDynamicF();
        }
        if (velocity == 111) {
            return iconManager.getDynamicFF();
        }
        if (velocity == 127) {
            return iconManager.getDynamicFFF();
        }
        return null;
    }

    public TGActionProcessorListener createChangeVelocityAction(TGToolBar toolBar, Integer velocity) {
        TGActionProcessorListener tgActionProcessor = toolBar.createActionProcessor("action.note.general.velocity");
        tgActionProcessor.setAttribute("velocity", velocity);
        return tgActionProcessor;
    }
}

