/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.settings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.impl.view.TGOpenViewAction;
import org.herac.tuxguitar.app.system.config.TGConfigDefaults;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.confirm.TGConfirmDialog;
import org.herac.tuxguitar.app.view.dialog.confirm.TGConfirmDialogController;
import org.herac.tuxguitar.app.view.dialog.settings.items.LanguageOption;
import org.herac.tuxguitar.app.view.dialog.settings.items.MainOption;
import org.herac.tuxguitar.app.view.dialog.settings.items.Option;
import org.herac.tuxguitar.app.view.dialog.settings.items.SkinOption;
import org.herac.tuxguitar.app.view.dialog.settings.items.SoundOption;
import org.herac.tuxguitar.app.view.dialog.settings.items.StylesOption;
import org.herac.tuxguitar.app.view.util.TGCursorController;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.util.properties.TGProperties;

public class TGSettingsEditor {
    private TGViewContext context;
    private TGCursorController cursorController;
    private Shell dialog;
    private TGConfigManager config;
    private List<Option> options;
    private TGProperties defaults;
    private List<Runnable> runnables;

    public TGSettingsEditor(TGViewContext context) {
        this.context = context;
        this.config = TGConfigManager.getInstance(this.context.getContext());
    }

    public void show() {
        Shell parent = (Shell)this.context.getAttribute("parent");
        this.dialog = DialogUtils.newDialog(parent, 67680);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("settings.config"));
        Composite mainComposite = new Composite((Composite)this.dialog, 0);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createComposites(mainComposite);
        Composite buttonComposite = new Composite((Composite)this.dialog, 0);
        buttonComposite.setLayout((Layout)new GridLayout(3, true));
        buttonComposite.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button buttonDefaults = new Button(buttonComposite, 8);
        buttonDefaults.setLayoutData((Object)this.getButtonData());
        buttonDefaults.setText(TuxGuitar.getProperty("defaults"));
        buttonDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGSettingsEditor.this.dispose();
                TGSettingsEditor.this.setDefaults();
                TGSettingsEditor.this.applyConfigWithConfirmation(true);
            }
        });
        Button buttonOK = new Button(buttonComposite, 8);
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGSettingsEditor.this.updateOptions();
                TGSettingsEditor.this.dispose();
                TGSettingsEditor.this.applyConfigWithConfirmation(false);
            }
        });
        Button buttonCancel = new Button(buttonComposite, 8);
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGSettingsEditor.this.dispose();
            }
        });
        this.dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(this.dialog, 10);
    }

    private void createComposites(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 8389184);
        toolBar.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite option = new Composite(parent, 0);
        option.setLayout((Layout)new FormLayout());
        this.initOptions(toolBar, option);
        Point optionSize = this.computeOptionsSize(0, toolBar.computeSize((int)-1, (int)-1).y);
        option.setLayoutData((Object)new GridData(optionSize.x, optionSize.y));
        if (this.options.size() > 0) {
            this.select(this.options.get(0));
        }
    }

    private void initOptions(ToolBar toolBar, Composite parent) {
        this.options = new ArrayList<Option>();
        this.options.add(new MainOption(this, toolBar, parent));
        this.options.add(new StylesOption(this, toolBar, parent));
        this.options.add(new LanguageOption(this, toolBar, parent));
        this.options.add(new SkinOption(this, toolBar, parent));
        this.options.add(new SoundOption(this, toolBar, parent));
        for (Option option : this.options) {
            option.createOption();
        }
    }

    private Point computeOptionsSize(int minimumWidth, int minimumHeight) {
        int width = minimumWidth;
        int height = minimumHeight;
        for (Option option : this.options) {
            Point size = option.computeSize();
            if (size.x > width) {
                width = size.x;
            }
            if (size.y <= height) continue;
            height = size.y;
        }
        return new Point(width, height);
    }

    public void loadCursor(int cursorStyle) {
        if (!this.isDisposed()) {
            if (this.cursorController == null || !this.cursorController.isControlling((Control)this.dialog)) {
                this.cursorController = new TGCursorController(this.context.getContext(), (Control)this.dialog);
            }
            this.cursorController.loadCursor(cursorStyle);
        }
    }

    public void pack() {
        this.dialog.pack();
    }

    public GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    public GridData makeGridData(int with, int height, int minWith, int minHeight) {
        GridData data = new GridData();
        data.minimumWidth = minWith;
        data.minimumHeight = minHeight;
        if (with > 0) {
            data.widthHint = with;
        } else {
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
        }
        if (height > 0) {
            data.heightHint = with;
        } else {
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
        }
        return data;
    }

    public void select(Option option) {
        this.hideAll();
        option.setVisible(true);
        this.dialog.redraw();
    }

    private void hideAll() {
        for (Option option : this.options) {
            option.setVisible(false);
        }
    }

    protected void updateOptions() {
        for (Option option : this.options) {
            option.updateConfig();
        }
        this.config.save();
    }

    protected void setDefaults() {
        for (Option option : this.options) {
            option.updateDefaults();
        }
        this.config.save();
    }

    protected void applyConfigWithConfirmation(final boolean force) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.gui.open-view");
        tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGConfirmDialogController());
        tgActionProcessor.setAttribute("message", (Object)TuxGuitar.getProperty("settings.config.apply-changes-question"));
        tgActionProcessor.setAttribute("style", (Object)(TGConfirmDialog.BUTTON_YES | TGConfirmDialog.BUTTON_NO));
        tgActionProcessor.setAttribute("defaultButton", (Object)TGConfirmDialog.BUTTON_NO);
        tgActionProcessor.setAttribute("yesRunnable", (Object)new Runnable(){

            public void run() {
                TGSettingsEditor.this.applyConfig(force);
            }
        });
        tgActionProcessor.process();
    }

    protected void applyConfig(boolean force) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.system.reload-settings");
        tgActionProcessor.setAttribute("force", (Object)force);
        tgActionProcessor.process();
    }

    protected void dispose() {
        for (Option option : this.options) {
            option.dispose();
        }
        this.getDialog().dispose();
    }

    public TGProperties getDefaults() {
        if (this.defaults == null) {
            this.defaults = TGConfigDefaults.createDefaults();
        }
        return this.defaults;
    }

    public TGConfigManager getConfig() {
        return this.config;
    }

    public TablatureEditor getEditor() {
        return TuxGuitar.getInstance().getTablatureEditor();
    }

    public Shell getDialog() {
        return this.dialog;
    }

    public TGViewContext getViewContext() {
        return this.context;
    }

    public void addSyncThread(Runnable runnable) {
        this.runnables.add(runnable);
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }
}

