/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.piano;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.editor.TGExternalBeatViewerManager;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.dialog.piano.TGPiano;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGPianoEditor
implements TGEventListener {
    private TGContext context;
    private TGPiano piano;

    public TGPianoEditor(TGContext context) {
        this.context = context;
    }

    public void show() {
        Shell dialog = DialogUtils.newDialog(TuxGuitar.getInstance().getShell(), 2144);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("piano.editor"));
        this.piano = new TGPiano(this.context, (Composite)dialog, 0);
        this.addListeners();
        dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGPianoEditor.this.removeListeners();
            }
        });
        DialogUtils.openDialog(dialog, 10);
    }

    public void addListeners() {
        TuxGuitar.getInstance().getIconManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getScaleManager().addListener(this);
        TuxGuitar.getInstance().getEditorManager().addRedrawListener((TGEventListener)this);
        TGExternalBeatViewerManager.getInstance(this.context).addBeatViewerListener(this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getIconManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getScaleManager().removeListener(this);
        TuxGuitar.getInstance().getEditorManager().removeRedrawListener((TGEventListener)this);
        TGExternalBeatViewerManager.getInstance(this.context).removeBeatViewerListener(this);
    }

    private TGPiano getPiano() {
        return this.piano;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.getPiano().getShell().dispose();
            this.getPiano().dispose();
        }
    }

    public void redraw() {
        if (!this.isDisposed()) {
            this.getPiano().redraw();
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed() && !TuxGuitar.getInstance().isLocked()) {
            this.getPiano().redrawPlayingMode();
        }
    }

    public boolean isDisposed() {
        return this.getPiano() == null || this.getPiano().isDisposed();
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.getPiano().loadProperties();
            this.getPiano().getShell().setText(TuxGuitar.getProperty("piano.editor"));
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.getPiano().loadIcons();
        }
    }

    public void loadScale() {
        if (!this.isDisposed()) {
            this.getPiano().loadScale();
        }
    }

    public void showExternalBeat(TGBeat beat) {
        if (!this.isDisposed()) {
            this.getPiano().setExternalBeat(beat);
        }
    }

    public void hideExternalBeat() {
        if (!this.isDisposed()) {
            this.getPiano().setExternalBeat(null);
        }
    }

    public void processRedrawEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("redrawMode");
        if (type == 1) {
            this.redraw();
        } else if (type == 3) {
            this.redrawPlayingMode();
        }
    }

    public void processExternalBeatEvent(TGEvent event) {
        if ("show".equals(event.getAttribute("action"))) {
            this.showExternalBeat((TGBeat)event.getAttribute("beat"));
        } else if ("hide".equals(event.getAttribute("action"))) {
            this.hideExternalBeat();
        }
    }

    public void processEvent(final TGEvent event) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            public void run() {
                if ("ui-icon".equals(event.getEventType())) {
                    TGPianoEditor.this.loadIcons();
                } else if ("language".equals(event.getEventType())) {
                    TGPianoEditor.this.loadProperties();
                } else if ("ui-redraw".equals(event.getEventType())) {
                    TGPianoEditor.this.processRedrawEvent(event);
                } else if ("ui-external-beat-viewer".equals(event.getEventType())) {
                    TGPianoEditor.this.processExternalBeatEvent(event);
                } else if ("ui-scale-changed".equals(event.getEventType())) {
                    TGPianoEditor.this.loadScale();
                }
            }
        });
    }

    public static TGPianoEditor getInstance(TGContext context) {
        return (TGPianoEditor)TGSingletonUtil.getInstance((TGContext)context, (String)TGPianoEditor.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGPianoEditor>(){

            public TGPianoEditor createInstance(TGContext context) {
                return new TGPianoEditor(context);
            }
        });
    }
}

