/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.piano;

import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.graphics.TGColorImpl;
import org.herac.tuxguitar.app.graphics.TGImageImpl;
import org.herac.tuxguitar.app.view.component.tab.Caret;
import org.herac.tuxguitar.app.view.dialog.piano.TGPianoConfig;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterListenerLocked;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterLocked;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.TGEditorManager;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.graphics.TGColor;
import org.herac.tuxguitar.graphics.TGImage;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.control.TGNoteImpl;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.util.TGContext;

public class TGPiano
extends Composite {
    private static final boolean[] TYPE_NOTES = new boolean[]{true, false, true, false, true, true, false, true, false, true, false, true};
    private static final int NATURAL_NOTES = 7;
    private static final int MAX_OCTAVES = 8;
    private static final int NATURAL_WIDTH = 15;
    private static final int SHARP_WIDTH = 8;
    private static final int NATURAL_HEIGHT = 60;
    private static final int SHARP_HEIGHT = 40;
    private TGContext context;
    private int duration;
    private boolean changes;
    private TGPianoConfig config;
    private Composite pianoComposite;
    private Composite toolComposite;
    private Label durationLabel;
    private Label scaleName;
    private Button scale;
    private Button settings;
    private TGBeat beat;
    private TGBeat externalBeat;
    private TGImage image;

    public TGPiano(TGContext context, Composite parent, int style) {
        super(parent, style);
        this.context = context;
        this.config = new TGPianoConfig();
        this.config.load();
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, true));
        this.initToolBar();
        this.makePiano();
        this.loadIcons();
        this.loadProperties();
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo((Control)this.toolComposite);
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo((Control)this.pianoComposite);
    }

    private void initToolBar() {
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.toolComposite = new Composite((Composite)this, 0);
        ++layout.numColumns;
        Button goLeft = new Button(this.toolComposite, 16388);
        goLeft.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.caret.go-left"));
        ++layout.numColumns;
        Button goRight = new Button(this.toolComposite, 131076);
        goRight.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.caret.go-right"));
        ++layout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++layout.numColumns;
        Button decrement = new Button(this.toolComposite, 132);
        decrement.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.note.duration.decrement-duration"));
        ++layout.numColumns;
        this.durationLabel = new Label(this.toolComposite, 2048);
        ++layout.numColumns;
        Button increment = new Button(this.toolComposite, 1028);
        increment.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.note.duration.increment-duration"));
        ++layout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++layout.numColumns;
        this.scale = new Button(this.toolComposite, 8);
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.scale.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.gui.open-scale-dialog"));
        ++layout.numColumns;
        this.scaleName = new Label(this.toolComposite, 16384);
        ++layout.numColumns;
        this.settings = new Button(this.toolComposite, 8);
        this.settings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.settings.setLayoutData((Object)new GridData(131072, 4, true, true));
        this.settings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGPiano.this.configure();
            }
        });
        this.toolComposite.setLayout((Layout)layout);
        this.toolComposite.setLayoutData((Object)new GridData(4, 128, true, true));
    }

    private void makeToolSeparator(Composite parent) {
        Label separator = new Label(parent, 2);
        separator.setLayoutData((Object)new GridData(20, 20));
    }

    private void loadDurationImage(boolean force) {
        int duration = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getDuration().getValue();
        if (force || this.duration != duration) {
            this.duration = duration;
            this.durationLabel.setImage(TuxGuitar.getInstance().getIconManager().getDuration(this.duration));
        }
    }

    private void loadScaleName() {
        int scaleKey = TuxGuitar.getInstance().getScaleManager().getSelectionKey();
        int scaleIndex = TuxGuitar.getInstance().getScaleManager().getSelectionIndex();
        String key = TuxGuitar.getInstance().getScaleManager().getKeyName(scaleKey);
        String name = TuxGuitar.getInstance().getScaleManager().getScaleName(scaleIndex);
        this.scaleName.setText(key != null && name != null ? key + " - " + name : "");
        this.scaleName.pack();
    }

    private void makePiano() {
        this.image = this.makePianoImage();
        this.pianoComposite = new Composite((Composite)this, 2048);
        this.pianoComposite.setLayout((Layout)new GridLayout());
        this.pianoComposite.setLayoutData((Object)new GridData(840, 60));
        this.pianoComposite.addPaintListener((PaintListener)new TGBufferedPainterListenerLocked(this.context, new TGPianoPainterListener()));
        this.pianoComposite.addMouseListener((MouseListener)new TGPianoMouseListener());
        this.pianoComposite.setFocus();
    }

    private TGImage makePianoImage() {
        TGImageImpl image = new TGImageImpl((Device)this.getDisplay(), 840.0f, 60.0f);
        TGPainter painter = image.createPainter();
        int x = 0;
        boolean y = false;
        painter.setBackground((TGColor)new TGColorImpl(this.config.getColorNatural()));
        painter.initPath(2);
        painter.addRectangle((float)x, (float)y, 840.0f, 60.0f);
        painter.closePath();
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                painter.setForeground((TGColor)new TGColorImpl(this.config.getColorNotNatural()));
                painter.initPath();
                painter.setAntialias(false);
                painter.addRectangle((float)x, (float)y, 15.0f, 60.0f);
                painter.closePath();
                x += 15;
                continue;
            }
            painter.setBackground((TGColor)new TGColorImpl(this.config.getColorNotNatural()));
            painter.initPath(2);
            painter.setAntialias(false);
            painter.addRectangle((float)(x - 4), (float)y, 8.0f, 40.0f);
            painter.closePath();
        }
        this.paintScale(painter);
        painter.dispose();
        return image;
    }

    private void paintScale(TGPainter painter) {
        painter.setBackground((TGColor)new TGColorImpl(this.config.getColorScale()));
        painter.setForeground((TGColor)new TGColorImpl(this.config.getColorScale()));
        int posX = 0;
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            int width = 0;
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                width = 15;
                if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                    width -= 4;
                }
                if (!TYPE_NOTES[(i + 1) % TYPE_NOTES.length]) {
                    width -= 4;
                }
            } else {
                width = 8;
            }
            if (TuxGuitar.getInstance().getScaleManager().getScale().getNote(i)) {
                if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                    int x = posX;
                    if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                        x -= 4;
                    }
                    int size = 8;
                    painter.initPath(2);
                    painter.setAntialias(false);
                    painter.addRectangle((float)(x + 1 + (15 - size) / 2), (float)(60 - size - (15 - size) / 2), (float)size, (float)size);
                    painter.closePath();
                } else {
                    painter.initPath(2);
                    painter.setAntialias(false);
                    painter.addRectangle((float)(posX + 1), 33.0f, 6.0f, 6.0f);
                    painter.closePath();
                }
            }
            posX += width;
        }
    }

    protected void paintNote(TGPainter painter, int value) {
        painter.setBackground((TGColor)new TGColorImpl(this.config.getColorNote()));
        int posX = 0;
        int y = 0;
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            int width = 0;
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                width = 15;
                if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                    width -= 4;
                }
                if (!TYPE_NOTES[(i + 1) % TYPE_NOTES.length]) {
                    width -= 4;
                }
            } else {
                width = 8;
            }
            if (i == value) {
                if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                    painter.initPath(2);
                    painter.setAntialias(false);
                    painter.addRectangle((float)(posX + 1), (float)(y + 1), (float)(width - 1), 40.0f);
                    int x = posX;
                    if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                        x -= 4;
                    }
                    painter.addRectangle((float)(x + 1), (float)(y + 40 + 1), 14.0f, 19.0f);
                    painter.closePath();
                } else {
                    painter.initPath(2);
                    painter.setAntialias(false);
                    painter.addRectangle((float)(posX + 1), (float)(y + 1), (float)(width - 1), 39.0f);
                    painter.closePath();
                }
            }
            posX += width;
        }
    }

    protected void paintEditor(TGPainter painter) {
        this.updateEditor();
        painter.drawImage(this.image, 0.0f, 0.0f);
        if (this.beat != null) {
            for (int v = 0; v < this.beat.countVoices(); ++v) {
                TGVoice voice = this.beat.getVoice(v);
                Iterator it = voice.getNotes().iterator();
                while (it.hasNext()) {
                    this.paintNote(painter, this.getRealNoteValue((TGNote)it.next()));
                }
            }
        }
    }

    private int getSelection(Point point) {
        int posX = 0;
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            int width = 0;
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                width = 15;
                if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                    width -= 4;
                }
                if (!TYPE_NOTES[(i + 1) % TYPE_NOTES.length]) {
                    width -= 4;
                }
            } else {
                width = 8;
            }
            if (point.x >= posX && point.x < posX + width) {
                return i;
            }
            posX += width;
        }
        return -1;
    }

    protected void hit(int x, int y) {
        int value = this.getSelection(new Point(x, y));
        if (!this.removeNote(value)) {
            this.addNote(value);
        }
    }

    private boolean removeNote(int value) {
        if (this.beat != null) {
            for (int v = 0; v < this.beat.countVoices(); ++v) {
                TGVoice voice = this.beat.getVoice(v);
                for (TGNote note : voice.getNotes()) {
                    if (this.getRealNoteValue(note) != value) continue;
                    TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.beat.general.delete-note");
                    tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE, (Object)note);
                    tgActionProcessor.process();
                    return true;
                }
            }
        }
        return false;
    }

    private boolean addNote(int value) {
        Caret caret = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret();
        List strings = caret.getTrack().getStrings();
        for (int i = 0; i < strings.size(); ++i) {
            TGString string = (TGString)strings.get(i);
            if (value < string.getValue()) continue;
            boolean emptyString = true;
            if (this.beat != null) {
                block1: for (int v = 0; v < this.beat.countVoices(); ++v) {
                    TGVoice voice = this.beat.getVoice(v);
                    for (TGNoteImpl note : voice.getNotes()) {
                        if (note.getString() != string.getNumber()) continue;
                        emptyString = false;
                        continue block1;
                    }
                }
            }
            if (!emptyString) continue;
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.note.general.change");
            tgActionProcessor.setAttribute("fret", (Object)(value - string.getValue()));
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
            tgActionProcessor.process();
            return true;
        }
        return false;
    }

    protected int getRealNoteValue(TGNote note) {
        TGTrack track;
        TGMeasure measure;
        TGBeat beat;
        TGVoice voice = note.getVoice();
        if (voice != null && (beat = voice.getBeat()) != null && (measure = beat.getMeasure()) != null && (track = measure.getTrack()) != null) {
            return note.getValue() + track.getString(note.getString()).getValue();
        }
        Caret caret = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret();
        TGTrackImpl track2 = caret.getTrack();
        if (track2 != null) {
            return note.getValue() + track2.getString(note.getString()).getValue();
        }
        return 0;
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanges(boolean changes) {
        this.changes = changes;
    }

    public void setExternalBeat(TGBeat externalBeat) {
        this.externalBeat = externalBeat;
    }

    public TGBeat getExternalBeat() {
        return this.externalBeat;
    }

    protected void updateEditor() {
        if (this.isVisible()) {
            if (this.hasChanges()) {
                this.image.dispose();
                this.image = this.makePianoImage();
            }
            this.beat = TuxGuitar.getInstance().getPlayer().isRunning() ? TuxGuitar.getInstance().getEditorCache().getPlayBeat() : (this.externalBeat != null ? this.externalBeat : TuxGuitar.getInstance().getEditorCache().getEditBeat());
        }
    }

    public void redraw() {
        if (!super.isDisposed()) {
            super.redraw();
            this.pianoComposite.redraw();
            this.loadDurationImage(false);
        }
    }

    public void redrawPlayingMode() {
        if (!super.isDisposed()) {
            this.pianoComposite.redraw();
        }
    }

    public void dispose() {
        super.dispose();
        this.image.dispose();
        this.config.dispose();
    }

    public void loadProperties() {
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.loadScaleName();
        this.layout(true, true);
    }

    public void loadIcons() {
        this.getShell().setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        this.settings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        this.loadDurationImage(true);
        this.layout(true, true);
    }

    public void loadScale() {
        this.loadScaleName();
        this.setChanges(true);
    }

    protected void configure() {
        this.config.configure(this.getShell());
        this.setChanges(true);
        this.redraw();
    }

    public Composite getPianoComposite() {
        return this.pianoComposite;
    }

    private class TGPianoPainterListener
    implements TGBufferedPainterLocked.TGBufferedPainterHandle {
        public void paintControl(TGPainter painter) {
            TGPiano.this.paintEditor(painter);
        }

        public Composite getPaintableControl() {
            return TGPiano.this.pianoComposite;
        }
    }

    private class TGPianoMouseListener
    implements MouseListener {
        public void mouseUp(MouseEvent e) {
            TGPiano.this.getPianoComposite().setFocus();
            if (e.button == 1) {
                if (!TuxGuitar.getInstance().getPlayer().isRunning() && !TGEditorManager.getInstance((TGContext)TGPiano.this.context).isLocked()) {
                    if (TGPiano.this.getExternalBeat() == null) {
                        TGPiano.this.hit(e.x, e.y);
                    } else {
                        TGPiano.this.setExternalBeat(null);
                        TuxGuitar.getInstance().updateCache(true);
                    }
                }
            } else {
                new TGActionProcessor(TGPiano.this.context, "action.caret.go-right").process();
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }
    }
}

