/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.measure;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGMeasureCopyDialog {
    public void show(final TGViewContext context) {
        TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        TGMeasureHeader header = (TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
        Shell parent = (Shell)context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("edit.copy"));
        Group range = new Group((Composite)dialog, 16);
        range.setLayout((Layout)new GridLayout(2, false));
        range.setLayoutData((Object)new GridData(4, 4, true, true));
        range.setText(TuxGuitar.getProperty("edit.copy"));
        int measureCount = song.countMeasureHeaders();
        Label fromLabel = new Label((Composite)range, 0);
        fromLabel.setText(TuxGuitar.getProperty("edit.from"));
        final Spinner fromSpinner = new Spinner((Composite)range, 2048);
        fromSpinner.setLayoutData((Object)this.getSpinnerData());
        fromSpinner.setMinimum(1);
        fromSpinner.setMaximum(measureCount);
        fromSpinner.setSelection(header.getNumber());
        Label toLabel = new Label((Composite)range, 0);
        toLabel.setText(TuxGuitar.getProperty("edit.to"));
        final Spinner toSpinner = new Spinner((Composite)range, 2048);
        toSpinner.setLayoutData((Object)this.getSpinnerData());
        toSpinner.setMinimum(1);
        toSpinner.setMaximum(measureCount);
        toSpinner.setSelection(header.getNumber());
        boolean minSelection = true;
        final int maxSelection = track.countMeasures();
        fromSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fromSelection = fromSpinner.getSelection();
                int toSelection = toSpinner.getSelection();
                if (fromSelection < 1) {
                    fromSpinner.setSelection(1);
                } else if (fromSelection > toSelection) {
                    fromSpinner.setSelection(toSelection);
                }
            }
        });
        toSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fromSelection;
                int toSelection = toSpinner.getSelection();
                if (toSelection < (fromSelection = fromSpinner.getSelection())) {
                    toSpinner.setSelection(fromSelection);
                } else if (toSelection > maxSelection) {
                    toSpinner.setSelection(maxSelection);
                }
            }
        });
        Button allTracks = null;
        if (song.countTracks() > 1) {
            Group checkComposites = new Group((Composite)dialog, 16);
            checkComposites.setLayout((Layout)new GridLayout());
            checkComposites.setLayoutData((Object)new GridData(4, 4, true, true));
            checkComposites.setText(TuxGuitar.getProperty("options"));
            allTracks = new Button((Composite)checkComposites, 32);
            allTracks.setText(TuxGuitar.getProperty("edit.all-tracks"));
            allTracks.setSelection(true);
        }
        final Button allTracksFinal = allTracks;
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGMeasureCopyDialog.this.processAction(context.getContext(), fromSpinner.getSelection(), toSpinner.getSelection(), allTracksFinal != null ? allTracksFinal.getSelection() : true);
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    protected GridData getSpinnerData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 180;
        return data;
    }

    public void processAction(TGContext context, Integer measure1, Integer measure2, Boolean copyAllTracks) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.measure.copy");
        tgActionProcessor.setAttribute("measureNumber1", (Object)measure1);
        tgActionProcessor.setAttribute("measureNumber2", (Object)measure2);
        tgActionProcessor.setAttribute("copyAllTracks", (Object)copyAllTracks);
        tgActionProcessor.process();
    }
}

