/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.marker;

import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.util.TGProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGMarkerList
implements TGEventListener {
    private TGContext context;
    private Shell dialog;
    private Table table;
    private List<TGMarker> markers;
    private Composite compositeTable;
    private TableColumn measureColumn;
    private TableColumn titleColumn;
    private Composite compositeButtons;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonDelete;
    private Button buttonGo;
    private Button buttonClose;
    private TGProcess loadPropertiesProcess;
    private TGProcess loadIconsProcess;
    private TGProcess updateProcess;
    private int markerCount;

    private TGMarkerList(TGContext context) {
        this.context = context;
        this.markerCount = 0;
        this.createSyncProcesses();
    }

    public void show() {
        this.dialog = DialogUtils.newDialog(TuxGuitar.getInstance().getShell(), 2144);
        this.dialog.setLayout((Layout)new GridLayout(2, false));
        this.dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        this.compositeTable = new Composite((Composite)this.dialog, 0);
        this.compositeTable.setLayout((Layout)new GridLayout());
        this.compositeTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(this.compositeTable, 67584);
        this.table.setLayoutData((Object)new GridData(250, 200));
        this.table.setHeaderVisible(true);
        this.table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                TGMarkerList.this.goToSelectedMarker();
            }
        });
        this.measureColumn = new TableColumn(this.table, 16384);
        this.measureColumn.setWidth(70);
        this.titleColumn = new TableColumn(this.table, 16384);
        this.titleColumn.setWidth(180);
        this.loadTableItems();
        this.compositeButtons = new Composite((Composite)this.dialog, 0);
        this.compositeButtons.setLayout((Layout)new GridLayout(1, false));
        this.compositeButtons.setLayoutData((Object)new GridData(4, 4, true, true));
        this.buttonAdd = new Button(this.compositeButtons, 8);
        this.buttonAdd.setLayoutData((Object)this.makeGridData(4, 128, false));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGMarkerList.this.openMarkerEditor(null);
            }
        });
        this.buttonEdit = new Button(this.compositeButtons, 8);
        this.buttonEdit.setLayoutData((Object)this.makeGridData(4, 128, false));
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGMarkerList.this.openMarkerEditor(TGMarkerList.this.getSelectedMarker());
            }
        });
        this.buttonDelete = new Button(this.compositeButtons, 8);
        this.buttonDelete.setLayoutData((Object)this.makeGridData(4, 128, false));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGMarkerList.this.removeMarker(TGMarkerList.this.getSelectedMarker());
            }
        });
        this.buttonGo = new Button(this.compositeButtons, 8);
        this.buttonGo.setLayoutData((Object)this.makeGridData(4, 1024, true));
        this.buttonGo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGMarkerList.this.goToSelectedMarker();
            }
        });
        this.buttonClose = new Button(this.compositeButtons, 8);
        this.buttonClose.setLayoutData((Object)this.makeGridData(4, 1024, false));
        this.buttonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGMarkerList.this.dialog.dispose();
            }
        });
        this.loadIcons();
        this.loadProperties(false);
        this.addListeners();
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGMarkerList.this.removeListeners();
            }
        });
        this.dialog.setDefaultButton(this.buttonGo);
        DialogUtils.openDialog(this.dialog, 10);
    }

    public void addListeners() {
        TuxGuitar.getInstance().getIconManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getIconManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public void update() {
        if (!this.isDisposed()) {
            this.loadTableItems();
        }
    }

    public void fireUpdateProcess() {
        this.updateProcess.process();
    }

    private GridData makeGridData(int horizontalAlignment, int verticalAlignment, boolean grabExcessVerticalSpace) {
        GridData data = new GridData();
        data.horizontalAlignment = horizontalAlignment;
        data.verticalAlignment = verticalAlignment;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = grabExcessVerticalSpace;
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    protected void loadTableItems() {
        int itemSelected = this.table.getSelectionIndex();
        TGSong song = TuxGuitar.getInstance().getDocumentManager().getSong();
        this.table.removeAll();
        this.markers = TuxGuitar.getInstance().getSongManager().getMarkers(song);
        for (TGMarker marker : this.markers) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{Integer.toString(marker.getMeasure()), marker.getTitle()});
        }
        int markerCount = this.markers.size();
        if (this.markerCount >= markerCount && itemSelected >= 0 && itemSelected < markerCount) {
            this.table.select(itemSelected);
        }
        this.markerCount = markerCount;
    }

    protected TGMarker getSelectedMarker() {
        int itemSelected = this.table.getSelectionIndex();
        if (itemSelected >= 0 && itemSelected < this.markers.size()) {
            return this.markers.get(itemSelected);
        }
        return null;
    }

    public void goToSelectedMarker() {
        TGMarker marker = this.getSelectedMarker();
        if (marker != null) {
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.marker.go-to");
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER, (Object)marker);
            tgActionProcessor.process();
        }
    }

    public void openMarkerEditor(TGMarker marker) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.gui.open-marker-editor-dialog");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER, (Object)marker);
        tgActionProcessor.process();
    }

    public void removeMarker(TGMarker marker) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.marker.remove");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER, (Object)marker);
        tgActionProcessor.process();
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        }
    }

    public void loadProperties() {
        this.loadProperties(true);
    }

    public void loadProperties(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("marker.list"));
            this.measureColumn.setText(TuxGuitar.getProperty("measure"));
            this.titleColumn.setText(TuxGuitar.getProperty("title"));
            this.buttonAdd.setText(TuxGuitar.getProperty("add"));
            this.buttonEdit.setText(TuxGuitar.getProperty("edit"));
            this.buttonDelete.setText(TuxGuitar.getProperty("remove"));
            this.buttonGo.setText(TuxGuitar.getProperty("go"));
            this.buttonClose.setText(TuxGuitar.getProperty("close"));
            if (layout) {
                this.table.layout();
                this.compositeTable.layout();
                this.compositeButtons.layout();
                this.dialog.pack(true);
            }
        }
    }

    public void createSyncProcesses() {
        this.updateProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGMarkerList.this.update();
            }
        });
        this.loadIconsProcess = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                TGMarkerList.this.loadIcons();
            }
        });
        this.loadPropertiesProcess = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                TGMarkerList.this.loadProperties();
            }
        });
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 4) {
            this.fireUpdateProcess();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        } else if ("ui-icon".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        }
    }

    public static TGMarkerList getInstance(TGContext context) {
        return (TGMarkerList)TGSingletonUtil.getInstance((TGContext)context, (String)TGMarkerList.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGMarkerList>(){

            public TGMarkerList createInstance(TGContext context) {
                return new TGMarkerList(context);
            }
        });
    }
}

