/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.keybindings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.keybindings.KeyBinding;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingAction;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingActionDefaults;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.keybindings.TGKeyBindingSelector;
import org.herac.tuxguitar.app.view.dialog.keybindings.TGKeyBindingSelectorHandler;
import org.herac.tuxguitar.editor.action.TGActionProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGKeyBindingEditor {
    private static final int ACTION_WIDTH = 400;
    private static final int SHORTCUT_WIDTH = 100;
    private TGViewContext context;
    private Shell dialog;
    private Table table;
    private List<TableItem> items;

    public TGKeyBindingEditor(TGViewContext context) {
        this.context = context;
        this.items = new ArrayList<TableItem>();
    }

    public void show() {
        Shell parent = (Shell)this.context.getAttribute("parent");
        this.dialog = DialogUtils.newDialog(parent, 67680);
        this.dialog.setText(TuxGuitar.getProperty("key-bindings-editor"));
        this.dialog.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)this.dialog, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 0, true, true));
        this.table = new Table(composite, 67588);
        this.table.setLayoutData((Object)new GridData(500, 250));
        this.table.setHeaderVisible(true);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                final TableItem item = TGKeyBindingEditor.this.getSelectedItem();
                if (item != null) {
                    final KeyBindingAction itemData = (KeyBindingAction)item.getData();
                    TGKeyBindingSelector keyBindingSelector = new TGKeyBindingSelector(TGKeyBindingEditor.this, itemData, new TGKeyBindingSelectorHandler(){

                        public void handleSelection(KeyBinding kb) {
                            TGKeyBindingEditor.this.removeKeyBindingAction(kb);
                            itemData.setKeyBinding(kb);
                            TGKeyBindingEditor.this.loadTableItemLabel(item);
                        }
                    });
                    keyBindingSelector.select(TGKeyBindingEditor.this.dialog.getShell());
                }
            }
        });
        TableColumn actionColumn = new TableColumn(this.table, 16384);
        actionColumn.setText(TuxGuitar.getProperty("key-bindings-editor-action-column"));
        TableColumn shortcutColumn = new TableColumn(this.table, 16384);
        shortcutColumn.setText(TuxGuitar.getProperty("key-bindings-editor-shortcut-column"));
        this.loadAvailableActionKeyBindings();
        this.loadEnableActionKeyBindings(TuxGuitar.getInstance().getKeyBindingManager().getKeyBindingActions());
        Composite buttons = new Composite((Composite)this.dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button defaults = new Button(buttons, 8);
        defaults.setText(TuxGuitar.getProperty("defaults"));
        defaults.setLayoutData((Object)this.getButtonData());
        defaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGKeyBindingEditor.this.loadEnableActionKeyBindings(KeyBindingActionDefaults.getDefaultKeyBindings(TGKeyBindingEditor.this.getContext().getContext()));
            }
        });
        Button close = new Button(buttons, 8);
        close.setText(TuxGuitar.getProperty("close"));
        close.setLayoutData((Object)this.getButtonData());
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGKeyBindingEditor.this.dialog.dispose();
            }
        });
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGKeyBindingEditor.this.save();
            }
        });
        this.table.setLayoutData((Object)new GridData(this.adjustWidth(actionColumn, 400) + this.adjustWidth(shortcutColumn, 100), 250));
        this.dialog.setDefaultButton(close);
        DialogUtils.openDialog(this.dialog, 10);
    }

    protected int adjustWidth(TableColumn column, int defaultWidth) {
        column.pack();
        int width = column.getWidth();
        if (width < defaultWidth) {
            width = defaultWidth;
            column.setWidth(width);
        }
        return width;
    }

    protected GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    protected void loadTableItemLabel(TableItem item) {
        if (item.getData() instanceof KeyBindingAction) {
            KeyBindingAction actionkeyBinding = (KeyBindingAction)item.getData();
            String action = actionkeyBinding.getAction();
            String shortcut = actionkeyBinding.getKeyBinding() != null ? actionkeyBinding.getKeyBinding().toString() : "";
            item.setText(new String[]{TuxGuitar.getProperty(action), shortcut});
        }
    }

    protected void loadAvailableActionKeyBindings() {
        List<String> list = TuxGuitar.getInstance().getActionAdapterManager().getKeyBindingActionIds().getActionIds();
        Collections.sort(list);
        for (String action : list) {
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)new KeyBindingAction(action, null));
            this.items.add(item);
        }
    }

    protected void loadEnableActionKeyBindings(List<KeyBindingAction> list) {
        for (TableItem item : this.items) {
            if (!(item.getData() instanceof KeyBindingAction)) continue;
            KeyBindingAction itemData = (KeyBindingAction)item.getData();
            KeyBinding keyBinding = null;
            for (KeyBindingAction keyBindingAction : list) {
                if (!keyBindingAction.getAction().equals(itemData.getAction())) continue;
                keyBinding = (KeyBinding)keyBindingAction.getKeyBinding().clone();
                break;
            }
            itemData.setKeyBinding(keyBinding);
            this.loadTableItemLabel(item);
        }
    }

    protected void removeKeyBindingAction(KeyBinding kb) {
        if (kb != null) {
            for (TableItem item : this.items) {
                KeyBindingAction itemData;
                if (!(item.getData() instanceof KeyBindingAction) || !kb.isSameAs((itemData = (KeyBindingAction)item.getData()).getKeyBinding())) continue;
                itemData.setKeyBinding(null);
                this.loadTableItemLabel(item);
            }
        }
    }

    protected TableItem getSelectedItem() {
        TableItem item = null;
        int itemSelected = this.table.getSelectionIndex();
        if (itemSelected >= 0) {
            item = this.table.getItem(itemSelected);
        }
        return item;
    }

    public boolean exists(KeyBinding kb) {
        for (TableItem item : this.items) {
            KeyBindingAction itemData;
            if (!(item.getData() instanceof KeyBindingAction) || (itemData = (KeyBindingAction)item.getData()).getKeyBinding() == null || !kb.isSameAs(itemData.getKeyBinding())) continue;
            return true;
        }
        return false;
    }

    protected void save() {
        ArrayList<KeyBindingAction> list = new ArrayList<KeyBindingAction>();
        for (TableItem item : this.items) {
            KeyBindingAction keyBindingAction;
            if (!(item.getData() instanceof KeyBindingAction) || (keyBindingAction = (KeyBindingAction)item.getData()).getAction() == null || keyBindingAction.getKeyBinding() == null) continue;
            list.add(keyBindingAction);
        }
        TuxGuitar.getInstance().getKeyBindingManager().reset(list);
        TuxGuitar.getInstance().getKeyBindingManager().saveKeyBindings();
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.system.reload-language");
        tgActionProcessor.setAttribute("force", (Object)true);
        tgActionProcessor.process();
    }

    public TGViewContext getContext() {
        return this.context;
    }

    public Shell getDialog() {
        return this.dialog;
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }
}

