/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.chord;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.app.graphics.TGColorImpl;
import org.herac.tuxguitar.app.graphics.TGFontImpl;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordDialog;
import org.herac.tuxguitar.graphics.TGColor;
import org.herac.tuxguitar.graphics.TGFont;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.control.TGChordImpl;
import org.herac.tuxguitar.graphics.control.TGResourceBuffer;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGChordList
extends Composite {
    private static final int MIN_HEIGHT = 160;
    private static final int SCROLL_INCREMENT = 25;
    private static final float CHORD_FIRST_FRET_SPACING = 12.0f;
    private static final float CHORD_STRING_SPACING = 8.0f;
    private static final float CHORD_FRET_SPACING = 10.0f;
    private static final float CHORD_NOTE_SIZE = 6.0f;
    private static final float CHORD_LINE_WIDTH = 1.0f;
    private TGChordDialog dialog;
    private TGBeat beat;
    private TGResourceBuffer resourceBuffer;
    private List<TGChord> graphicChords;
    private float height;
    private TGChordImpl selectedChord;
    private Composite composite;
    private Font font;

    public TGChordList(TGChordDialog dialog, Composite parent, TGBeat beat) {
        super(parent, 0);
        this.setLayout((Layout)dialog.gridLayout(1, false, 0, 0));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.graphicChords = new ArrayList<TGChord>();
        this.resourceBuffer = new TGResourceBuffer();
        this.dialog = dialog;
        this.beat = beat;
        this.init();
    }

    private void init() {
        this.composite = new Composite((Composite)this, 0x20000A00);
        this.composite.setBackground(this.getDisplay().getSystemColor(1));
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TGPainterImpl painter = new TGPainterImpl(e.gc);
                TGChordList.this.paintChords(painter);
            }
        });
        this.composite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TGChordList.this.getComposite().setFocus();
                TGChordList.this.getDialog().getEditor().setChord((TGChord)TGChordList.this.getChord(e.x, e.y, true));
                TGChordList.this.redraw();
            }
        });
        final Point origin = new Point(0, 0);
        final ScrollBar vBar = this.composite.getVerticalBar();
        vBar.setIncrement(25);
        vBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int vSelection = vBar.getSelection();
                int destY = -vSelection - origin.y;
                Rectangle rect = TGChordList.this.getComposite().getBounds();
                TGChordList.this.getShell().scroll(0, destY, 0, 0, rect.width, rect.height, false);
                origin.y = -vSelection;
                TGChordList.this.redraw();
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 160;
        this.composite.setLayoutData((Object)data);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                TGChordList.this.disposeChords();
                TGChordList.this.disposeFont();
            }
        });
    }

    public void redraw() {
        super.redraw();
        this.composite.redraw();
    }

    protected void paintChords(TGPainterImpl painter) {
        float maxHeight = 0.0f;
        float fromX = 15.0f;
        float fromY = 10.0f;
        float vScroll = this.composite.getVerticalBar().getSelection();
        for (TGChordImpl tGChordImpl : this.graphicChords) {
            TGColorImpl color = new TGColorImpl(this.getChordColor(tGChordImpl));
            tGChordImpl.registerBuffer(this.resourceBuffer);
            tGChordImpl.setBackgroundColor((TGColor)new TGColorImpl(this.composite.getBackground()));
            tGChordImpl.setColor((TGColor)color);
            tGChordImpl.setNoteColor((TGColor)color);
            tGChordImpl.setTonicColor((TGColor)new TGColorImpl(this.getDisplay().getSystemColor(4)));
            tGChordImpl.setFirstFretSpacing(12.0f);
            tGChordImpl.setStringSpacing(8.0f);
            tGChordImpl.setFretSpacing(10.0f);
            tGChordImpl.setNoteSize(6.0f);
            tGChordImpl.setLineWidth(1.0f);
            tGChordImpl.setFirstFretFont((TGFont)new TGFontImpl(this.getFont(painter.getGC())));
            tGChordImpl.setStyle(32);
            tGChordImpl.update((TGPainter)painter, this.resourceBuffer);
            if (fromX + tGChordImpl.getWidth() >= (float)(this.getBounds().x + this.getBounds().width - 20)) {
                fromX = 15.0f;
                fromY += tGChordImpl.getHeight() + 10.0f;
            }
            tGChordImpl.setEditing(true);
            tGChordImpl.setPosX(fromX);
            tGChordImpl.setPosY(fromY - vScroll);
            tGChordImpl.paint((TGPainter)painter, tGChordImpl.getWidth() / 2.0f, 0.0f);
            fromX += tGChordImpl.getWidth() + 10.0f;
            maxHeight = Math.max(maxHeight, tGChordImpl.getHeight());
        }
        this.height = fromY + maxHeight + 10.0f;
        this.updateScroll();
    }

    private Color getChordColor(TGChordImpl chord) {
        if (this.selectedChord != null && this.selectedChord.equals(chord)) {
            return this.getDisplay().getSystemColor(9);
        }
        return this.getDisplay().getSystemColor(2);
    }

    public void updateScroll() {
        Rectangle rect = this.composite.getBounds();
        Rectangle client = this.composite.getClientArea();
        ScrollBar vBar = this.composite.getVerticalBar();
        vBar.setMaximum(Math.round(this.height));
        vBar.setThumb(Math.min(rect.height, client.height));
    }

    protected int getTrackString(int number) {
        TGString string = this.beat.getMeasure().getTrack().getString(number);
        return string.getValue();
    }

    protected Font getFont(GC painter) {
        if (this.font == null || this.font.isDisposed()) {
            FontData[] datas;
            Font available = painter.getFont();
            if (available == null || available.isDisposed()) {
                available = this.getDisplay().getSystemFont();
            }
            if ((datas = available.getFontData()).length > 0) {
                this.font = new Font((Device)this.getDisplay(), datas[0].getName(), Math.min(7, datas[0].getHeight()), 1);
            }
        }
        return this.font;
    }

    protected TGChordImpl getChord(int x, int y, boolean setAsSelected) {
        for (TGChordImpl tGChordImpl : this.graphicChords) {
            float x1 = tGChordImpl.getPosX();
            float x2 = x1 + tGChordImpl.getWidth();
            float y1 = tGChordImpl.getPosY();
            float y2 = y1 + tGChordImpl.getHeight();
            if (!((float)x > x1) || !((float)x < x2) || !((float)y > y1) || !((float)y < y2)) continue;
            if (setAsSelected) {
                if (this.selectedChord != null) {
                    this.selectedChord.dispose();
                }
                this.selectedChord = tGChordImpl;
                tGChordImpl.dispose();
            }
            return tGChordImpl;
        }
        return null;
    }

    public void setChords(List<TGChord> chords) {
        this.disposeChords();
        this.selectedChord = null;
        for (TGChordImpl tGChordImpl : chords) {
            tGChordImpl.setTonic(this.dialog.getSelector().getTonicList().getSelectionIndex());
            tGChordImpl.setBeat(this.beat);
            this.graphicChords.add((TGChord)tGChordImpl);
        }
        this.redraw();
    }

    public void disposeFont() {
        if (this.font != null) {
            this.font.dispose();
        }
    }

    public void disposeChords() {
        this.graphicChords.clear();
        this.resourceBuffer.disposeAllResources();
    }

    protected Composite getComposite() {
        return this.composite;
    }

    protected TGChordDialog getDialog() {
        return this.dialog;
    }
}

