/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.browser.main;

import java.io.InputStream;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.browser.TGBrowserCollection;
import org.herac.tuxguitar.app.tools.browser.TGBrowserConnection;
import org.herac.tuxguitar.app.tools.browser.TGBrowserConnectionHandler;
import org.herac.tuxguitar.app.tools.browser.TGBrowserFactoryHandler;
import org.herac.tuxguitar.app.tools.browser.TGBrowserManager;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserElement;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserFactory;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserMenuBar;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserToolBar;
import org.herac.tuxguitar.app.view.util.TGCursorController;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.action.file.TGReadSongAction;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;
import org.herac.tuxguitar.util.error.TGErrorHandler;
import org.herac.tuxguitar.util.error.TGErrorManager;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGBrowserDialog
implements TGBrowserFactoryHandler,
TGBrowserConnectionHandler,
TGEventListener {
    private static final int SHELL_WIDTH = 500;
    private static final int SHELL_HEIGHT = 350;
    public static final int CALL_OPEN = 1;
    public static final int CALL_CLOSE = 2;
    public static final int CALL_CD_ROOT = 3;
    public static final int CALL_CD_UP = 4;
    public static final int CALL_LIST = 5;
    public static final int CALL_ELEMENT = 6;
    private TGContext context;
    private TGBrowserCollection collection;
    private TGBrowserConnection connection;
    private Shell dialog;
    private Table table;
    private TableColumn column;
    private List<TGBrowserElement> elements;
    private TGBrowserMenuBar menu;
    private TGBrowserToolBar toolBar;
    private TGCursorController cursorController;

    public TGBrowserDialog(TGContext context) {
        this.context = context;
        this.connection = new TGBrowserConnection(this);
        this.menu = new TGBrowserMenuBar(this);
        this.toolBar = new TGBrowserToolBar(this);
    }

    public TGContext getContext() {
        return this.context;
    }

    public TGBrowserConnection getConnection() {
        return this.connection;
    }

    public TGBrowserCollection getCollection() {
        return this.collection;
    }

    public void setCollection(TGBrowserCollection collection) {
        this.collection = collection;
    }

    public Shell getShell() {
        return this.dialog;
    }

    public void exit() {
        this.getConnection().release();
        this.getConnection().close(2);
        TGBrowserManager.getInstance(this.context).writeCollections();
        TuxGuitar.getInstance().getIconManager().removeLoader(this);
    }

    public void show() {
        this.dialog = DialogUtils.newDialog(TuxGuitar.getInstance().getShell(), 2160);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        this.menu.init(this.getShell());
        this.toolBar.init(this.getShell());
        this.initTable((Composite)this.dialog);
        this.updateCollections(null);
        this.updateTable();
        this.dialog.setSize(500, 350);
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGBrowserDialog.this.exit();
            }
        });
        this.loadProperties();
        this.updateBars();
        TGBrowserManager.getInstance(this.context).setFactoryHandler(this);
        TuxGuitar.getInstance().getIconManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        DialogUtils.openDialog(this.dialog, 8);
    }

    private void initTable(Composite parent) {
        this.table = new Table(parent, 67588);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setLinesVisible(TuxGuitar.getInstance().getConfig().getBooleanValue("browser.lines-visible"));
        this.table.setHeaderVisible(false);
        this.column = new TableColumn(this.table, 16384);
        this.table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                TGBrowserDialog.this.openElement();
            }
        });
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    private void updateTable() {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() {
                    if (!TGBrowserDialog.this.isDisposed()) {
                        TGBrowserDialog.this.table.removeAll();
                        if (TGBrowserDialog.this.elements != null) {
                            for (TGBrowserElement element : TGBrowserDialog.this.elements) {
                                TableItem item = new TableItem(TGBrowserDialog.this.table, 0);
                                item.setImage(element.isFolder() ? TuxGuitar.getInstance().getIconManager().getBrowserFolder() : TuxGuitar.getInstance().getIconManager().getBrowserFile());
                                item.setText(element.getName());
                            }
                        }
                        TGBrowserDialog.this.updateColumn();
                    }
                }
            });
        }
    }

    protected void updateColumn() {
        if (!this.isDisposed()) {
            this.column.pack();
        }
    }

    public void updateBars() {
        if (!this.isDisposed()) {
            this.menu.updateItems();
            this.toolBar.updateItems();
        }
    }

    public void updateCollections(final TGBrowserCollection selection) {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() {
                    if (!TGBrowserDialog.this.isDisposed()) {
                        TGBrowserDialog.this.menu.updateCollections(selection);
                        TGBrowserDialog.this.toolBar.updateCollections(selection);
                    }
                }
            });
        }
    }

    public TGBrowserElement getSelection(int index) {
        if (!this.isDisposed() && this.getConnection().isOpen() && this.elements != null && index >= 0 && index < this.elements.size()) {
            return this.elements.get(index);
        }
        return null;
    }

    protected void removeElements() {
        this.elements = null;
    }

    protected void addElements(List<TGBrowserElement> elements) {
        this.elements = elements;
    }

    protected void openCollection() {
        if (!this.isDisposed() && this.getCollection() != null) {
            TGBrowserFactory factory = TGBrowserManager.getInstance(this.context).getFactory(this.getCollection().getType());
            this.getConnection().open(1, factory.newTGBrowser(this.getCollection().getData()));
        }
    }

    protected void closeCollection() {
        if (!this.isDisposed() && this.getCollection() != null) {
            this.getConnection().close(2);
        }
    }

    protected void removeCollection(TGBrowserCollection collection) {
        if (collection != null) {
            TGBrowserManager.getInstance(this.context).removeCollection(collection);
            if (this.getCollection() != null && this.getCollection().equals(collection)) {
                this.getConnection().close(2);
            } else {
                this.updateCollections(this.getCollection());
            }
        }
    }

    public void openElement() {
        TGBrowserElement element = this.getSelection(this.table.getSelectionIndex());
        if (element != null) {
            this.getConnection().openStream(6, element);
        }
    }

    @Override
    public void notifyLockStatusChanged() {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            public void run() {
                if (!TGBrowserDialog.this.isDisposed()) {
                    TGBrowserDialog.this.updateBars();
                    TGBrowserDialog.this.loadCursor(TGBrowserDialog.this.getConnection().isLocked() ? 1 : 0);
                }
            }
        });
    }

    @Override
    public void notifyOpened(int callId) {
        if (!this.isDisposed()) {
            this.removeElements();
            this.updateTable();
            this.updateCollections(this.getCollection());
            this.getConnection().release();
            this.getConnection().listElements(5);
        }
    }

    @Override
    public void notifyClosed(int callId) {
        if (callId != 1) {
            this.setCollection(null);
        }
        this.removeElements();
        this.updateCollections(this.getCollection());
        this.updateTable();
        if (callId != 1) {
            this.getConnection().release();
        }
    }

    @Override
    public void notifyError(int callId, Throwable throwable) {
        if (!this.isDisposed()) {
            this.updateTable();
            this.getConnection().release();
            TGErrorManager.getInstance((TGContext)this.context).handleError(throwable);
        }
    }

    @Override
    public void notifyCd(int callId) {
        if (!this.isDisposed()) {
            this.getConnection().release();
            this.getConnection().listElements(5);
        }
    }

    @Override
    public void notifyElements(int callId, List<TGBrowserElement> elements) {
        if (!this.isDisposed()) {
            this.addElements(elements);
            this.updateTable();
            this.getConnection().release();
        }
    }

    @Override
    public void notifyStream(int callId, InputStream stream, final TGBrowserElement element) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.song.read");
        tgActionProcessor.setAttribute(TGReadSongAction.ATTRIBUTE_INPUT_STREAM, (Object)stream);
        tgActionProcessor.setOnFinish(new Runnable(){

            public void run() {
                TGBrowserDialog.this.getConnection().release();
            }
        });
        tgActionProcessor.setAttribute(TGErrorHandler.class.getName(), (Object)new TGErrorHandler(){

            public void handleError(Throwable throwable) {
                TGBrowserDialog.this.getConnection().release();
                TGMessageDialogUtil.errorMessage(TGBrowserDialog.this.getContext(), TGBrowserDialog.this.getShell(), TuxGuitar.getProperty("file.open.error", new String[]{element.getName()}));
            }
        });
        tgActionProcessor.process();
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.getShell().setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            this.reload();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("browser.dialog"));
            this.menu.loadProperties();
            this.toolBar.loadProperties();
        }
    }

    public void loadCursor(int cursorStyle) {
        if (!this.isDisposed()) {
            if (this.cursorController == null || !this.cursorController.isControlling((Control)this.dialog)) {
                this.cursorController = new TGCursorController(this.context, (Control)this.dialog);
            }
            this.cursorController.loadCursor(cursorStyle);
        }
    }

    @Override
    public void notifyAdded() {
        this.reload();
    }

    @Override
    public void notifyRemoved() {
        if (this.getCollection() != null) {
            this.closeCollection();
        }
        this.reload();
    }

    protected void reload() {
        if (!this.isDisposed()) {
            this.menu.reload(this.getShell());
            this.toolBar.reload();
            this.updateTable();
            this.updateCollections(this.getCollection());
            this.getShell().layout();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-icon".equals(event.getEventType())) {
            this.loadIcons();
        } else if ("language".equals(event.getEventType())) {
            this.loadProperties();
        }
    }

    public static TGBrowserDialog getInstance(TGContext context) {
        return (TGBrowserDialog)TGSingletonUtil.getInstance((TGContext)context, (String)TGBrowserDialog.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGBrowserDialog>(){

            public TGBrowserDialog createInstance(TGContext context) {
                return new TGBrowserDialog(context);
            }
        });
    }
}

