/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.about;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.graphics.TGImageImpl;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.about.TGAboutContentReader;
import org.herac.tuxguitar.util.TGVersion;

public class TGAboutDialog {
    private static final String RELEASE_NAME = "TuxGuitar " + TGVersion.CURRENT.getVersion();
    private static final String PROPERTY_PREFIX = "help.about.";
    private static final int IMAGE_WIDTH = 100;
    private static final int IMAGE_HEIGHT = 100;
    private static final int TAB_ITEM_WIDTH = 660;
    private static final int TAB_ITEM_HEIGHT = 300;
    protected Composite imageComposite;
    protected Image image;

    public void show(TGViewContext context) {
        Shell parent = (Shell)context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("help.about"));
        Composite header = new Composite((Composite)dialog, 0);
        header.setLayout((Layout)new GridLayout(2, false));
        header.setLayoutData((Object)new GridData(4, 4, true, true));
        this.image = TuxGuitar.getInstance().getIconManager().getAboutDescription();
        this.imageComposite = new Composite(header, 0);
        this.imageComposite.setLayoutData((Object)new GridData(100, 100));
        this.imageComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle bounds = TGAboutDialog.this.image.getBounds();
                TGPainterImpl painter = new TGPainterImpl(e.gc);
                painter.drawImage(new TGImageImpl(TGAboutDialog.this.image), (100 - bounds.width) / 2, (100 - bounds.height) / 2);
            }
        });
        final Font titleFont = new Font((Device)dialog.getDisplay(), TuxGuitar.getInstance().getConfig().getFontDataConfigValue("font.about.dialog.title"));
        Label title = new Label(header, 0);
        title.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        title.setFont(titleFont);
        title.setForeground(dialog.getDisplay().getSystemColor(15));
        title.setText(RELEASE_NAME);
        title.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                titleFont.dispose();
            }
        });
        Composite tabs = new Composite((Composite)dialog, 0);
        tabs.setLayout((Layout)new GridLayout());
        tabs.setLayoutData((Object)new GridData(4, 4, true, true));
        final TabFolder tabFolder = new TabFolder(tabs, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        tabFolder.setLayout((Layout)new FormLayout());
        TGAboutContentReader docReader = new TGAboutContentReader(context.getContext());
        this.makeTabItem(tabFolder, "description", docReader.read("description").toString());
        this.makeTabItem(tabFolder, "authors", docReader.read("authors").toString());
        this.makeTabItem(tabFolder, "license", docReader.read("license").toString());
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (tabFolder.getSelectionIndex() == 0) {
                    TGAboutDialog.this.image = TuxGuitar.getInstance().getIconManager().getAboutDescription();
                } else if (tabFolder.getSelectionIndex() == 1) {
                    TGAboutDialog.this.image = TuxGuitar.getInstance().getIconManager().getAboutAuthors();
                } else if (tabFolder.getSelectionIndex() == 2) {
                    TGAboutDialog.this.image = TuxGuitar.getInstance().getIconManager().getAboutLicense();
                }
                TGAboutDialog.this.imageComposite.redraw();
            }
        });
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonClose = new Button(buttons, 8);
        buttonClose.setLayoutData((Object)this.getButtonData());
        buttonClose.setText(TuxGuitar.getProperty("close"));
        buttonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        tabFolder.setSelection(0);
        dialog.setDefaultButton(buttonClose);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private void makeTabItem(TabFolder tabFolder, String itemName, String itemText) {
        Composite control = new Composite((Composite)tabFolder, 0);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new FormData(660, 300));
        Text text = new Text(control, 2626);
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        text.setBackground(TuxGuitar.getInstance().getDisplay().getSystemColor(1));
        text.setEditable(false);
        text.append(itemText);
        text.setSelection(0);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(TuxGuitar.getProperty(PROPERTY_PREFIX + itemName));
        tabItem.setControl((Control)control);
    }
}

