/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.app.view.component.table.TGTableColumn;
import org.herac.tuxguitar.app.view.component.table.TGTableRow;
import org.herac.tuxguitar.util.TGContext;

public class TGTable {
    private TGContext context;
    private ScrolledComposite sComposite;
    private Composite table;
    private SashForm columnControl;
    private Composite rowControl;
    private TGTableColumn columnNumber;
    private TGTableColumn columnSoloMute;
    private TGTableColumn columnName;
    private TGTableColumn columnInstrument;
    private TGTableColumn columnCanvas;
    private List<TGTableRow> rows;
    private int rowHeight;
    private int scrollIncrement;

    public TGTable(TGContext context, Composite parent) {
        this.context = context;
        this.rows = new ArrayList<TGTableRow>();
        this.newTable(parent);
    }

    public void newTable(Composite parent) {
        this.sComposite = new ScrolledComposite(parent, 2560);
        this.sComposite.setLayout((Layout)new GridLayout());
        this.sComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sComposite.setAlwaysShowScrollBars(true);
        this.sComposite.setExpandHorizontal(true);
        this.sComposite.setExpandVertical(true);
        this.table = new Composite((Composite)this.sComposite, 0);
        this.table.setLayout((Layout)this.newGridLayout(1, 0, 0, 0, 0));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.columnControl = new SashForm(this.table, 256);
        this.columnControl.setLayoutData((Object)new GridData(4, 128, true, false));
        this.columnNumber = new TGTableColumn(this, 16384);
        this.columnSoloMute = new TGTableColumn(this, 16384);
        this.columnName = new TGTableColumn(this, 16384);
        this.columnInstrument = new TGTableColumn(this, 16384);
        this.columnCanvas = new TGTableColumn(this, 0x1000000);
        this.columnControl.setWeights(new int[]{1, 2, 7, 7, 20});
        this.rowControl = new Composite(this.table, 0);
        this.rowControl.setLayout((Layout)this.newGridLayout(1, 0, 1, 0, 1));
        this.rowControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sComposite.setContent((Control)this.table);
    }

    public Composite getControl() {
        return this.table;
    }

    public void newRow() {
        this.rows.add(new TGTableRow(this));
    }

    private GridLayout newGridLayout(int cols, int marginWidth, int marginHeight, int horizontalSpacing, int verticalSpacing) {
        GridLayout layout = new GridLayout(cols, false);
        layout.marginWidth = marginWidth;
        layout.marginHeight = marginHeight;
        layout.horizontalSpacing = horizontalSpacing;
        layout.verticalSpacing = verticalSpacing;
        return layout;
    }

    public void addRowItem(TGTableColumn column, Control control, boolean computeSize) {
        if (computeSize) {
            this.scrollIncrement = this.rowHeight = Math.max(this.rowHeight, control.computeSize((int)-1, (int)-1).y);
        }
        column.addControl(control);
    }

    public int getMinHeight() {
        return this.sComposite.getMinHeight() + this.sComposite.getBorderWidth() * 2;
    }

    public Composite getColumnControl() {
        return this.columnControl;
    }

    public Composite getRowControl() {
        return this.rowControl;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getScrollIncrement() {
        return this.scrollIncrement;
    }

    public TGTableColumn getColumnInstrument() {
        return this.columnInstrument;
    }

    public TGTableColumn getColumnName() {
        return this.columnName;
    }

    public TGTableColumn getColumnNumber() {
        return this.columnNumber;
    }

    public TGTableColumn getColumnSoloMute() {
        return this.columnSoloMute;
    }

    public TGTableColumn getColumnCanvas() {
        return this.columnCanvas;
    }

    public TGTableRow getRow(int index) {
        if (index >= 0 && index < this.rows.size()) {
            return this.rows.get(index);
        }
        return null;
    }

    public void removeRowsAfter(int index) {
        while (index < this.rows.size()) {
            TGTableRow row = this.rows.get(index);
            row.dispose();
            this.rows.remove(index);
        }
        this.notifyRemoved();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public void update() {
        this.layoutColumns();
        this.table.layout(true, true);
        this.sComposite.setMinHeight(this.table.computeSize((int)-1, (int)-1).y);
        this.sComposite.getVerticalBar().setIncrement(this.getScrollIncrement() + this.sComposite.getBorderWidth());
    }

    private void notifyRemoved() {
        this.columnNumber.notifyRemoved();
        this.columnSoloMute.notifyRemoved();
        this.columnName.notifyRemoved();
        this.columnInstrument.notifyRemoved();
        this.columnCanvas.notifyRemoved();
    }

    private void layoutColumns() {
        this.columnNumber.layout();
        this.columnSoloMute.layout();
        this.columnName.layout();
        this.columnInstrument.layout();
        this.columnCanvas.layout();
    }

    public TGContext getContext() {
        return this.context;
    }
}

