/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.tab;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.app.graphics.TGResourceFactoryImpl;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.view.component.tab.Caret;
import org.herac.tuxguitar.app.view.component.tab.TablaturePaintListener;
import org.herac.tuxguitar.app.view.component.tab.edit.EditorKit;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterListenerLocked;
import org.herac.tuxguitar.app.view.util.TGSyncProcess;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.TGRectangle;
import org.herac.tuxguitar.graphics.TGResourceFactory;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.graphics.control.TGController;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGLayoutHorizontal;
import org.herac.tuxguitar.graphics.control.TGLayoutStyles;
import org.herac.tuxguitar.graphics.control.TGLayoutVertical;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGResourceBuffer;
import org.herac.tuxguitar.player.base.MidiPlayerMode;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class Tablature
extends Composite
implements TGController {
    private static final int SCROLL_DELAY = 15;
    private static final int SCROLL_INCREMENT = 50;
    private TGContext context;
    private TGResourceFactory resourceFactory;
    private TGDocumentManager documentManager;
    private TGResourceBuffer resourceBuffer;
    private TGSyncProcess disposeUnregisteredResources;
    private Caret caret;
    private int width;
    private int height;
    private TGLayout viewLayout;
    private EditorKit editorKit;
    private TGBeatImpl playedBeat;
    private TGMeasureImpl playedMeasure;
    private int scrollX;
    private int scrollY;
    private boolean resetScroll;
    protected long lastVScrollTime;
    protected long lastHScrollTime;
    private boolean painting;

    public Tablature(TGContext context, Composite parent, int style, TGDocumentManager documentManager) {
        super(parent, style);
        this.context = context;
        this.documentManager = documentManager;
        this.caret = new Caret(this);
        this.editorKit = new EditorKit(this);
        this.createSyncProcesses();
    }

    public void initGUI() {
        this.addPaintListener(new TGBufferedPainterListenerLocked(this.context, new TablaturePaintListener(this)));
        ScrollBar hBar = this.getHorizontalBar();
        hBar.setIncrement(50);
        hBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (Tablature.this.lastHScrollTime + 15L < System.currentTimeMillis()) {
                    Tablature.this.redraw();
                    Tablature.this.lastHScrollTime = System.currentTimeMillis();
                }
            }
        });
        ScrollBar vBar = this.getVerticalBar();
        vBar.setIncrement(50);
        vBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (Tablature.this.lastVScrollTime + 15L < System.currentTimeMillis()) {
                    Tablature.this.redraw();
                    Tablature.this.lastVScrollTime = System.currentTimeMillis();
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                Tablature.this.updateScroll();
            }
        });
    }

    public void createSyncProcesses() {
        this.disposeUnregisteredResources = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                Tablature.this.getResourceBuffer().disposeUnregisteredResources();
            }
        });
    }

    public void updateTablature() {
        this.playedBeat = null;
        this.playedMeasure = null;
        this.getViewLayout().updateSong();
        this.getCaret().update();
        this.disposeUnregisteredResources.process();
    }

    public void updateMeasure(int number) {
        this.playedBeat = null;
        this.playedMeasure = null;
        this.getViewLayout().updateMeasureNumber(number);
        this.getCaret().update();
        this.disposeUnregisteredResources.process();
    }

    public void resetCaret() {
        this.caret.update(1, 960L, 1);
    }

    public void paintTablature(TGPainter painter) {
        this.setPainting(true);
        try {
            this.checkScroll();
            TGRectangle area = this.createRectangle(this.getClientArea());
            ScrollBar xScroll = this.getHorizontalBar();
            ScrollBar yScroll = this.getVerticalBar();
            this.scrollX = xScroll.getSelection();
            this.scrollY = yScroll.getSelection();
            this.fillBackground(painter, area);
            this.getViewLayout().paint(painter, area, (float)(-this.scrollX), (float)(-this.scrollY));
            this.getCaret().paintCaret(this.getViewLayout(), painter);
            this.getEditorKit().paintSelection(this.getViewLayout(), painter);
            this.width = Math.round(this.viewLayout.getWidth());
            this.height = Math.round(this.viewLayout.getHeight());
            this.updateScroll();
            if (TuxGuitar.getInstance().getPlayer().isRunning()) {
                this.redrawPlayingMode(painter, true);
            } else if (this.getCaret().hasChanges()) {
                this.getCaret().setChanges(false);
                this.moveScrollTo(this.getCaret().getMeasure(), xScroll, yScroll, area);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.setPainting(false);
    }

    public void fillBackground(TGPainter painter, TGRectangle area) {
        painter.setBackground(this.getViewLayout().getResources().getBackgroundColor());
        painter.initPath(2);
        painter.addRectangle(0.0f, 0.0f, area.getWidth(), area.getHeight());
        painter.closePath();
    }

    public void resetScroll() {
        this.resetScroll = true;
    }

    public void checkScroll() {
        if (this.resetScroll) {
            this.getHorizontalBar().setSelection(0);
            this.getVerticalBar().setSelection(0);
            this.resetScroll = false;
        }
    }

    public void updateScroll() {
        Rectangle bounds = this.getBounds();
        Rectangle client = this.getClientArea();
        ScrollBar hBar = this.getHorizontalBar();
        ScrollBar vBar = this.getVerticalBar();
        hBar.setMaximum(this.width);
        vBar.setMaximum(this.height);
        hBar.setThumb(Math.min(bounds.width, client.width));
        vBar.setThumb(Math.min(bounds.height, client.height));
    }

    public boolean moveScrollTo(TGMeasureImpl measure) {
        return this.moveScrollTo(measure, this.getHorizontalBar(), this.getVerticalBar(), this.createRectangle(this.getClientArea()));
    }

    public boolean moveScrollTo(TGMeasureImpl measure, ScrollBar xScroll, ScrollBar yScroll, TGRectangle area) {
        boolean success = false;
        if (measure != null && measure.getTs() != null) {
            int mX = Math.round(measure.getPosX());
            int mY = Math.round(measure.getPosY());
            int mWidth = Math.round(measure.getWidth(this.getViewLayout()));
            int mHeight = Math.round(measure.getTs().getSize());
            int marginWidth = Math.round(this.getViewLayout().getFirstMeasureSpacing());
            int marginHeight = Math.round(this.getViewLayout().getFirstTrackSpacing());
            boolean forceRedraw = false;
            if (mX < 0 || (float)(mX + mWidth) > area.getWidth() && (area.getWidth() >= (float)(mWidth + marginWidth) || mX > marginWidth)) {
                xScroll.setSelection(this.scrollX + mX - marginWidth);
                success = true;
            }
            if (mY < 0 || (float)(mY + mHeight) > area.getHeight() && (area.getHeight() >= (float)(mHeight + marginHeight) || mY > marginHeight)) {
                yScroll.setSelection(this.scrollY + mY - marginHeight);
                success = true;
            }
            if (!success) {
                boolean bl = forceRedraw = this.scrollX != xScroll.getSelection() || this.scrollY != yScroll.getSelection();
            }
            if (forceRedraw || success) {
                this.redraw();
            }
        }
        return success;
    }

    public void redraw() {
        if (!super.isDisposed()) {
            this.playedBeat = null;
            this.playedMeasure = null;
            this.setPainting(true);
            super.redraw();
        }
    }

    public void redrawPlayingMode() {
        if (!super.isDisposed() && !this.isPainting() && TuxGuitar.getInstance().getPlayer().isRunning()) {
            this.setPainting(true);
            TGPainterImpl painter = new TGPainterImpl(new GC((Drawable)this));
            this.redrawPlayingMode(painter, false);
            painter.dispose();
            this.setPainting(false);
        }
    }

    private void redrawPlayingMode(TGPainter painter, boolean force) {
        if (!super.isDisposed()) {
            try {
                TGMeasureImpl measure = TuxGuitar.getInstance().getEditorCache().getPlayMeasure();
                TGBeatImpl beat = TuxGuitar.getInstance().getEditorCache().getPlayBeat();
                if (measure != null && measure.hasTrack(this.getCaret().getTrack().getNumber()) && (!this.moveScrollTo(measure) || force)) {
                    boolean paintMeasure;
                    boolean bl = paintMeasure = force || this.playedMeasure == null || !this.playedMeasure.equals(measure);
                    if (this.playedMeasure != null && this.playedBeat != null && !this.playedMeasure.isOutOfBounds() && this.playedMeasure.hasTrack(this.getCaret().getTrack().getNumber())) {
                        this.getViewLayout().paintPlayMode(painter, this.playedMeasure, this.playedBeat, paintMeasure);
                    }
                    if (!measure.isOutOfBounds()) {
                        this.getViewLayout().paintPlayMode(painter, measure, beat, paintMeasure);
                    }
                    this.playedBeat = beat;
                    this.playedMeasure = measure;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public boolean isPainting() {
        return this.painting;
    }

    public void setPainting(boolean painting) {
        this.painting = painting;
    }

    public Caret getCaret() {
        return this.caret;
    }

    public EditorKit getEditorKit() {
        return this.editorKit;
    }

    public TGContext getContext() {
        return this.context;
    }

    public TGSongManager getSongManager() {
        return this.documentManager.getSongManager();
    }

    public TGSong getSong() {
        return this.documentManager.getSong();
    }

    public TGLayout getViewLayout() {
        return this.viewLayout;
    }

    public void setViewLayout(TGLayout viewLayout) {
        if (this.getViewLayout() != null) {
            this.getViewLayout().disposeLayout();
        }
        this.viewLayout = viewLayout;
        if (this.getHorizontalBar() != null) {
            this.getHorizontalBar().setSelection(0);
        }
        if (this.getVerticalBar() != null) {
            this.getVerticalBar().setSelection(0);
        }
        this.reloadStyles();
    }

    public TGRectangle createRectangle(Rectangle rectangle) {
        return new TGRectangle((float)rectangle.x, (float)rectangle.y, (float)rectangle.width, (float)rectangle.height);
    }

    public void reloadStyles() {
        if (this.getViewLayout() != null) {
            this.getViewLayout().loadStyles(1.0f);
        }
    }

    public void reloadViewLayout() {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        this.loadViewLayout(config.getIntegerValue("layout.style"), config.getIntegerValue("layout.mode"));
    }

    private void loadViewLayout(int style, int mode) {
        switch (mode) {
            case 1: {
                this.setViewLayout((TGLayout)new TGLayoutVertical((TGController)this, style));
                break;
            }
            case 2: {
                this.setViewLayout((TGLayout)new TGLayoutHorizontal((TGController)this, style));
                break;
            }
            default: {
                if (mode == 2) break;
                this.loadViewLayout(style, 2);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.getCaret().dispose();
        this.getViewLayout().disposeLayout();
        this.getResourceBuffer().disposeAllResources();
    }

    public TGResourceFactory getResourceFactory() {
        if (this.resourceFactory == null) {
            this.resourceFactory = new TGResourceFactoryImpl((Device)this.getDisplay());
        }
        return this.resourceFactory;
    }

    public TGResourceBuffer getResourceBuffer() {
        if (this.resourceBuffer == null) {
            this.resourceBuffer = new TGResourceBuffer();
        }
        return this.resourceBuffer;
    }

    public int getTrackSelection() {
        if ((this.getViewLayout().getStyle() & 2) == 0) {
            return this.getCaret().getTrack().getNumber();
        }
        return -1;
    }

    public boolean isRunning(TGBeat beat) {
        return this.isRunning(beat.getMeasure()) && TuxGuitar.getInstance().getEditorCache().isPlaying(beat.getMeasure(), beat);
    }

    public boolean isRunning(TGMeasure measure) {
        return measure.getTrack().equals(this.getCaret().getTrack()) && TuxGuitar.getInstance().getEditorCache().isPlaying(measure);
    }

    public boolean isLoopSHeader(TGMeasureHeader measureHeader) {
        MidiPlayerMode pm = TuxGuitar.getInstance().getPlayer().getMode();
        return pm.isLoop() && pm.getLoopSHeader() == measureHeader.getNumber();
    }

    public boolean isLoopEHeader(TGMeasureHeader measureHeader) {
        MidiPlayerMode pm = TuxGuitar.getInstance().getPlayer().getMode();
        return pm.isLoop() && pm.getLoopEHeader() == measureHeader.getNumber();
    }

    public void configureStyles(TGLayoutStyles styles) {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        styles.setBufferEnabled(true);
        styles.setStringSpacing((float)config.getIntegerValue("tab.line-spacing"));
        styles.setScoreLineSpacing((float)config.getIntegerValue("score.line-spacing"));
        styles.setFirstMeasureSpacing(20.0f);
        styles.setMinBufferSeparator(20.0f);
        styles.setMinTopSpacing(30.0f);
        styles.setMinScoreTabSpacing((float)config.getIntegerValue("score.min.score-tab-spacing"));
        styles.setFirstTrackSpacing((float)config.getIntegerValue("first-track.spacing"));
        styles.setTrackSpacing((float)config.getIntegerValue("track.spacing"));
        styles.setChordFretIndexSpacing(8.0f);
        styles.setChordStringSpacing(5.0f);
        styles.setChordFretSpacing(6.0f);
        styles.setChordNoteSize(4.0f);
        styles.setChordLineWidth(1.0f);
        styles.setRepeatEndingSpacing(20.0f);
        styles.setTextSpacing(15.0f);
        styles.setMarkerSpacing(15.0f);
        styles.setLoopMarkerSpacing(5.0f);
        styles.setDivisionTypeSpacing(10.0f);
        styles.setEffectSpacing(8.0f);
        styles.setDefaultFont(config.getFontModelConfigValue("font.default"));
        styles.setNoteFont(config.getFontModelConfigValue("font.note"));
        styles.setTimeSignatureFont(config.getFontModelConfigValue("font.time-signature"));
        styles.setLyricFont(config.getFontModelConfigValue("font.lyric"));
        styles.setTextFont(config.getFontModelConfigValue("font.text"));
        styles.setMarkerFont(config.getFontModelConfigValue("font.marker"));
        styles.setGraceFont(config.getFontModelConfigValue("font.grace"));
        styles.setChordFont(config.getFontModelConfigValue("font.chord"));
        styles.setChordFretFont(config.getFontModelConfigValue("font.chord-fret"));
        styles.setBackgroundColor(config.getColorModelConfigValue("color.background"));
        styles.setLineColor(config.getColorModelConfigValue("color.line"));
        styles.setScoreNoteColor(config.getColorModelConfigValue("color.score.note"));
        styles.setTabNoteColor(config.getColorModelConfigValue("color.tab.note"));
        styles.setPlayNoteColor(config.getColorModelConfigValue("color.play.note"));
        styles.setLoopSMarkerColor(config.getColorModelConfigValue("color.loop.s.marker"));
        styles.setLoopEMarkerColor(config.getColorModelConfigValue("color.loop.e.marker"));
        this.getCaret().setColor1(config.getColorModelConfigValue("color.caret.1"));
        this.getCaret().setColor2(config.getColorModelConfigValue("color.caret.2"));
    }
}

