/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.undo.impl.marker;

import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableMarkerGeneric
extends TGUndoableEditBase {
    private int doAction;
    private TGMarker undoMarker;
    private TGMarker redoMarker;

    private TGUndoableMarkerGeneric(TGContext context) {
        super(context);
    }

    public void redo() throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        if (this.redoMarker != null) {
            this.updateMarker(this.getSong(), this.redoMarker.clone(this.getSongManager().getFactory()));
        } else if (this.undoMarker != null) {
            this.removeMarker(this.getSong(), this.undoMarker.clone(this.getSongManager().getFactory()));
        }
        this.doAction = 1;
    }

    public void undo() throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        if (this.undoMarker != null) {
            this.updateMarker(this.getSong(), this.undoMarker.clone(this.getSongManager().getFactory()));
        } else if (this.redoMarker != null) {
            this.removeMarker(this.getSong(), this.redoMarker.clone(this.getSongManager().getFactory()));
        }
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableMarkerGeneric startUndo(TGContext context, TGMarker marker) {
        TGUndoableMarkerGeneric undoable = new TGUndoableMarkerGeneric(context);
        undoable.doAction = 1;
        undoable.undoMarker = marker != null ? marker.clone(TGUndoableMarkerGeneric.getSongManager((TGContext)context).getFactory()) : null;
        return undoable;
    }

    public TGUndoableMarkerGeneric endUndo(TGMarker marker) {
        this.redoMarker = marker != null ? marker.clone(this.getSongManager().getFactory()) : null;
        return this;
    }

    public void updateMarker(TGSong song, TGMarker marker) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.marker.update");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER, (Object)marker);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void removeMarker(TGSong song, TGMarker marker) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.marker.remove");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER, (Object)marker);
        this.processByPassUndoableAction(tgActionProcessor);
    }
}

