/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.browser;

import java.io.InputStream;
import java.util.List;
import org.herac.tuxguitar.app.tools.browser.TGBrowserConnectionHandler;
import org.herac.tuxguitar.app.tools.browser.TGBrowserException;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowser;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserElement;
import org.herac.tuxguitar.app.tools.browser.base.handler.TGBrowserCdElementHandler;
import org.herac.tuxguitar.app.tools.browser.base.handler.TGBrowserCdRootHandler;
import org.herac.tuxguitar.app.tools.browser.base.handler.TGBrowserCdUpHandler;
import org.herac.tuxguitar.app.tools.browser.base.handler.TGBrowserCloseHandler;
import org.herac.tuxguitar.app.tools.browser.base.handler.TGBrowserErrorHandler;
import org.herac.tuxguitar.app.tools.browser.base.handler.TGBrowserListElementsHandler;
import org.herac.tuxguitar.app.tools.browser.base.handler.TGBrowserOpenHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGBrowserConnection {
    private boolean locked;
    private TGBrowser browser;
    private TGBrowserConnectionHandler handler;

    public TGBrowserConnection(TGBrowserConnectionHandler handler) {
        this.handler = handler;
    }

    protected void lock() {
        this.locked = true;
        this.handler.notifyLockStatusChanged();
    }

    protected void unlock() {
        this.locked = false;
        this.handler.notifyLockStatusChanged();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public TGBrowser getBrowser() {
        return this.browser;
    }

    public boolean isOpen() {
        return this.getBrowser() != null;
    }

    public void open(final int callId, TGBrowser browser) {
        if (!this.isLocked()) {
            this.close(callId);
            this.lock();
            this.browser = browser;
            new Thread(new Runnable(){

                public void run() {
                    if (TGBrowserConnection.this.getBrowser() != null) {
                        TGBrowserConnection.this.getBrowser().open(new TGBrowserOpenHandlerImpl(callId));
                    } else {
                        TGBrowserConnection.this.notifyClosed(callId);
                    }
                }
            }).start();
        }
    }

    public void close(final int callId) {
        if (!this.isLocked()) {
            this.lock();
            final TGBrowser browser = this.getBrowser();
            this.browser = null;
            new Thread(new Runnable(){

                public void run() {
                    if (browser != null) {
                        browser.close(new TGBrowserCloseHandlerImpl(callId));
                    } else {
                        TGBrowserConnection.this.notifyClosed(callId);
                    }
                }
            }).start();
        }
    }

    public void cdRoot(final int callId) {
        if (!this.isLocked()) {
            this.lock();
            new Thread(new Runnable(){

                public void run() {
                    if (TGBrowserConnection.this.isOpen()) {
                        TGBrowserConnection.this.getBrowser().cdRoot(new TGBrowserCdHandlerImpl(callId));
                    } else {
                        TGBrowserConnection.this.notifyClosed(callId);
                    }
                }
            }).start();
        }
    }

    public void cdUp(final int callId) {
        if (!this.isLocked()) {
            this.lock();
            new Thread(new Runnable(){

                public void run() {
                    if (TGBrowserConnection.this.isOpen()) {
                        TGBrowserConnection.this.getBrowser().cdUp(new TGBrowserCdHandlerImpl(callId));
                    } else {
                        TGBrowserConnection.this.notifyClosed(callId);
                    }
                }
            }).start();
        }
    }

    public void cd(final int callId, final TGBrowserElement element) {
        if (!this.isLocked()) {
            this.lock();
            new Thread(new Runnable(){

                public void run() {
                    if (TGBrowserConnection.this.isOpen()) {
                        TGBrowserConnection.this.getBrowser().cdElement(element, new TGBrowserCdHandlerImpl(callId));
                    } else {
                        TGBrowserConnection.this.notifyClosed(callId);
                    }
                }
            }).start();
        }
    }

    public void listElements(final int callId) {
        if (!this.isLocked()) {
            this.lock();
            new Thread(new Runnable(){

                public void run() {
                    if (TGBrowserConnection.this.isOpen()) {
                        TGBrowserConnection.this.getBrowser().listElements(new TGBrowserListElementsHandlerImpl(callId));
                    } else {
                        TGBrowserConnection.this.notifyClosed(callId);
                    }
                }
            }).start();
        }
    }

    public void openStream(final int callId, final TGBrowserElement element) {
        if (!this.isLocked()) {
            this.lock();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        if (element == null) {
                            TGBrowserConnection.this.release();
                            return;
                        }
                        if (element.isFolder()) {
                            TGBrowserConnection.this.release();
                            TGBrowserConnection.this.cd(callId, element);
                        } else {
                            InputStream stream = element.getInputStream();
                            TGBrowserConnection.this.notifyStream(callId, stream, element);
                        }
                    }
                    catch (TGBrowserException e) {
                        TGBrowserConnection.this.notifyError(callId, e);
                    }
                }
            }).start();
        }
    }

    public void release() {
        this.unlock();
    }

    public void notifyCd(int callId) {
        this.handler.notifyCd(callId);
    }

    public void notifyClosed(int callId) {
        this.handler.notifyClosed(callId);
    }

    public void notifyElements(int callId, List<TGBrowserElement> elements) {
        this.handler.notifyElements(callId, elements);
    }

    public void notifyError(int callId, Throwable throwable) {
        this.handler.notifyError(callId, throwable);
    }

    public void notifyOpened(int callId) {
        this.handler.notifyOpened(callId);
    }

    public void notifyStream(int callId, InputStream stream, TGBrowserElement element) {
        this.handler.notifyStream(callId, stream, element);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TGBrowserListElementsHandlerImpl
    extends TGBrowserErrorHandlerImpl
    implements TGBrowserListElementsHandler {
        public TGBrowserListElementsHandlerImpl(int callId) {
            super(callId);
        }

        @Override
        public void onSuccess(List<TGBrowserElement> elements) {
            TGBrowserConnection.this.notifyElements(this.getCallId(), elements);
        }
    }

    private class TGBrowserCdHandlerImpl
    extends TGBrowserErrorHandlerImpl
    implements TGBrowserCdRootHandler,
    TGBrowserCdUpHandler,
    TGBrowserCdElementHandler {
        public TGBrowserCdHandlerImpl(int callId) {
            super(callId);
        }

        public void onSuccess() {
            TGBrowserConnection.this.notifyCd(this.getCallId());
        }
    }

    private class TGBrowserCloseHandlerImpl
    extends TGBrowserErrorHandlerImpl
    implements TGBrowserCloseHandler {
        public TGBrowserCloseHandlerImpl(int callId) {
            super(callId);
        }

        public void onSuccess() {
            TGBrowserConnection.this.notifyClosed(this.getCallId());
        }
    }

    private class TGBrowserOpenHandlerImpl
    extends TGBrowserErrorHandlerImpl
    implements TGBrowserOpenHandler {
        public TGBrowserOpenHandlerImpl(int callId) {
            super(callId);
        }

        public void onSuccess() {
            TGBrowserConnection.this.notifyOpened(this.getCallId());
        }
    }

    private class TGBrowserErrorHandlerImpl
    implements TGBrowserErrorHandler {
        private int callId;

        public TGBrowserErrorHandlerImpl(int callId) {
            this.callId = callId;
        }

        public void handleError(Throwable throwable) {
            TGBrowserConnection.this.notifyError(this.callId, throwable);
        }

        public int getCallId() {
            return this.callId;
        }
    }
}

