/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.system.keybindings;

import org.herac.tuxguitar.app.system.keybindings.KeyCode;

public class KeyBindingUtil {
    public static final int F1 = 0x100000A;
    public static final int F2 = 0x100000B;
    public static final int F3 = 0x100000C;
    public static final int F4 = 0x100000D;
    public static final int F5 = 0x100000E;
    public static final int F6 = 0x100000F;
    public static final int F7 = 0x1000010;
    public static final int F8 = 0x1000011;
    public static final int F9 = 0x1000012;
    public static final int F10 = 0x1000013;
    public static final int F11 = 0x1000014;
    public static final int F12 = 0x1000015;
    public static final int ESC = 27;
    public static final int PAUSE = 0x1000055;
    public static final int PRINT_SCREEN = 16777303;
    public static final int INSERT = 0x1000009;
    public static final int DELETE = 127;
    public static final int HOME = 0x1000007;
    public static final int PAGE_UP = 0x1000005;
    public static final int PAGE_DOWN = 0x1000006;
    public static final int END = 0x1000008;
    public static final int ALT = 65536;
    public static final int CONTROL = 262144;
    public static final int COMMAND = 0x400000;
    public static final int SHIFT = 131072;
    public static final int TAB = 9;
    public static final int BACKSPACE = 8;
    public static final int SPACE = 32;
    public static final int ENTER = 13;
    public static final int UP = 0x1000001;
    public static final int DOWN = 0x1000002;
    public static final int LEFT = 0x1000003;
    public static final int RIGHT = 0x1000004;
    public static final int NUMBER_0 = 48;
    public static final int NUMBER_1 = 49;
    public static final int NUMBER_2 = 50;
    public static final int NUMBER_3 = 51;
    public static final int NUMBER_4 = 52;
    public static final int NUMBER_5 = 53;
    public static final int NUMBER_6 = 54;
    public static final int NUMBER_7 = 55;
    public static final int NUMBER_8 = 56;
    public static final int NUMBER_9 = 57;
    public static final int MULTIPLY = 16777258;
    public static final int DIVIDE = 16777263;
    public static final int DECIMAL = 16777262;
    public static final String MASK_SEPARATOR = "+";
    public static final KeyCode[] MASK_KEYS = new KeyCode[]{new KeyCode(262144, "Control"), new KeyCode(131072, "Shift"), new KeyCode(65536, "Alt"), new KeyCode(0x400000, "\u2318")};
    public static final KeyCode[] SPECIAL_KEYS = new KeyCode[]{new KeyCode(0x100000A, "F1"), new KeyCode(0x100000B, "F2"), new KeyCode(0x100000C, "F3"), new KeyCode(0x100000D, "F4"), new KeyCode(0x100000E, "F5"), new KeyCode(0x100000F, "F6"), new KeyCode(0x1000010, "F7"), new KeyCode(0x1000011, "F8"), new KeyCode(0x1000012, "F9"), new KeyCode(0x1000013, "F10"), new KeyCode(0x1000014, "F11"), new KeyCode(0x1000015, "F12"), new KeyCode(27, "Esc"), new KeyCode(0x1000055, "Pause"), new KeyCode(16777303, "Print"), new KeyCode(0x1000009, "Ins"), new KeyCode(127, "Del"), new KeyCode(0x1000007, "Home"), new KeyCode(0x1000005, "PgUp"), new KeyCode(0x1000006, "PgDn"), new KeyCode(0x1000008, "End"), new KeyCode(0x1000001, "Up"), new KeyCode(0x1000002, "Down"), new KeyCode(0x1000003, "Left"), new KeyCode(0x1000004, "Right"), new KeyCode(9, "Tab"), new KeyCode(32, "Space"), new KeyCode(13, "Enter")};

    public static boolean isSpecialKey(int code) {
        for (int i = 0; i < SPECIAL_KEYS.length; ++i) {
            if (code != SPECIAL_KEYS[i].getCode()) continue;
            return true;
        }
        return false;
    }

    public static String getConversionKey(int code) {
        for (int i = 0; i < SPECIAL_KEYS.length; ++i) {
            if (code != SPECIAL_KEYS[i].getCode()) continue;
            return SPECIAL_KEYS[i].getKey();
        }
        return null;
    }

    public static String getConversionMask(int mask) {
        String fullMask = new String();
        for (int i = 0; i < MASK_KEYS.length; ++i) {
            if ((mask & MASK_KEYS[i].getCode()) != MASK_KEYS[i].getCode()) continue;
            fullMask = fullMask + MASK_KEYS[i].getKey() + MASK_SEPARATOR;
        }
        return fullMask;
    }
}

