/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.impl.system;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.dialog.marker.TGMarkerList;
import org.herac.tuxguitar.app.view.dialog.transport.TGTransportDialog;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.util.TGContext;

public class TGDisposeAction
extends TGActionBase {
    public static final String NAME = "action.system.dispose";

    public TGDisposeAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        this.closeModules();
        this.saveConfig();
        this.dispose();
    }

    protected void saveConfig() {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        config.setValue("layout.mode", TablatureEditor.getInstance(this.getContext()).getTablature().getViewLayout().getMode());
        config.setValue("layout.style", TablatureEditor.getInstance(this.getContext()).getTablature().getViewLayout().getStyle());
        config.setValue("show.piano", !TuxGuitar.getInstance().getPianoEditor().isDisposed());
        config.setValue("show.matrix", !TuxGuitar.getInstance().getMatrixEditor().isDisposed());
        config.setValue("show.fretboard", TuxGuitar.getInstance().getFretBoardEditor().isVisible());
        config.setValue("show.instruments", !TuxGuitar.getInstance().getChannelManager().isDisposed());
        config.setValue("show.transport", !TGTransportDialog.getInstance(this.getContext()).isDisposed());
        config.setValue("show.markers", !TGMarkerList.getInstance(this.getContext()).isDisposed());
        config.setValue("window.maximized", TuxGuitar.getInstance().getShell().getMaximized());
        config.setValue("window.width", TuxGuitar.getInstance().getShell().getClientArea().width);
        config.setValue("window.height", TuxGuitar.getInstance().getShell().getClientArea().height);
        config.setValue("editor.mouse.mode", TablatureEditor.getInstance(this.getContext()).getTablature().getEditorKit().getMouseMode());
        config.setValue("matrix.grids", TuxGuitar.getInstance().getMatrixEditor().getGrids());
        TuxGuitar.getInstance().getConfig().save();
    }

    protected void closeModules() {
        TuxGuitar.getInstance().getPlayer().close();
        TuxGuitar.getInstance().getPluginManager().disconnectAll();
    }

    protected void dispose() {
        TuxGuitar.getInstance().getTable().dispose();
        TuxGuitar.getInstance().getFretBoardEditor().dispose();
        TuxGuitar.getInstance().getTablatureEditor().getTablature().dispose();
        TuxGuitar.getInstance().getIconManager().disposeIcons();
        TuxGuitar.getInstance().getShell().dispose();
    }
}

