/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gm.settings;

import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelSettingsDialog;
import org.herac.tuxguitar.gm.GMChannelRoute;
import org.herac.tuxguitar.gm.GMChannelRouter;
import org.herac.tuxguitar.gm.GMChannelRouterConfigurator;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelParameter;
import org.herac.tuxguitar.song.models.TGSong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMChannelSettingsDialog
implements TGChannelSettingsDialog {
    private TGSong song;
    private TGChannel channel;
    private GMChannelRouter router;
    private Combo gmChannel1Combo;
    private Combo gmChannel2Combo;

    public GMChannelSettingsDialog(TGChannel channel, TGSong song) {
        this.song = song;
        this.channel = channel;
        this.router = new GMChannelRouter();
    }

    public void show(Shell parent) {
        this.configureRouter();
        Shell dialog = DialogUtils.newDialog((Shell)parent, (int)2144);
        dialog.setLayout((Layout)new GridLayout(1, false));
        dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        dialog.setText(TuxGuitar.getProperty((String)"gm.settings.dialog.title"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"gm.settings.dialog.tip"));
        Label gmChannel1Label = new Label((Composite)group, 0);
        gmChannel1Label.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        gmChannel1Label.setText(TuxGuitar.getProperty((String)"gm.settings.channel.label-1") + ":");
        this.gmChannel1Combo = new Combo((Composite)group, 12);
        this.gmChannel1Combo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.gmChannel1Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GMChannelSettingsDialog.this.updateChannel();
            }
        });
        Label gmChannel2Label = new Label((Composite)group, 0);
        gmChannel2Label.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        gmChannel2Label.setText(TuxGuitar.getProperty((String)"gm.settings.channel.label-2") + ":");
        this.gmChannel2Combo = new Combo((Composite)group, 12);
        this.gmChannel2Combo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.gmChannel2Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GMChannelSettingsDialog.this.updateChannel();
            }
        });
        this.updateChannelCombos();
        DialogUtils.openDialog((Shell)dialog, (int)10);
    }

    protected GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private void configureRouter() {
        GMChannelRouterConfigurator gmChannelRouterConfigurator = new GMChannelRouterConfigurator(this.router);
        gmChannelRouterConfigurator.configureRouter(this.song.getChannels());
    }

    private void updateChannelCombos() {
        GMChannelRoute route = this.router.getRoute(this.channel.getChannelId());
        List channels = this.router.getFreeChannels(route);
        this.reloadChannelCombo(this.gmChannel1Combo, channels, route.getChannel1(), "gm.settings.channel.value-1");
        this.reloadChannelCombo(this.gmChannel2Combo, channels, route.getChannel2(), "gm.settings.channel.value-2");
        boolean playerRunning = TuxGuitar.getInstance().getPlayer().isRunning();
        this.gmChannel1Combo.setEnabled(!playerRunning && !this.channel.isPercussionChannel() && this.gmChannel1Combo.getItemCount() > 0);
        this.gmChannel2Combo.setEnabled(!playerRunning && !this.channel.isPercussionChannel() && this.gmChannel2Combo.getItemCount() > 0);
    }

    private void reloadChannelCombo(Combo combo, List<Integer> channels, int selected, String valueKey) {
        int i;
        if (!(combo.getData() instanceof List) || this.isDifferentList(channels, (List)combo.getData())) {
            combo.removeAll();
            combo.setData(channels);
            for (i = 0; i < channels.size(); ++i) {
                combo.add(TuxGuitar.getProperty((String)valueKey, (String[])new String[]{channels.get(i).toString()}));
            }
        }
        for (i = 0; i < channels.size(); ++i) {
            Integer channel = channels.get(i);
            if (channel != selected) continue;
            combo.select(i);
        }
    }

    public void updateChannel() {
        int channel1 = -1;
        int channel2 = -1;
        int channel1Selection = this.gmChannel1Combo.getSelectionIndex();
        Object channel1Data = this.gmChannel1Combo.getData();
        if (channel1Selection >= 0 && channel1Data instanceof List && ((List)channel1Data).size() > channel1Selection) {
            channel1 = (Integer)((List)channel1Data).get(channel1Selection);
        }
        int channel2Selection = this.gmChannel2Combo.getSelectionIndex();
        Object channel2Data = this.gmChannel2Combo.getData();
        if (channel2Selection >= 0 && channel2Data instanceof List && ((List)channel2Data).size() > channel2Selection) {
            channel2 = (Integer)((List)channel2Data).get(channel2Selection);
        }
        this.setChannelParameter(this.channel, "gm-channel-1", Integer.toString(channel1));
        this.setChannelParameter(this.channel, "gm-channel-2", Integer.toString(channel2));
        this.configureRouter();
    }

    private void setChannelParameter(TGChannel tgChannel, String key, String value) {
        TGChannelParameter tgChannelParameter = this.findOrCreateChannelParameter(tgChannel, key);
        tgChannelParameter.setValue(value);
    }

    private TGChannelParameter findChannelParameter(TGChannel tgChannel, String key) {
        Iterator it = tgChannel.getParameters();
        while (it.hasNext()) {
            TGChannelParameter parameter = (TGChannelParameter)it.next();
            if (!parameter.getKey().equals(key)) continue;
            return parameter;
        }
        return null;
    }

    private TGChannelParameter findOrCreateChannelParameter(TGChannel tgChannel, String key) {
        TGChannelParameter tgChannelParameter = this.findChannelParameter(tgChannel, key);
        if (tgChannelParameter == null) {
            tgChannelParameter = TuxGuitar.getInstance().getSongManager().getFactory().newChannelParameter();
            tgChannelParameter.setKey(key);
            tgChannel.addParameter(tgChannelParameter);
        }
        return tgChannelParameter;
    }

    private boolean isDifferentList(List<?> list1, List<?> list2) {
        if (list1.size() != list2.size()) {
            return true;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return true;
        }
        return false;
    }
}

