/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp.ui;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.io.gtp.GTPSettingsManager;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTPSettingsDialog {
    private TGContext context;

    public GTPSettingsDialog(TGContext context) {
        this.context = context;
    }

    public void configure(Shell parent) {
        final List<String> charsets = this.getAvailableCharsets();
        final GTPSettingsManager settingsUtil = GTPSettingsManager.getInstance((TGContext)this.context);
        final Shell dialog = DialogUtils.newDialog((Shell)parent, (int)67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty((String)"gtp.settings.title"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"gtp.settings.charset.tip"));
        Label label = new Label((Composite)group, 16384);
        label.setText(TuxGuitar.getProperty((String)"gtp.settings.charset.select") + ":");
        final Combo value = new Combo((Composite)group, 12);
        value.setLayoutData((Object)new GridData(250, -1));
        for (int i = 0; i < charsets.size(); ++i) {
            String charset = charsets.get(i);
            value.add(charset);
            if (!charset.equals(settingsUtil.getSettings().getCharset())) continue;
            value.select(i);
        }
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setLayoutData((Object)data);
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int selection = value.getSelectionIndex();
                if (selection >= 0 && selection < charsets.size()) {
                    settingsUtil.getSettings().setCharset((String)charsets.get(selection));
                    settingsUtil.saveSettings();
                }
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.setLayoutData((Object)data);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog((Shell)dialog, (int)10);
    }

    private List<String> getAvailableCharsets() {
        ArrayList<String> charsets = new ArrayList<String>();
        for (Map.Entry<String, Charset> entry : Charset.availableCharsets().entrySet()) {
            charsets.add(entry.getKey());
        }
        return charsets;
    }
}

