/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.custom.converter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.custom.converter.TGConverterFormat;
import org.herac.tuxguitar.app.tools.custom.converter.TGConverterProcess;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGLocalFileExporter;
import org.herac.tuxguitar.io.base.TGOutputStreamBase;
import org.herac.tuxguitar.io.base.TGRawExporter;
import org.herac.tuxguitar.util.TGContext;

public class TGConverterDialog
implements TGEventListener {
    private static final int SHELL_WIDTH = 500;
    private TGContext context;
    protected Shell dialog;
    protected Group group;
    protected Label outputFormatLabel;
    protected Label outputFolderLabel;
    protected Label inputFolderLabel;
    protected Button inputFolderChooser;
    protected Button outputFolderChooser;
    protected Button buttonOK;
    protected Button buttonCancel;
    protected List<TGConverterFormat> outputFormats;

    public TGConverterDialog(TGContext context) {
        this.context = context;
        this.outputFormats = new ArrayList<TGConverterFormat>();
    }

    public TGContext getContext() {
        return this.context;
    }

    public void show() {
        this.dialog = DialogUtils.newDialog((Shell)TuxGuitar.getInstance().getShell(), (int)2144);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setMinimumSize(500, -1);
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TuxGuitar.getInstance().getIconManager().removeLoader((TGEventListener)TGConverterDialog.this);
                TuxGuitar.getInstance().getLanguageManager().removeLoader((TGEventListener)TGConverterDialog.this);
            }
        });
        this.group = new Group((Composite)this.dialog, 16);
        this.group.setLayout((Layout)new GridLayout());
        this.group.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite((Composite)this.group, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.outputFormatLabel = new Label(composite, 16384);
        this.outputFormatLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Combo outputFormat = new Combo(composite, 12);
        outputFormat.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.addFileFormats(outputFormat);
        this.inputFolderLabel = new Label(composite, 16384);
        this.inputFolderLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Text inputFolder = new Text(composite, 2048);
        inputFolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.inputFolderChooser = new Button(composite, 8);
        this.inputFolderChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(TGConverterDialog.this.dialog);
                String selection = directoryDialog.open();
                if (selection != null) {
                    inputFolder.setText(selection);
                }
            }
        });
        this.outputFolderLabel = new Label(composite, 16384);
        this.outputFolderLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Text outputFolder = new Text(composite, 2048);
        outputFolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.outputFolderChooser = new Button(composite, 8);
        this.outputFolderChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(TGConverterDialog.this.dialog);
                String selection = directoryDialog.open();
                if (selection != null) {
                    outputFolder.setText(selection);
                }
            }
        });
        Composite buttons = new Composite((Composite)this.dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(131072, 1024, true, false));
        this.buttonOK = new Button(buttons, 8);
        this.buttonOK.setLayoutData((Object)this.getGridData(80, 25));
        this.buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String inputFolderValue = inputFolder.getText();
                String outputFolderValue = outputFolder.getText();
                TGConverterFormat outputFormatValue = TGConverterDialog.this.getFileFormat(outputFormat.getSelectionIndex());
                if (inputFolderValue == null || inputFolderValue.trim().length() == 0) {
                    TGMessageDialogUtil.errorMessage((TGContext)TGConverterDialog.this.context, (Shell)TGConverterDialog.this.dialog, (String)TuxGuitar.getProperty((String)"batch.converter.input.folder.invalid"));
                } else if (outputFolderValue == null || outputFolderValue.trim().length() == 0) {
                    TGMessageDialogUtil.errorMessage((TGContext)TGConverterDialog.this.context, (Shell)TGConverterDialog.this.dialog, (String)TuxGuitar.getProperty((String)"batch.converter.output.folder.invalid"));
                } else if (outputFormatValue == null) {
                    TGMessageDialogUtil.errorMessage((TGContext)TGConverterDialog.this.context, (Shell)TGConverterDialog.this.dialog, (String)TuxGuitar.getProperty((String)"batch.converter.output.format.invalid"));
                } else {
                    TGConverterProcess process = new TGConverterProcess(TGConverterDialog.this.getContext());
                    process.start(inputFolderValue.trim(), outputFolderValue.trim(), outputFormatValue);
                    TGConverterDialog.this.dialog.dispose();
                }
            }
        });
        this.buttonCancel = new Button(buttons, 8);
        this.buttonCancel.setLayoutData((Object)this.getGridData(80, 25));
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGConverterDialog.this.dialog.dispose();
            }
        });
        this.dialog.setDefaultButton(this.buttonOK);
        this.loadIcons(false);
        this.loadProperties(false);
        TuxGuitar.getInstance().getIconManager().addLoader((TGEventListener)this);
        TuxGuitar.getInstance().getLanguageManager().addLoader((TGEventListener)this);
        DialogUtils.openDialog((Shell)this.dialog, (int)10);
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    private GridData getGridData(int minimumWidth, int minimumHeight) {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = minimumWidth;
        data.minimumHeight = minimumHeight;
        return data;
    }

    private void addFileFormats(Combo combo) {
        this.outputFormats.clear();
        TGFileFormatManager fileFormatManager = TGFileFormatManager.getInstance((TGContext)this.context);
        Iterator outputStreams = fileFormatManager.getOutputStreams();
        while (outputStreams.hasNext()) {
            TGOutputStreamBase stream = (TGOutputStreamBase)outputStreams.next();
            this.addFileFormats(combo, stream.getFileFormat(), stream);
        }
        Iterator exporters = fileFormatManager.getExporters();
        while (exporters.hasNext()) {
            TGRawExporter exporter = (TGRawExporter)exporters.next();
            if (!(exporter instanceof TGLocalFileExporter)) continue;
            this.addFileFormats(combo, ((TGLocalFileExporter)exporter).getFileFormat(), exporter);
        }
        if (this.outputFormats.size() > 0) {
            combo.select(0);
        }
    }

    private void addFileFormats(Combo combo, TGFileFormat format, Object exporter) {
        String[] extensions;
        if (format.getSupportedFormats() != null && (extensions = format.getSupportedFormats()) != null && extensions.length > 0) {
            for (int i = 0; i < extensions.length; ++i) {
                String exportName = format.getName();
                if (exporter instanceof TGLocalFileExporter) {
                    exportName = ((TGLocalFileExporter)exporter).getExportName();
                }
                combo.add(exportName + " (*." + extensions[i] + ")");
                this.outputFormats.add(new TGConverterFormat(extensions[i].trim(), exporter));
            }
        }
    }

    protected TGConverterFormat getFileFormat(int index) {
        if (index >= 0 && index < this.outputFormats.size()) {
            return this.outputFormats.get(index);
        }
        return null;
    }

    public void loadProperties() {
        this.loadProperties(true);
    }

    public void loadProperties(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty((String)"batch.converter"));
            this.group.setText(TuxGuitar.getProperty((String)"batch.converter.settings"));
            this.inputFolderLabel.setText(TuxGuitar.getProperty((String)"batch.converter.input.folder"));
            this.outputFolderLabel.setText(TuxGuitar.getProperty((String)"batch.converter.output.folder"));
            this.outputFormatLabel.setText(TuxGuitar.getProperty((String)"batch.converter.output.format"));
            this.buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
            this.buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
            if (layout) {
                this.dialog.layout(true, true);
            }
        }
    }

    public void loadIcons() {
        this.loadIcons(true);
    }

    public void loadIcons(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            this.inputFolderChooser.setImage(TuxGuitar.getInstance().getIconManager().getFileOpen());
            this.outputFolderChooser.setImage(TuxGuitar.getInstance().getIconManager().getFileOpen());
            if (layout) {
                this.dialog.layout(true, true);
            }
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-icon".equals(event.getEventType())) {
            this.loadIcons();
        } else if ("language".equals(event.getEventType())) {
            this.loadProperties();
        }
    }
}

