/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.util;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.app.graphics.TGImageImpl;
import org.herac.tuxguitar.editor.TGEditorManager;
import org.herac.tuxguitar.graphics.TGImage;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGBufferedPainterLocked {
    private TGContext context;
    private TGImage buffer;
    private TGBufferedPainterHandle handle;

    public TGBufferedPainterLocked(TGContext context, TGBufferedPainterHandle handle) {
        this.context = context;
        this.handle = handle;
        this.handle.getPaintableControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGBufferedPainterLocked.this.disposePaintBuffer();
            }
        });
    }

    public void disposePaintBuffer() {
        if (this.buffer != null && !this.buffer.isDisposed()) {
            this.buffer.dispose();
            this.buffer = null;
        }
    }

    public void fillPaintBuffer() {
        Rectangle size = this.handle.getPaintableControl().getClientArea();
        int clientWidth = size.width;
        int clientHeight = size.height;
        if (this.buffer == null || this.buffer.isDisposed() || this.buffer.getWidth() != (float)clientWidth || this.buffer.getHeight() != (float)clientHeight) {
            this.buffer = new TGImageImpl((Device)this.handle.getPaintableControl().getDisplay(), clientWidth, clientHeight);
        }
        TGPainter tgPainter = this.buffer.createPainter();
        this.handle.paintControl(tgPainter);
        tgPainter.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBufferLocked(TGPainter painter) {
        TGEditorManager editor = TGEditorManager.getInstance((TGContext)this.context);
        if (editor.tryLock()) {
            try {
                this.fillPaintBuffer();
            }
            finally {
                editor.unlock();
            }
        } else {
            this.redrawLater();
        }
        if (this.buffer != null && !this.buffer.isDisposed()) {
            painter.drawImage(this.buffer, 0.0f, 0.0f);
        }
    }

    public void redrawLater() {
        final Composite paintableControl = this.handle.getPaintableControl();
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            public void run() {
                if (!paintableControl.isDisposed()) {
                    paintableControl.redraw();
                }
            }
        });
    }

    public static interface TGBufferedPainterHandle {
        public void paintControl(TGPainter var1);

        public Composite getPaintableControl();
    }
}

