/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.player.base.MidiPlayerMode;

public class TransportMenuItem
extends TGMenuItem {
    private static final int STATUS_STOPPED = 1;
    private static final int STATUS_PAUSED = 2;
    private static final int STATUS_RUNNING = 3;
    private MenuItem transportMenuItem;
    private Menu menu;
    private MenuItem play;
    private MenuItem stop;
    private MenuItem metronome;
    private MenuItem countDown;
    private MenuItem mode;
    private MenuItem loopSHeader;
    private MenuItem loopEHeader;
    private int status;

    public TransportMenuItem(Shell shell, Menu parent, int style) {
        this.transportMenuItem = new MenuItem(parent, style);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.play = new MenuItem(this.menu, 8);
        this.play.addSelectionListener((SelectionListener)this.createActionProcessor("action.transport.play"));
        this.stop = new MenuItem(this.menu, 8);
        this.stop.addSelectionListener((SelectionListener)this.createActionProcessor("action.transport.stop"));
        new MenuItem(this.menu, 2);
        this.metronome = new MenuItem(this.menu, 32);
        this.metronome.addSelectionListener((SelectionListener)this.createActionProcessor("action.transport.metronome"));
        this.countDown = new MenuItem(this.menu, 32);
        this.countDown.addSelectionListener((SelectionListener)this.createActionProcessor("action.transport.count-down"));
        this.mode = new MenuItem(this.menu, 8);
        this.mode.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-transport-mode-dialog"));
        new MenuItem(this.menu, 2);
        this.loopSHeader = new MenuItem(this.menu, 32);
        this.loopSHeader.addSelectionListener((SelectionListener)this.createActionProcessor("action.transport.set-loop-start"));
        this.loopEHeader = new MenuItem(this.menu, 32);
        this.loopEHeader.addSelectionListener((SelectionListener)this.createActionProcessor("action.transport.set-loop-end"));
        this.transportMenuItem.setMenu(this.menu);
        this.status = 1;
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        TGMeasureImpl measure = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getMeasure();
        MidiPlayerMode pm = TuxGuitar.getInstance().getPlayer().getMode();
        this.metronome.setSelection(TuxGuitar.getInstance().getPlayer().isMetronomeEnabled());
        this.countDown.setSelection(TuxGuitar.getInstance().getPlayer().getCountDown().isEnabled());
        this.loopSHeader.setEnabled(pm.isLoop());
        this.loopSHeader.setSelection(measure != null && measure.getNumber() == pm.getLoopSHeader());
        this.loopEHeader.setEnabled(pm.isLoop());
        this.loopEHeader.setSelection(measure != null && measure.getNumber() == pm.getLoopEHeader());
        this.loadIcons(false);
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.transportMenuItem, "transport", null);
        this.setMenuItemTextAndAccelerator(this.play, "transport.start", "action.transport.play");
        this.setMenuItemTextAndAccelerator(this.stop, "transport.stop", "action.transport.stop");
        this.setMenuItemTextAndAccelerator(this.mode, "transport.mode", "action.gui.open-transport-mode-dialog");
        this.setMenuItemTextAndAccelerator(this.metronome, "transport.metronome", "action.transport.metronome");
        this.setMenuItemTextAndAccelerator(this.countDown, "transport.count-down", "action.transport.count-down");
        this.setMenuItemTextAndAccelerator(this.loopSHeader, "transport.set-loop-start", "action.transport.set-loop-start");
        this.setMenuItemTextAndAccelerator(this.loopEHeader, "transport.set-loop-end", "action.transport.set-loop-end");
    }

    public void loadIcons() {
        this.loadIcons(true);
        this.mode.setImage(TuxGuitar.getInstance().getIconManager().getTransportMode());
        this.metronome.setImage(TuxGuitar.getInstance().getIconManager().getTransportMetronome());
    }

    public void loadIcons(boolean force) {
        int lastStatus = this.status;
        this.status = TuxGuitar.getInstance().getPlayer().isRunning() ? 3 : (TuxGuitar.getInstance().getPlayer().isPaused() ? 2 : 1);
        if (force || lastStatus != this.status) {
            if (this.status == 3) {
                this.stop.setImage(TuxGuitar.getInstance().getIconManager().getTransportIconStop2());
                this.play.setImage(TuxGuitar.getInstance().getIconManager().getTransportIconPause());
            } else if (this.status == 2) {
                this.stop.setImage(TuxGuitar.getInstance().getIconManager().getTransportIconStop2());
                this.play.setImage(TuxGuitar.getInstance().getIconManager().getTransportIconPlay2());
            } else if (this.status == 1) {
                this.stop.setImage(TuxGuitar.getInstance().getIconManager().getTransportIconStop1());
                this.play.setImage(TuxGuitar.getInstance().getIconManager().getTransportIconPlay1());
            }
        }
    }
}

