/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;

public class TrackMenu
extends TGMenuItem {
    private Menu menu;
    private MenuItem first;
    private MenuItem last;
    private MenuItem next;
    private MenuItem previous;
    private MenuItem addTrack;
    private MenuItem cloneTrack;
    private MenuItem removeTrack;
    private MenuItem moveUp;
    private MenuItem moveDown;
    private MenuItem changeMute;
    private MenuItem changeSolo;
    private MenuItem lyrics;
    private MenuItem properties;

    public TrackMenu(Menu menu) {
        this.menu = menu;
    }

    public TrackMenu(Shell shell, int style) {
        this(new Menu((Decorations)shell, style));
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void showItems() {
        if (!this.isDisposed()) {
            this.first = new MenuItem(this.menu, 8);
            this.first.addSelectionListener((SelectionListener)this.createActionProcessor("action.track.go-first"));
            this.previous = new MenuItem(this.menu, 8);
            this.previous.addSelectionListener((SelectionListener)this.createActionProcessor("action.track.go-previous"));
            this.next = new MenuItem(this.menu, 8);
            this.next.addSelectionListener((SelectionListener)this.createActionProcessor("action.track.go-next"));
            this.last = new MenuItem(this.menu, 8);
            this.last.addSelectionListener((SelectionListener)this.createActionProcessor("action.track.go-last"));
            new MenuItem(this.menu, 2);
            this.addTrack = new MenuItem(this.menu, 8);
            this.addTrack.addSelectionListener((SelectionListener)this.createActionProcessor("action.track.add-new"));
            this.cloneTrack = new MenuItem(this.menu, 8);
            this.cloneTrack.addSelectionListener((SelectionListener)this.createActionProcessor("action.track.clone"));
            this.removeTrack = new MenuItem(this.menu, 8);
            this.removeTrack.addSelectionListener((SelectionListener)this.createActionProcessor("action.track.remove"));
            new MenuItem(this.menu, 2);
            this.moveUp = new MenuItem(this.menu, 8);
            this.moveUp.addSelectionListener((SelectionListener)this.createActionProcessor("action.track.move-up"));
            this.moveDown = new MenuItem(this.menu, 8);
            this.moveDown.addSelectionListener((SelectionListener)this.createActionProcessor("action.track.move-down"));
            new MenuItem(this.menu, 2);
            this.changeSolo = new MenuItem(this.menu, 32);
            this.changeSolo.addSelectionListener((SelectionListener)this.createActionProcessor("action.track.change-solo"));
            this.changeMute = new MenuItem(this.menu, 32);
            this.changeMute.addSelectionListener((SelectionListener)this.createActionProcessor("action.track.change-mute"));
            new MenuItem(this.menu, 2);
            this.lyrics = new MenuItem(this.menu, 8);
            this.lyrics.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.toggle-lyric-editor"));
            this.properties = new MenuItem(this.menu, 8);
            this.properties.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-track-properties-dialog"));
            this.loadIcons();
            this.loadProperties();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.setMenuItemTextAndAccelerator(this.first, "track.first", "action.track.go-first");
            this.setMenuItemTextAndAccelerator(this.last, "track.last", "action.track.go-last");
            this.setMenuItemTextAndAccelerator(this.previous, "track.previous", "action.track.go-previous");
            this.setMenuItemTextAndAccelerator(this.next, "track.next", "action.track.go-next");
            this.setMenuItemTextAndAccelerator(this.addTrack, "track.add", "action.track.add-new");
            this.setMenuItemTextAndAccelerator(this.cloneTrack, "track.clone", "action.track.clone");
            this.setMenuItemTextAndAccelerator(this.removeTrack, "track.remove", "action.track.remove");
            this.setMenuItemTextAndAccelerator(this.moveUp, "track.move-up", "action.track.move-up");
            this.setMenuItemTextAndAccelerator(this.moveDown, "track.move-down", "action.track.move-down");
            this.setMenuItemTextAndAccelerator(this.changeSolo, "track.solo", "action.track.change-solo");
            this.setMenuItemTextAndAccelerator(this.changeMute, "track.mute", "action.track.change-mute");
            this.setMenuItemTextAndAccelerator(this.lyrics, "track.lyrics", "action.gui.toggle-lyric-editor");
            this.setMenuItemTextAndAccelerator(this.properties, "track.properties", "action.gui.open-track-properties-dialog");
        }
    }

    public void update() {
        if (!this.isDisposed()) {
            TGTrackImpl track = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
            int tracks = track.getSong().countTracks();
            boolean isFirst = track.getNumber() == 1;
            boolean isLast = track.getNumber() == tracks;
            boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
            this.addTrack.setEnabled(!running);
            this.cloneTrack.setEnabled(!running);
            this.removeTrack.setEnabled(!running);
            this.moveUp.setEnabled(!running && tracks > 1);
            this.moveDown.setEnabled(!running && tracks > 1);
            this.first.setEnabled(!isFirst);
            this.previous.setEnabled(!isFirst);
            this.next.setEnabled(!isLast);
            this.last.setEnabled(!isLast);
            this.properties.setEnabled(!running);
            this.changeSolo.setSelection(track.isSolo());
            this.changeMute.setSelection(track.isMute());
        }
    }

    public void loadIcons() {
    }

    public boolean isDisposed() {
        return this.menu == null || this.menu.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.menu.dispose();
        }
    }
}

