/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.tremolopicking;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.action.effect.TGChangeTremoloPickingAction;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.util.TGContext;

public class TGTremoloPickingDialog
extends SelectionAdapter {
    private Button thirtySecondButton;
    private Button sixTeenthButton;
    private Button eighthButton;

    public void show(final TGViewContext context) {
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        final TGString string = (TGString)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING);
        TGNote note = (TGNote)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE);
        if (measure != null && beat != null && note != null && string != null) {
            Shell parent = (Shell)context.getAttribute("parent");
            final Shell dialog = DialogUtils.newDialog(parent, 67680);
            dialog.setLayout((Layout)new GridLayout());
            dialog.setText(TuxGuitar.getProperty("effects.tremolo-picking-editor"));
            Composite composite = new Composite((Composite)dialog, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            int horizontalSpan = 2;
            int duration = 8;
            if (note.getEffect().isTremoloPicking()) {
                duration = note.getEffect().getTremoloPicking().getDuration().getValue();
            }
            Group durationGroup = this.makeGroup(composite, horizontalSpan, TuxGuitar.getProperty("duration"));
            durationGroup.setLayout((Layout)new GridLayout(3, false));
            this.thirtySecondButton = new Button((Composite)durationGroup, 16);
            this.thirtySecondButton.setImage(TuxGuitar.getInstance().getIconManager().getDuration(32));
            this.thirtySecondButton.setLayoutData((Object)this.makeGridData(1));
            this.thirtySecondButton.setSelection(duration == 32);
            this.sixTeenthButton = new Button((Composite)durationGroup, 16);
            this.sixTeenthButton.setImage(TuxGuitar.getInstance().getIconManager().getDuration(16));
            this.sixTeenthButton.setLayoutData((Object)this.makeGridData(1));
            this.sixTeenthButton.setSelection(duration == 16);
            this.eighthButton = new Button((Composite)durationGroup, 16);
            this.eighthButton.setImage(TuxGuitar.getInstance().getIconManager().getDuration(8));
            this.eighthButton.setLayoutData((Object)this.makeGridData(1));
            this.eighthButton.setSelection(duration == 8);
            Composite buttons = new Composite((Composite)dialog, 0);
            buttons.setLayout((Layout)new GridLayout(3, false));
            buttons.setLayoutData((Object)new GridData(0x1000008, 1024, true, true));
            Button buttonOK = new Button(buttons, 8);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData((Object)this.getButtonData());
            buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    TGTremoloPickingDialog.this.changeTremoloPicking(context.getContext(), measure, beat, string, TGTremoloPickingDialog.this.getTremoloPicking());
                    dialog.dispose();
                }
            });
            Button buttonClean = new Button(buttons, 8);
            buttonClean.setText(TuxGuitar.getProperty("clean"));
            buttonClean.setLayoutData((Object)this.getButtonData());
            buttonClean.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    TGTremoloPickingDialog.this.changeTremoloPicking(context.getContext(), measure, beat, string, null);
                    dialog.dispose();
                }
            });
            Button buttonCancel = new Button(buttons, 8);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData((Object)this.getButtonData());
            buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });
            dialog.setDefaultButton(buttonOK);
            DialogUtils.openDialog(dialog, 10);
        }
    }

    private Group makeGroup(Composite parent, int horizontalSpan, String text) {
        Group group = new Group(parent, 16);
        group.setLayoutData((Object)this.makeGridData(horizontalSpan));
        group.setText(text);
        return group;
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private GridData makeGridData(int horizontalSpan) {
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = horizontalSpan;
        return data;
    }

    public TGEffectTremoloPicking getTremoloPicking() {
        TGEffectTremoloPicking effect = TuxGuitar.getInstance().getSongManager().getFactory().newEffectTremoloPicking();
        if (this.thirtySecondButton.getSelection()) {
            effect.getDuration().setValue(32);
        } else if (this.sixTeenthButton.getSelection()) {
            effect.getDuration().setValue(16);
        } else if (this.eighthButton.getSelection()) {
            effect.getDuration().setValue(8);
        } else {
            return null;
        }
        return effect;
    }

    public void changeTremoloPicking(TGContext context, TGMeasure measure, TGBeat beat, TGString string, TGEffectTremoloPicking effect) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.note.effect.change-tremolo-picking");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
        tgActionProcessor.setAttribute(TGChangeTremoloPickingAction.ATTRIBUTE_EFFECT, (Object)effect);
        tgActionProcessor.process();
    }
}

