/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.track;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.util.TGMusicKeyUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGTrackPropertiesDialog
implements TGEventListener {
    private static final String[] NOTE_NAMES = TGMusicKeyUtils.getSharpKeyNames("tuning");
    private static final int MINIMUM_LEFT_CONTROLS_WIDTH = 180;
    private static final int MINIMUM_BUTTON_WIDTH = 80;
    private static final int MINIMUM_BUTTON_HEIGHT = 25;
    private static final int MAX_STRINGS = 7;
    private static final int MIN_STRINGS = 4;
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    private TGViewContext context;
    private Shell dialog;
    private Text nameText;
    private TGColor trackColor;
    private List<TGString> tempStrings;
    private Button stringTransposition;
    private Button stringTranspositionTryKeepString;
    private Button stringTranspositionApplyToChords;
    private Spinner stringCountSpinner;
    private Combo[] stringCombos = new Combo[7];
    private Combo offsetCombo;
    private int stringCount;
    private Combo instrumentCombo;
    private Color colorButtonValue;
    private boolean percussionChannel;
    private TGProcess updateItemsProcess;

    public TGTrackPropertiesDialog(TGViewContext context) {
        this.context = context;
        this.createSyncProcesses();
    }

    public void show() {
        TGSongManager songManager = this.findSongManager();
        TGTrack track = this.findTrack();
        Shell parent = (Shell)this.context.getAttribute("parent");
        this.stringCount = track.getStrings().size();
        this.trackColor = track.getColor().clone(songManager.getFactory());
        this.percussionChannel = songManager.isPercussionChannel(track.getSong(), track.getChannelId());
        this.initTempStrings(track.getStrings());
        this.dialog = DialogUtils.newDialog(parent, 67680);
        this.dialog.setLayout((Layout)new GridLayout(2, false));
        this.dialog.setText(TuxGuitar.getProperty("track.properties"));
        Composite left = new Composite((Composite)this.dialog, 0);
        left.setLayout((Layout)new GridLayout());
        left.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite right = new Composite((Composite)this.dialog, 0);
        right.setLayout((Layout)new GridLayout());
        right.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite bottom = new Composite((Composite)this.dialog, 0);
        bottom.setLayout((Layout)new GridLayout(2, false));
        bottom.setLayoutData((Object)new GridData(0x1000008, 4, true, true, 2, 1));
        this.initTrackInfo((Composite)this.makeGroup(left, 1, TuxGuitar.getProperty("track.properties.general")), track);
        this.initInstrumentFields((Composite)this.makeGroup(left, 1, TuxGuitar.getProperty("instrument")), track);
        this.initTuningInfo((Composite)this.makeGroup(right, 2, TuxGuitar.getProperty("tuning")), track);
        this.initButtons(bottom);
        this.initListeners();
        this.updateTuningGroup(!this.percussionChannel);
        DialogUtils.openDialog(this.dialog, 10);
    }

    private Group makeGroup(Composite parent, int horizontalSpan, String text) {
        Group group = new Group(parent, 16);
        group.setLayoutData((Object)this.makeGridData(horizontalSpan));
        group.setText(text);
        return group;
    }

    private GridData makeGridData(int horizontalSpan) {
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = horizontalSpan;
        return data;
    }

    public GridData getButtonsData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private void initListeners() {
        this.addListeners();
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGTrackPropertiesDialog.this.removeListeners();
            }
        });
    }

    private void initTrackInfo(Composite composite, TGTrack track) {
        composite.setLayout((Layout)new GridLayout());
        Composite top = new Composite(composite, 0);
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)new GridData(4, 128, true, true));
        Composite bottom = new Composite(composite, 0);
        bottom.setLayout((Layout)new GridLayout());
        bottom.setLayoutData((Object)new GridData(4, 1024, true, true));
        Label nameLabel = new Label(top, 0);
        nameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        nameLabel.setText(TuxGuitar.getProperty("track.name") + ":");
        this.nameText = new Text(top, 2048);
        this.nameText.setLayoutData((Object)this.getAlignmentData(180, 4));
        this.nameText.setText(track.getName());
        Label colorLabel = new Label(bottom, 0);
        colorLabel.setText(TuxGuitar.getProperty("track.color") + ":");
        colorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        final Button colorButton = new Button(bottom, 8);
        colorButton.setLayoutData((Object)this.getAlignmentData(180, 4));
        colorButton.setText(TuxGuitar.getProperty("choose"));
        colorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(TGTrackPropertiesDialog.this.dialog);
                dlg.setRGB(TGTrackPropertiesDialog.this.dialog.getDisplay().getSystemColor(2).getRGB());
                dlg.setText(TuxGuitar.getProperty("choose-color"));
                RGB rgb = dlg.open();
                if (rgb != null) {
                    TGTrackPropertiesDialog.this.trackColor.setR(rgb.red);
                    TGTrackPropertiesDialog.this.trackColor.setG(rgb.green);
                    TGTrackPropertiesDialog.this.trackColor.setB(rgb.blue);
                    TGTrackPropertiesDialog.this.setButtonColor(colorButton);
                }
            }
        });
        colorButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGTrackPropertiesDialog.this.disposeButtonColor();
            }
        });
        this.setButtonColor(colorButton);
    }

    private void initTuningInfo(Composite composite, TGTrack track) {
        composite.setLayout((Layout)new GridLayout(2, false));
        this.initTuningData(composite, track);
        this.initTuningCombos(composite);
    }

    private void initTuningCombos(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(131072, 4, false, true));
        String[] tuningTexts = this.getAllValueNames();
        for (int i = 0; i < 7; ++i) {
            this.stringCombos[i] = new Combo(composite, 12);
            this.stringCombos[i].setItems(tuningTexts);
        }
    }

    private void initTuningData(Composite parent, TGTrack track) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 128, true, true));
        Composite top = new Composite(composite, 0);
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)new GridData(4, 128, true, true));
        Composite middle = new Composite(composite, 0);
        middle.setLayout((Layout)new GridLayout());
        middle.setLayoutData((Object)new GridData(4, 128, true, true));
        Composite bottom = new Composite(composite, 0);
        bottom.setLayout((Layout)new GridLayout());
        bottom.setLayoutData((Object)new GridData(4, 128, true, true));
        Label stringCountLabel = new Label(top, 0);
        stringCountLabel.setText(TuxGuitar.getProperty("tuning.strings") + ":");
        stringCountLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        this.stringCountSpinner = new Spinner(top, 2048);
        this.stringCountSpinner.setLayoutData((Object)new GridData(4, 128, true, true));
        this.stringCountSpinner.setMinimum(4);
        this.stringCountSpinner.setMaximum(7);
        this.stringCountSpinner.setSelection(this.stringCount);
        this.stringCountSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGTrackPropertiesDialog.this.stringCount = TGTrackPropertiesDialog.this.stringCountSpinner.getSelection();
                TGTrackPropertiesDialog.this.setDefaultTuning(TGTrackPropertiesDialog.this.percussionChannel);
                TGTrackPropertiesDialog.this.updateTuningGroup(!TGTrackPropertiesDialog.this.percussionChannel);
            }
        });
        Label offsetLabel = new Label(middle, 0);
        offsetLabel.setText(TuxGuitar.getProperty("tuning.offset") + ":");
        offsetLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        this.offsetCombo = new Combo(middle, 12);
        this.offsetCombo.setLayoutData((Object)new GridData(4, 128, true, true));
        for (int i = -24; i <= 24; ++i) {
            this.offsetCombo.add(Integer.toString(i));
            if (i != track.getOffset()) continue;
            this.offsetCombo.select(i - -24);
        }
        this.stringTransposition = new Button(bottom, 32);
        this.stringTransposition.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.stringTransposition.setText(TuxGuitar.getProperty("tuning.strings.transpose"));
        this.stringTransposition.setSelection(true);
        this.stringTranspositionApplyToChords = new Button(bottom, 32);
        this.stringTranspositionApplyToChords.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.stringTranspositionApplyToChords.setText(TuxGuitar.getProperty("tuning.strings.transpose.apply-to-chords"));
        this.stringTranspositionApplyToChords.setSelection(true);
        this.stringTranspositionTryKeepString = new Button(bottom, 32);
        this.stringTranspositionTryKeepString.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.stringTranspositionTryKeepString.setText(TuxGuitar.getProperty("tuning.strings.transpose.try-keep-strings"));
        this.stringTranspositionTryKeepString.setSelection(true);
        this.stringTransposition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button stringTransposition = TGTrackPropertiesDialog.this.stringTransposition;
                Button stringTranspositionApplyToChords = TGTrackPropertiesDialog.this.stringTranspositionApplyToChords;
                Button stringTranspositionTryKeepString = TGTrackPropertiesDialog.this.stringTranspositionTryKeepString;
                stringTranspositionApplyToChords.setEnabled(stringTransposition.isEnabled() && stringTransposition.getSelection());
                stringTranspositionTryKeepString.setEnabled(stringTransposition.isEnabled() && stringTransposition.getSelection());
            }
        });
    }

    private GridData getAlignmentData(int minimumWidth, int horizontalAlignment) {
        GridData data = new GridData();
        data.minimumWidth = minimumWidth;
        data.horizontalAlignment = horizontalAlignment;
        data.verticalAlignment = -1;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        return data;
    }

    private void initButtons(Composite parent) {
        Button buttonOK = new Button(parent, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonsData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGTrackPropertiesDialog.this.updateTrackProperties();
                TGTrackPropertiesDialog.this.dialog.dispose();
            }
        });
        Button buttonCancel = new Button(parent, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonsData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGTrackPropertiesDialog.this.dialog.dispose();
            }
        });
        this.dialog.setDefaultButton(buttonOK);
    }

    private void initInstrumentFields(Composite composite, TGTrack track) {
        composite.setLayout((Layout)new GridLayout());
        Composite top = new Composite(composite, 0);
        top.setLayout((Layout)new GridLayout(2, false));
        top.setLayoutData((Object)new GridData(4, 128, true, true));
        Label instrumentLabel = new Label(top, 0);
        instrumentLabel.setText(TuxGuitar.getProperty("instrument") + ":");
        instrumentLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.instrumentCombo = new Combo(top, 12);
        this.instrumentCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.instrumentCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGTrackPropertiesDialog.this.checkPercussionChannel();
            }
        });
        this.loadChannels(track.getChannelId());
        TGActionProcessorListener settingsListener = new TGActionProcessorListener(this.context.getContext(), "action.gui.toggle-channels-dialog");
        settingsListener.setAttribute("parent", this.dialog);
        Button settings = new Button(top, 8);
        settings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        settings.setToolTipText(TuxGuitar.getProperty("settings"));
        settings.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        settings.addSelectionListener((SelectionListener)settingsListener);
    }

    protected void loadChannels(int selectedChannelId) {
        ArrayList<Integer> tgChannelsData = new ArrayList<Integer>();
        List tgChannelsAvailable = this.findSongManager().getChannels(this.findSong());
        Combo tgChannelsCombo = this.instrumentCombo;
        tgChannelsCombo.removeAll();
        tgChannelsCombo.add(TuxGuitar.getProperty("track.instrument.default-select-option"));
        tgChannelsCombo.select(0);
        tgChannelsData.add(new Integer(-1));
        for (int i = 0; i < tgChannelsAvailable.size(); ++i) {
            TGChannel tgChannel = (TGChannel)tgChannelsAvailable.get(i);
            tgChannelsData.add(new Integer(tgChannel.getChannelId()));
            tgChannelsCombo.add(tgChannel.getName());
            if (tgChannel.getChannelId() != selectedChannelId) continue;
            tgChannelsCombo.select(tgChannelsCombo.getItemCount() - 1);
        }
        tgChannelsCombo.setData(tgChannelsData);
    }

    protected void reloadChannels() {
        this.loadChannels(this.getSelectedChannelId());
    }

    protected void checkPercussionChannel() {
        boolean percussionChannel = this.findSongManager().isPercussionChannel(this.findSong(), this.getSelectedChannelId());
        if (this.percussionChannel != percussionChannel) {
            this.setDefaultTuning(percussionChannel);
            this.updateTuningGroup(!percussionChannel);
        }
        this.percussionChannel = percussionChannel;
    }

    protected int getSelectedChannelId() {
        Object data;
        int index = this.instrumentCombo.getSelectionIndex();
        if (index >= 0 && (data = this.instrumentCombo.getData()) instanceof List && ((List)data).size() > index) {
            return (Integer)((List)data).get(index);
        }
        return -1;
    }

    protected void updateTrackProperties() {
        boolean transposeTryKeepString;
        TGSongManager songManager = this.findSongManager();
        TGSong song = this.findSong();
        TGTrack track = this.findTrack();
        String trackName = this.nameText.getText();
        ArrayList<TGString> strings = new ArrayList<TGString>();
        for (int i = 0; i < this.stringCount; ++i) {
            strings.add(TGSongManager.newString((TGFactory)this.findSongManager().getFactory(), (int)(i + 1), (int)this.stringCombos[i].getSelectionIndex()));
        }
        Integer channelId = this.getSelectedChannelId();
        TGChannel channel = songManager.getChannel(song, channelId.intValue());
        Integer offset = songManager.isPercussionChannel(song, channelId.intValue()) ? 0 : -24 + this.offsetCombo.getSelectionIndex();
        TGColor trackColor = this.trackColor;
        boolean infoChanges = this.hasInfoChanges(track, trackName, trackColor, offset);
        boolean tuningChanges = this.hasTuningChanges(track, strings);
        boolean channelChanges = this.hasChannelChanges(track, channelId);
        boolean transposeStrings = this.shouldTransposeStrings(track, channelId);
        boolean transposeApplyToChords = transposeStrings && this.stringTranspositionApplyToChords.getSelection();
        boolean bl = transposeTryKeepString = transposeStrings && this.stringTranspositionTryKeepString.getSelection();
        if (infoChanges || tuningChanges || channelChanges) {
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.track.change-properties");
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
            if (infoChanges) {
                tgActionProcessor.setAttribute("updateInfo", (Object)Boolean.TRUE);
                tgActionProcessor.setAttribute("name", (Object)trackName);
                tgActionProcessor.setAttribute("color", (Object)trackColor);
                tgActionProcessor.setAttribute("offset", (Object)offset);
            }
            if (tuningChanges) {
                tgActionProcessor.setAttribute("updateTuning", (Object)Boolean.TRUE);
                tgActionProcessor.setAttribute("strings", strings);
                tgActionProcessor.setAttribute("transposeStrings", (Object)transposeStrings);
                tgActionProcessor.setAttribute("transposeTryKeepString", (Object)transposeTryKeepString);
                tgActionProcessor.setAttribute("transposeApplyToChords", (Object)transposeApplyToChords);
            }
            if (channelChanges) {
                tgActionProcessor.setAttribute("updateChannel", (Object)Boolean.TRUE);
                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHANNEL, (Object)channel);
            }
            tgActionProcessor.process();
        }
    }

    protected boolean shouldTransposeStrings(TGTrack track, int selectedChannelId) {
        if (this.stringTransposition.getSelection()) {
            boolean percussionChannelNew = this.findSongManager().isPercussionChannel(track.getSong(), selectedChannelId);
            boolean percussionChannelOld = this.findSongManager().isPercussionChannel(track.getSong(), track.getChannelId());
            return !percussionChannelNew && !percussionChannelOld;
        }
        return false;
    }

    protected boolean hasInfoChanges(TGTrack track, String name, TGColor color, int offset) {
        if (!name.equals(track.getName())) {
            return true;
        }
        if (!color.isEqual(track.getColor())) {
            return true;
        }
        return offset != track.getOffset();
    }

    protected boolean hasChannelChanges(TGTrack track, int channelId) {
        return track.getChannelId() != channelId;
    }

    protected boolean hasTuningChanges(TGTrack track, List<TGString> newStrings) {
        List oldStrings = track.getStrings();
        if (oldStrings.size() != newStrings.size()) {
            return true;
        }
        for (int i = 0; i < oldStrings.size(); ++i) {
            TGString oldString = (TGString)oldStrings.get(i);
            boolean stringExists = false;
            for (int j = 0; j < newStrings.size(); ++j) {
                TGString newString = newStrings.get(j);
                if (!newString.isEqual(oldString)) continue;
                stringExists = true;
            }
            if (stringExists) continue;
            return true;
        }
        return false;
    }

    protected void setButtonColor(Button button) {
        Color color = new Color((Device)this.dialog.getDisplay(), this.trackColor.getR(), this.trackColor.getG(), this.trackColor.getB());
        button.setForeground(color);
        this.disposeButtonColor();
        this.colorButtonValue = color;
    }

    protected void disposeButtonColor() {
        if (this.colorButtonValue != null && !this.colorButtonValue.isDisposed()) {
            this.colorButtonValue.dispose();
            this.colorButtonValue = null;
        }
    }

    protected void updateTuningGroup(boolean enabled) {
        int i;
        for (i = 0; i < this.tempStrings.size(); ++i) {
            TGString string = this.tempStrings.get(i);
            this.stringCombos[i].select(string.getValue());
            this.stringCombos[i].setVisible(true);
            this.stringCombos[i].setEnabled(enabled);
        }
        for (i = this.tempStrings.size(); i < 7; ++i) {
            this.stringCombos[i].select(0);
            this.stringCombos[i].setVisible(false);
        }
        this.offsetCombo.setEnabled(enabled);
        this.stringTransposition.setEnabled(enabled);
        this.stringTranspositionApplyToChords.setEnabled(enabled && this.stringTransposition.getSelection());
        this.stringTranspositionTryKeepString.setEnabled(enabled && this.stringTransposition.getSelection());
    }

    protected void initTempStrings(List<TGString> realStrings) {
        this.tempStrings = new ArrayList<TGString>();
        for (int i = 0; i < realStrings.size(); ++i) {
            TGString realString = realStrings.get(i);
            this.tempStrings.add(realString.clone(this.findSongManager().getFactory()));
        }
    }

    protected void setDefaultTuning(boolean percussionChannel) {
        this.tempStrings.clear();
        if (percussionChannel) {
            this.tempStrings.addAll(this.findSongManager().createPercussionStrings(this.stringCount));
        } else {
            this.tempStrings.addAll(this.findSongManager().createDefaultInstrumentStrings(this.stringCount));
        }
    }

    protected String[] getAllValueNames() {
        String[] valueNames = new String[120];
        for (int i = 0; i < valueNames.length; ++i) {
            valueNames[i] = NOTE_NAMES[i - i / 12 * 12] + i / 12;
        }
        return valueNames;
    }

    public void addListeners() {
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    public TGSongManager findSongManager() {
        return (TGSongManager)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER);
    }

    public TGSong findSong() {
        return (TGSong)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
    }

    public TGTrack findTrack() {
        return (TGTrack)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
    }

    public void updateItems() {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.reloadChannels();
        }
    }

    public void createSyncProcesses() {
        this.updateItemsProcess = new TGSyncProcessLocked(this.context.getContext(), new Runnable(){

            public void run() {
                TGTrackPropertiesDialog.this.updateItems();
            }
        });
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateItemsProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }
}

