/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.text;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.util.TGContext;

public class TGTextDialog {
    public void show(final TGViewContext context) {
        final TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        Shell parent = (Shell)context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("text.editor"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("text.insert"));
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)this.getMainData());
        Label label = new Label(composite, 16384);
        label.setText(TuxGuitar.getProperty("text.text") + ":");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        final Text text = new Text(composite, 2052);
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        text.setText(beat.getText() != null ? beat.getText().getValue() : new String());
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGTextDialog.this.doInsertText(context.getContext(), beat, text.getText());
                dialog.dispose();
            }
        });
        Button buttonClean = new Button(buttons, 8);
        buttonClean.setText(TuxGuitar.getProperty("clean"));
        buttonClean.setLayoutData((Object)this.getButtonData());
        buttonClean.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGTextDialog.this.doRemoveText(context.getContext(), beat);
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getMainData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 300;
        return data;
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    public void doInsertText(TGContext context, TGBeat beat, String textValue) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.beat.general.insert-text");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute("textValue", (Object)textValue);
        tgActionProcessor.processOnNewThread();
    }

    public void doRemoveText(TGContext context, TGBeat beat) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.beat.general.remove-text");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.processOnNewThread();
    }
}

