/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.tempo;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.util.TGContext;

public class TGTempoDialog {
    private static final int MIN_TEMPO = 30;
    private static final int MAX_TEMPO = 320;
    protected static final int[] DEFAULT_PERCENTS = new int[]{25, 50, 75, 100, 125, 150, 175, 200};

    public void show(final TGViewContext context) {
        Shell parent = (Shell)context.getAttribute("parent");
        final TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final TGMeasureHeader header = (TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("composition.tempo"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("composition.tempo"));
        TGTempo currentTempo = header.getTempo();
        Label tempoLabel = new Label((Composite)group, 0);
        tempoLabel.setText(TuxGuitar.getProperty("composition.tempo"));
        final Spinner tempo = new Spinner((Composite)group, 2048);
        tempo.setLayoutData((Object)this.getSpinnerData());
        tempo.setMinimum(30);
        tempo.setMaximum(320);
        tempo.setSelection(currentTempo.getValue());
        Group options = new Group((Composite)dialog, 16);
        options.setLayout((Layout)new GridLayout());
        options.setLayoutData((Object)new GridData(4, 4, true, true));
        options.setText(TuxGuitar.getProperty("options"));
        final Button applyToAllMeasures = new Button((Composite)options, 16);
        applyToAllMeasures.setText(TuxGuitar.getProperty("composition.tempo.start-to-end"));
        final Button applyToEnd = new Button((Composite)options, 16);
        applyToEnd.setText(TuxGuitar.getProperty("composition.tempo.position-to-end"));
        final Button applyToNext = new Button((Composite)options, 16);
        applyToNext.setText(TuxGuitar.getProperty("composition.tempo.position-to-next"));
        applyToAllMeasures.setSelection(true);
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Integer value = tempo.getSelection();
                Integer applyTo = TGTempoDialog.this.parseApplyTo(applyToAllMeasures, applyToEnd, applyToNext);
                TGTempoDialog.this.changeTempo(context.getContext(), song, header, value, applyTo);
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private GridData getSpinnerData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 150;
        return data;
    }

    private Integer parseApplyTo(Button applyToAll, Button applyToEnd, Button applyToNext) {
        if (applyToAll.getSelection()) {
            return 1;
        }
        if (applyToEnd.getSelection()) {
            return 2;
        }
        if (applyToNext.getSelection()) {
            return 3;
        }
        return 0;
    }

    public void changeTempo(TGContext context, TGSong song, TGMeasureHeader header, Integer value, Integer applyTo) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.composition.change-tempo-range");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, (Object)header);
        tgActionProcessor.setAttribute("tempoValue", (Object)value);
        tgActionProcessor.setAttribute("applyTo", (Object)applyTo);
        tgActionProcessor.processOnNewThread();
    }
}

