/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.stroke;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.util.TGContext;

public class TGStrokeDialog
extends SelectionAdapter {
    public static final int WIDTH = 400;
    public static final int HEIGHT = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_CLEAN = 2;
    public static final int STATUS_CANCEL = 3;
    private Button duration4;
    private Button duration8;
    private Button duration16;
    private Button duration32;
    private Button duration64;

    public void show(final TGViewContext context) {
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        final Integer direction = (Integer)context.getAttribute("strokeDirection");
        Shell parent = (Shell)context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("beat.stroke"));
        int duration = 16;
        if (beat.getStroke().getDirection() != 0) {
            duration = beat.getStroke().getValue();
        }
        Group group = new Group((Composite)dialog, 16);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(5, false));
        group.setText(TuxGuitar.getProperty("duration"));
        this.duration64 = new Button((Composite)group, 16);
        this.duration64.setImage(TuxGuitar.getInstance().getIconManager().getDuration(64));
        this.duration64.setLayoutData((Object)new GridData(4, 4, true, true));
        this.duration64.setSelection(duration == 64);
        this.duration32 = new Button((Composite)group, 16);
        this.duration32.setImage(TuxGuitar.getInstance().getIconManager().getDuration(32));
        this.duration32.setLayoutData((Object)new GridData(4, 4, true, true));
        this.duration32.setSelection(duration == 32);
        this.duration16 = new Button((Composite)group, 16);
        this.duration16.setImage(TuxGuitar.getInstance().getIconManager().getDuration(16));
        this.duration16.setLayoutData((Object)new GridData(4, 4, true, true));
        this.duration16.setSelection(duration == 16);
        this.duration8 = new Button((Composite)group, 16);
        this.duration8.setImage(TuxGuitar.getInstance().getIconManager().getDuration(8));
        this.duration8.setLayoutData((Object)new GridData(4, 4, true, true));
        this.duration8.setSelection(duration == 8);
        this.duration4 = new Button((Composite)group, 16);
        this.duration4.setImage(TuxGuitar.getInstance().getIconManager().getDuration(4));
        this.duration4.setLayoutData((Object)new GridData(4, 4, true, true));
        this.duration4.setSelection(duration == 4);
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 1024, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGStrokeDialog.this.changeStroke(context.getContext(), measure, beat, direction, TGStrokeDialog.this.getSelection());
                dialog.dispose();
            }
        });
        Button buttonClean = new Button(buttons, 8);
        buttonClean.setText(TuxGuitar.getProperty("clean"));
        buttonClean.setLayoutData((Object)this.getButtonData());
        buttonClean.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGStrokeDialog.this.changeStroke(context.getContext(), measure, beat, 0, 0);
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    protected GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    protected int getSelection() {
        if (this.duration4.getSelection()) {
            return 4;
        }
        if (this.duration8.getSelection()) {
            return 8;
        }
        if (this.duration16.getSelection()) {
            return 16;
        }
        if (this.duration32.getSelection()) {
            return 32;
        }
        if (this.duration64.getSelection()) {
            return 64;
        }
        return 0;
    }

    public void changeStroke(TGContext context, TGMeasure measure, TGBeat beat, int direction, int value) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.beat.general.change-stroke");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute("strokeDirection", (Object)direction);
        tgActionProcessor.setAttribute("strokeValue", (Object)value);
        tgActionProcessor.process();
    }
}

