/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.settings.items;

import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.dialog.settings.TGSettingsEditor;
import org.herac.tuxguitar.app.view.dialog.settings.items.Option;
import org.herac.tuxguitar.player.base.MidiOutputPort;
import org.herac.tuxguitar.player.base.MidiSequencer;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

public class SoundOption
extends Option {
    protected boolean initialized = false;
    protected String msCurrentKey;
    protected List<MidiSequencer> msList;
    protected Combo msCombo;
    protected String mpCurrentKey;
    protected List<MidiOutputPort> mpList;
    protected Combo mpCombo;

    public SoundOption(TGSettingsEditor configEditor, ToolBar toolBar, Composite parent) {
        super(configEditor, toolBar, parent, TuxGuitar.getProperty("settings.config.sound"));
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.sound"));
        this.getToolItem().setImage(TuxGuitar.getInstance().getIconManager().getOptionSound());
        this.getToolItem().addSelectionListener((SelectionListener)this);
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("midi.sequencer"));
        Composite msComposite = new Composite(this.getComposite(), 0);
        msComposite.setLayout((Layout)new GridLayout());
        msComposite.setLayoutData((Object)this.getTabbedData());
        this.msCombo = new Combo(msComposite, 12);
        this.msCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("midi.port"));
        Composite mpComposite = new Composite(this.getComposite(), 0);
        mpComposite.setLayout((Layout)new GridLayout());
        mpComposite.setLayoutData((Object)this.getTabbedData());
        this.mpCombo = new Combo(mpComposite, 12);
        this.mpCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.loadConfig();
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                SoundOption.this.mpList = TuxGuitar.getInstance().getPlayer().listOutputPorts();
                SoundOption.this.msList = TuxGuitar.getInstance().getPlayer().listSequencers();
                SoundOption.this.mpCurrentKey = SoundOption.this.getConfig().getStringValue("midi.port");
                SoundOption.this.msCurrentKey = SoundOption.this.getConfig().getStringValue("midi.sequencer");
                MidiSequencer sequencer = TuxGuitar.getInstance().getPlayer().getSequencer();
                MidiOutputPort outputPort = TuxGuitar.getInstance().getPlayer().getOutputPort();
                final String msLoaded = sequencer != null ? sequencer.getKey() : null;
                final String mpLoaded = outputPort != null ? outputPort.getKey() : null;
                TGSynchronizer.getInstance((TGContext)SoundOption.this.getViewContext().getContext()).executeLater(new Runnable(){

                    public void run() {
                        if (!SoundOption.this.isDisposed()) {
                            String loadedSequencer = msLoaded;
                            for (int i = 0; i < SoundOption.this.msList.size(); ++i) {
                                MidiSequencer sequencer = SoundOption.this.msList.get(i);
                                SoundOption.this.msCombo.add(sequencer.getName());
                                if (SoundOption.this.msCurrentKey != null && SoundOption.this.msCurrentKey.equals(sequencer.getKey())) {
                                    SoundOption.this.msCombo.select(i);
                                    loadedSequencer = null;
                                    continue;
                                }
                                if (loadedSequencer == null || !loadedSequencer.equals(sequencer.getKey())) continue;
                                SoundOption.this.msCombo.select(i);
                            }
                            if (SoundOption.this.msCombo.getSelectionIndex() < 0 && SoundOption.this.msCombo.getItemCount() > 0) {
                                SoundOption.this.msCombo.select(0);
                            }
                            String loadedPort = mpLoaded;
                            for (int i = 0; i < SoundOption.this.mpList.size(); ++i) {
                                MidiOutputPort port = SoundOption.this.mpList.get(i);
                                SoundOption.this.mpCombo.add(port.getName());
                                if (SoundOption.this.mpCurrentKey != null && SoundOption.this.mpCurrentKey.equals(port.getKey())) {
                                    SoundOption.this.mpCombo.select(i);
                                    loadedPort = null;
                                    continue;
                                }
                                if (loadedPort == null || !loadedPort.equals(port.getKey())) continue;
                                SoundOption.this.mpCombo.select(i);
                            }
                            if (SoundOption.this.mpCombo.getSelectionIndex() < 0 && SoundOption.this.mpCombo.getItemCount() > 0) {
                                SoundOption.this.mpCombo.select(0);
                            }
                            SoundOption.this.initialized = true;
                            SoundOption.this.pack();
                        }
                    }
                });
            }
        }).start();
    }

    public void updateConfig() {
        if (this.initialized) {
            int mpIndex;
            int msIndex = this.msCombo.getSelectionIndex();
            if (msIndex >= 0 && msIndex < this.msList.size()) {
                this.getConfig().setValue("midi.sequencer", this.msList.get(msIndex).getKey());
            }
            if ((mpIndex = this.mpCombo.getSelectionIndex()) >= 0 && mpIndex < this.mpList.size()) {
                MidiOutputPort midiPort = this.mpList.get(mpIndex);
                this.getConfig().setValue("midi.port", midiPort.getKey());
            }
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setValue("midi.port", this.getDefaults().getValue("midi.port"));
            this.getConfig().setValue("midi.sequencer", this.getDefaults().getValue("midi.sequencer"));
        }
    }
}

