/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.settings.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.dialog.settings.TGSettingsEditor;
import org.herac.tuxguitar.app.view.dialog.settings.items.Option;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageOption
extends Option {
    protected boolean initialized = false;
    protected Table table;
    protected TableColumn column;

    public LanguageOption(TGSettingsEditor configEditor, ToolBar toolBar, Composite parent) {
        super(configEditor, toolBar, parent, TuxGuitar.getProperty("settings.config.language"), 4, 4);
    }

    @Override
    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.language"));
        this.getToolItem().setImage(TuxGuitar.getInstance().getIconManager().getOptionLanguage());
        this.getToolItem().addSelectionListener((SelectionListener)this);
        this.showLabel(this.getComposite(), 4, 128, true, false, 16576, 1, 0, TuxGuitar.getProperty("settings.config.language.choose"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)this.getTabbedData(4, 4));
        this.table = new Table(composite, 68356);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.column = new TableColumn(this.table, 16384);
        this.column.setText(TuxGuitar.getProperty("settings.config.language.choose"));
        this.column.pack();
        this.loadConfig();
    }

    protected void loadTableItem(String text, String data, boolean selected) {
        TableItem item = new TableItem(this.table, 0);
        item.setText(text);
        item.setData((Object)data);
        if (selected) {
            this.table.setSelection(item);
        }
    }

    protected List<LanguageItem> getLanguageItems(String[] languages) {
        ArrayList<LanguageItem> list = new ArrayList<LanguageItem>();
        if (languages != null) {
            for (int i = 0; i < languages.length; ++i) {
                list.add(new LanguageItem(languages[i], TuxGuitar.getProperty("locale." + languages[i])));
            }
            Collections.sort(list, new Comparator<LanguageItem>(){

                @Override
                public int compare(LanguageItem l1, LanguageItem l2) {
                    if (l1 != null && l2 != null) {
                        return l1.getValue().compareTo(l2.getValue());
                    }
                    return 0;
                }
            });
        }
        return list;
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                final String language = LanguageOption.this.getConfig().getStringValue("language");
                final List<LanguageItem> languages = LanguageOption.this.getLanguageItems(TuxGuitar.getInstance().getLanguageManager().getLanguages());
                TGSynchronizer.getInstance((TGContext)LanguageOption.this.getViewContext().getContext()).executeLater(new Runnable(){

                    public void run() {
                        if (!LanguageOption.this.isDisposed()) {
                            LanguageOption.this.loadTableItem(TuxGuitar.getProperty("locale.default"), new String(), true);
                            for (int i = 0; i < languages.size(); ++i) {
                                LanguageItem item = (LanguageItem)languages.get(i);
                                LanguageOption.this.loadTableItem(item.getValue(), item.getKey(), language != null && item.getKey().equals(language));
                            }
                            LanguageOption.this.initialized = true;
                            LanguageOption.this.column.pack();
                            LanguageOption.this.pack();
                        }
                    }
                });
            }
        }).start();
    }

    @Override
    public void updateConfig() {
        if (this.initialized) {
            int index;
            String language = null;
            if (this.table != null && !this.table.isDisposed() && (index = this.table.getSelectionIndex()) >= 0 && index < this.table.getItemCount()) {
                language = (String)this.table.getItem(index).getData();
            }
            this.getConfig().setValue("language", language);
        }
    }

    @Override
    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setValue("language", this.getDefaults().getValue("language"));
        }
    }

    @Override
    public Point computeSize() {
        return this.computeSize(-1, 0);
    }

    private class LanguageItem {
        private String key;
        private String value;

        public LanguageItem(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

