/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.printer;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.printer.PrintStyles;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrintStylesHandler;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.song.models.TGSong;

public class TGPrintStylesDialog {
    public static final String ATTRIBUTE_HANDLER = TGPrintStylesHandler.class.getName();

    public void show(TGViewContext context) {
        TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final TGPrintStylesHandler handler = (TGPrintStylesHandler)context.getAttribute(ATTRIBUTE_HANDLER);
        Shell parent = (Shell)context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("options"));
        Group track = new Group((Composite)dialog, 16);
        track.setLayout((Layout)new GridLayout(2, false));
        track.setLayoutData((Object)TGPrintStylesDialog.getGroupData());
        track.setText(TuxGuitar.getProperty("track"));
        Label trackLabel = new Label((Composite)track, 0);
        trackLabel.setText(TuxGuitar.getProperty("track"));
        final Combo tracks = new Combo((Composite)track, 12);
        tracks.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int number = 1; number <= song.countTracks(); ++number) {
            tracks.add(TuxGuitar.getInstance().getSongManager().getTrack(song, number).getName());
        }
        tracks.select(TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack().getNumber() - 1);
        Group range = new Group((Composite)dialog, 16);
        range.setLayout((Layout)new GridLayout(2, false));
        range.setLayoutData((Object)TGPrintStylesDialog.getGroupData());
        range.setText(TuxGuitar.getProperty("print.range"));
        boolean minSelection = true;
        final int maxSelection = song.countMeasureHeaders();
        Label fromLabel = new Label((Composite)range, 0);
        fromLabel.setText(TuxGuitar.getProperty("edit.from"));
        final Spinner fromSpinner = new Spinner((Composite)range, 2048);
        fromSpinner.setLayoutData((Object)TGPrintStylesDialog.getSpinnerData());
        fromSpinner.setMaximum(maxSelection);
        fromSpinner.setMinimum(1);
        fromSpinner.setSelection(1);
        Label toLabel = new Label((Composite)range, 0);
        toLabel.setText(TuxGuitar.getProperty("edit.to"));
        final Spinner toSpinner = new Spinner((Composite)range, 2048);
        toSpinner.setLayoutData((Object)TGPrintStylesDialog.getSpinnerData());
        toSpinner.setMinimum(1);
        toSpinner.setMaximum(maxSelection);
        toSpinner.setSelection(maxSelection);
        fromSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fromSelection = fromSpinner.getSelection();
                int toSelection = toSpinner.getSelection();
                if (fromSelection < 1) {
                    fromSpinner.setSelection(1);
                } else if (fromSelection > toSelection) {
                    fromSpinner.setSelection(toSelection);
                }
            }
        });
        toSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fromSelection;
                int toSelection = toSpinner.getSelection();
                if (toSelection < (fromSelection = fromSpinner.getSelection())) {
                    toSpinner.setSelection(fromSelection);
                } else if (toSelection > maxSelection) {
                    toSpinner.setSelection(maxSelection);
                }
            }
        });
        Group options = new Group((Composite)dialog, 16);
        options.setLayout((Layout)new GridLayout());
        options.setLayoutData((Object)TGPrintStylesDialog.getGroupData());
        options.setText(TuxGuitar.getProperty("options"));
        final Button tablatureEnabled = new Button((Composite)options, 32);
        tablatureEnabled.setText(TuxGuitar.getProperty("export.tablature-enabled"));
        tablatureEnabled.setSelection(true);
        final Button scoreEnabled = new Button((Composite)options, 32);
        scoreEnabled.setText(TuxGuitar.getProperty("export.score-enabled"));
        scoreEnabled.setSelection(true);
        final Button chordNameEnabled = new Button((Composite)options, 32);
        chordNameEnabled.setText(TuxGuitar.getProperty("export.chord-name-enabled"));
        chordNameEnabled.setSelection(true);
        final Button chordDiagramEnabled = new Button((Composite)options, 32);
        chordDiagramEnabled.setText(TuxGuitar.getProperty("export.chord-diagram-enabled"));
        chordDiagramEnabled.setSelection(true);
        final Button blackAndWhite = new Button((Composite)options, 32);
        blackAndWhite.setText(TuxGuitar.getProperty("export.black-and-white"));
        blackAndWhite.setSelection(true);
        tablatureEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (!tablatureEnabled.getSelection()) {
                    scoreEnabled.setSelection(true);
                }
            }
        });
        scoreEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (!scoreEnabled.getSelection()) {
                    tablatureEnabled.setSelection(true);
                }
            }
        });
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)TGPrintStylesDialog.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int style = 0;
                style |= scoreEnabled.getSelection() ? 4 : 0;
                style |= tablatureEnabled.getSelection() ? 8 : 0;
                style |= chordNameEnabled.getSelection() ? 16 : 0;
                style |= chordDiagramEnabled.getSelection() ? 32 : 0;
                int n = blackAndWhite.getSelection() ? 64 : 0;
                PrintStyles printStyles = new PrintStyles();
                printStyles.setTrackNumber(tracks.getSelectionIndex() + 1);
                printStyles.setFromMeasure(fromSpinner.getSelection());
                printStyles.setToMeasure(toSpinner.getSelection());
                printStyles.setStyle(style |= n);
                dialog.dispose();
                handler.updatePrintStyles(printStyles);
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)TGPrintStylesDialog.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    private static GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private static GridData getSpinnerData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 60;
        return data;
    }

    private static GridData getGroupData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 300;
        return data;
    }
}

