/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.plugin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.impl.view.TGOpenViewAction;
import org.herac.tuxguitar.app.system.plugins.TGPluginSettingsManager;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.plugin.TGPluginInfoDialog;
import org.herac.tuxguitar.app.view.dialog.plugin.TGPluginInfoDialogController;
import org.herac.tuxguitar.app.view.dialog.plugin.TGPluginSettingsDialogController;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.plugin.TGPlugin;
import org.herac.tuxguitar.util.plugin.TGPluginInfo;
import org.herac.tuxguitar.util.plugin.TGPluginManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGPluginListDialog {
    private static final int TABLE_WIDTH = 400;
    private static final int TABLE_HEIGHT = 300;

    public void show(final TGViewContext context) {
        Shell parent = (Shell)context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        dialog.setText(TuxGuitar.getProperty("plugins"));
        final Table table = new Table((Composite)dialog, 68388);
        table.setLayoutData((Object)new GridData(400, 300));
        table.setHeaderVisible(true);
        TableColumn columnEnabled = new TableColumn(table, 16384);
        TableColumn columnPlugin = new TableColumn(table, 16384);
        columnEnabled.setText(TuxGuitar.getProperty("plugin.column.enabled"));
        columnPlugin.setText(TuxGuitar.getProperty("plugin.column.name"));
        columnEnabled.setWidth(100);
        columnPlugin.setWidth(300);
        for (String moduleId : this.getModuleIds()) {
            TGPluginInfo pluginInfo = new TGPluginInfo(context.getContext(), moduleId);
            String pluginName = pluginInfo.getName();
            if (pluginName == null) {
                pluginName = moduleId;
            }
            TableItem item = new TableItem(table, 0);
            item.setData((Object)moduleId);
            item.setText(1, pluginName != null ? pluginName : "Undefined Plugin");
            item.setChecked(TuxGuitar.getInstance().getPluginManager().isEnabled(moduleId));
        }
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)new GridData(131072, 4, true, true));
        final Button buttonSetup = new Button(buttons, 8);
        buttonSetup.setText(TuxGuitar.getProperty("configure"));
        buttonSetup.setLayoutData((Object)this.getButtonData());
        buttonSetup.setEnabled(false);
        buttonSetup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String moduleId;
                TableItem item = table.getItem(table.getSelectionIndex());
                if (item.getData() instanceof String && TGPluginListDialog.this.isConfigurable(moduleId = (String)item.getData())) {
                    TGPluginListDialog.this.configure(context.getContext(), dialog, moduleId);
                }
            }
        });
        final Button buttonInfo = new Button(buttons, 8);
        buttonInfo.setText(TuxGuitar.getProperty("info"));
        buttonInfo.setLayoutData((Object)this.getButtonData());
        buttonInfo.setEnabled(false);
        buttonInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableItem item = table.getItem(table.getSelectionIndex());
                if (item.getData() instanceof String) {
                    TGPluginListDialog.this.showInfo(context.getContext(), dialog, (String)item.getData());
                }
            }
        });
        Button buttonClose = new Button(buttons, 8);
        buttonClose.setText(TuxGuitar.getProperty("close"));
        buttonClose.setLayoutData((Object)this.getButtonData());
        buttonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                buttonInfo.setEnabled(false);
                buttonSetup.setEnabled(false);
                if (event.item instanceof TableItem && event.item.getData() instanceof String) {
                    TableItem item = (TableItem)event.item;
                    if (event.detail == 32) {
                        dialog.setCursor(dialog.getDisplay().getSystemCursor(1));
                        TGPluginManager.getInstance((TGContext)context.getContext()).updatePluginStatus((String)item.getData(), item.getChecked());
                        table.setSelection(item);
                        dialog.setCursor(dialog.getDisplay().getSystemCursor(0));
                    }
                    buttonInfo.setEnabled(true);
                    buttonSetup.setEnabled(TGPluginListDialog.this.isConfigurable((String)item.getData()));
                }
            }
        });
        dialog.setDefaultButton(buttonInfo);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private List<String> getModuleIds() {
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (TGPlugin plugin : TuxGuitar.getInstance().getPluginManager().getPlugins()) {
            if (moduleIds.contains(plugin.getModuleId())) continue;
            moduleIds.add(plugin.getModuleId());
        }
        return moduleIds;
    }

    private boolean isConfigurable(String moduleId) {
        return TGPluginSettingsManager.getInstance().containsPluginSettingsHandler(moduleId);
    }

    public void showInfo(TGContext context, Shell parent, String moduleId) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.gui.open-view");
        tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGPluginInfoDialogController());
        tgActionProcessor.setAttribute("parent", (Object)parent);
        tgActionProcessor.setAttribute(TGPluginInfoDialog.ATTRIBUTE_MODULE_ID, (Object)moduleId);
        tgActionProcessor.process();
    }

    public void configure(TGContext context, Shell parent, String moduleId) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.gui.open-view");
        tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGPluginSettingsDialogController());
        tgActionProcessor.setAttribute("parent", (Object)parent);
        tgActionProcessor.setAttribute(TGPluginSettingsDialogController.ATTRIBUTE_MODULE_ID, (Object)moduleId);
        tgActionProcessor.process();
    }
}

