/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.lyric;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.system.keybindings.KeyBinding;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingAction;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.dialog.lyric.TGLyricModifyListener;
import org.herac.tuxguitar.app.view.util.TGProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGAbstractContext;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGLyricEditor
implements TGEventListener {
    public static final String ATTRIBUTE_BYPASS_EVENTS_FROM = "bypass-events-from";
    private static final int EDITOR_WIDTH = 450;
    private static final int EDITOR_HEIGHT = 200;
    protected static final KeyBindingAction[] KB_ACTIONS = new KeyBindingAction[]{new KeyBindingAction("action.edit.undo", new KeyBinding(122, 262144)), new KeyBindingAction("action.edit.redo", new KeyBinding(121, 262144))};
    private TGContext context;
    private TGTrack track;
    private Shell dialog;
    private TGLyricModifyListener listener;
    private Button previous;
    private Button next;
    private Label label;
    private Label fromLabel;
    private Spinner from;
    private Text text;
    private int caretPosition;
    private boolean updated;
    private int lastTrack;
    private int lastMeasuseCount;
    private String lastTrackName;
    private TGProcess loadPropertiesProcess;
    private TGProcess loadIconsProcess;
    private TGProcess updateItemsProcess;

    public TGLyricEditor(TGContext context) {
        this.context = context;
        this.listener = new TGLyricModifyListener(this);
        this.createSyncProcesses();
    }

    public TGLyric createLyrics() {
        if (!this.isDisposed()) {
            TGLyric tgLyric = TGDocumentManager.getInstance((TGContext)this.context).getSongManager().getFactory().newLyric();
            tgLyric.setFrom(this.from.getSelection());
            tgLyric.setLyrics(this.text.getText());
            return tgLyric;
        }
        return null;
    }

    public void show() {
        this.dialog = DialogUtils.newDialog(TuxGuitar.getInstance().getShell(), 2160);
        this.dialog.setLayout((Layout)this.getDialogLayout());
        this.dialog.setSize(450, 200);
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGLyricEditor.this.onDispose();
            }
        });
        this.track = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
        this.loadComposites();
        this.loadProperties();
        this.loadIcons();
        this.updateItems();
        this.addListeners();
        DialogUtils.openDialog(this.dialog, 8);
    }

    public void addListeners() {
        TuxGuitar.getInstance().getIconManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getIconManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    public void onDispose() {
        this.track = null;
        this.label = null;
        this.text = null;
        this.dialog = null;
        this.removeListeners();
    }

    private GridLayout getDialogLayout() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        return layout;
    }

    private void loadComposites() {
        this.loadToolBar((Composite)this.dialog);
        this.loadLyricText((Composite)this.dialog);
    }

    private void loadToolBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(5, false));
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.previous = new Button(composite, 16388);
        this.next = new Button(composite, 131076);
        this.label = new Label(composite, 0);
        this.label.setText(this.track.getName());
        this.label.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fromLabel = new Label(composite, 0);
        this.fromLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        this.from = new Spinner(composite, 2048);
        this.from.setLayoutData((Object)new GridData(-1, -1));
        this.from.setMinimum(1);
        this.from.setMaximum(this.track.countMeasures());
        this.from.setSelection(this.track.getLyrics().getFrom());
        this.from.setEnabled(this.track.countMeasures() > 1);
        this.from.addModifyListener((ModifyListener)this.listener);
        this.previous.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.track.go-previous"));
        this.next.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.track.go-next"));
    }

    private void loadLyricText(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text = new Text(composite, 2626);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.setFocus();
        this.text.setText(this.track.getLyrics().getLyrics());
        this.text.addModifyListener((ModifyListener)this.listener);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                for (int i = 0; i < KB_ACTIONS.length; ++i) {
                    if (event.keyCode != KB_ACTIONS[i].getKeyBinding().getKey() || event.stateMask != KB_ACTIONS[i].getKeyBinding().getMask()) continue;
                    new TGActionProcessorListener(TGLyricEditor.this.context, KB_ACTIONS[i].getAction()).processEvent((TypedEvent)event);
                    return;
                }
            }
        });
    }

    public void updateItems() {
        if (!this.isDisposed()) {
            boolean enabled = !TuxGuitar.getInstance().getPlayer().isRunning();
            boolean doLayout = false;
            this.listener.setEnabled(false);
            if (this.updated) {
                this.lastTrack = 0;
                this.lastTrackName = null;
                this.lastMeasuseCount = 0;
            }
            this.track = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
            if (this.isTrackNameChanged()) {
                doLayout = true;
                this.label.setText(this.track.getName());
            }
            if (this.isMeasureCountChanged()) {
                doLayout = true;
                this.from.setMaximum(this.track.countMeasures());
            }
            if (this.isTrackChanged() || this.isTrackLyricChanged()) {
                doLayout = true;
                this.from.setSelection(this.track.getLyrics().getFrom());
                this.text.setText(this.track.getLyrics().getLyrics());
                this.text.setSelection(this.caretPosition >= 0 ? this.caretPosition : this.text.getCharCount());
            }
            this.from.setEnabled(enabled && this.track.countMeasures() > 1);
            this.text.setEnabled(enabled);
            this.setCaretPosition(-1);
            this.listener.setEnabled(enabled);
            this.updated = false;
            if (doLayout) {
                this.dialog.layout(true, true);
            }
        }
    }

    private boolean isTrackChanged() {
        int current = this.track.getNumber();
        if (current != this.lastTrack) {
            this.lastTrack = current;
            return true;
        }
        return false;
    }

    private boolean isTrackLyricChanged() {
        if (this.track.getLyrics().getFrom() != this.from.getSelection()) {
            return true;
        }
        return !this.track.getLyrics().getLyrics().equals(this.text.getText());
    }

    private boolean isTrackNameChanged() {
        String current = this.track.getName();
        if (this.lastTrackName == null || !current.equals(this.lastTrackName)) {
            this.lastTrackName = current;
            return true;
        }
        return false;
    }

    private boolean isMeasureCountChanged() {
        int current = this.track.countMeasures();
        if (current != this.lastMeasuseCount) {
            this.lastMeasuseCount = current;
            return true;
        }
        return false;
    }

    public void update() {
        this.updated = true;
    }

    public void setCaretPosition(int caretPosition) {
        this.caretPosition = caretPosition;
    }

    public TGTrack getTrack() {
        return this.track;
    }

    public TGContext getContext() {
        return this.context;
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("lyric.editor"));
            this.fromLabel.setText(TuxGuitar.getProperty("edit.from"));
            this.dialog.layout(true, true);
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        }
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public boolean isByPassEvent(TGEvent event) {
        Object owner;
        TGAbstractContext context = (TGAbstractContext)event.getAttribute("sourceContext");
        return context != null && (owner = context.getAttribute(ATTRIBUTE_BYPASS_EVENTS_FROM)) != null && owner.equals(this);
    }

    public void createSyncProcesses() {
        this.loadPropertiesProcess = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                TGLyricEditor.this.loadProperties();
            }
        });
        this.loadIconsProcess = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                TGLyricEditor.this.loadIcons();
            }
        });
        this.updateItemsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGLyricEditor.this.updateItems();
            }
        });
    }

    public void processUpdateEvent(TGEvent event) {
        if (!this.isByPassEvent(event)) {
            int type = (Integer)event.getAttribute("updateMode");
            if (type == 1) {
                this.updateItemsProcess.process();
            } else if (type == 3 || type == 4) {
                this.update();
            }
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-icon".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        } else if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }

    public static TGLyricEditor getInstance(TGContext context) {
        return (TGLyricEditor)TGSingletonUtil.getInstance((TGContext)context, (String)TGLyricEditor.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGLyricEditor>(){

            public TGLyricEditor createInstance(TGContext context) {
                return new TGLyricEditor(context);
            }
        });
    }
}

