/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.info;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGSongInfoDialog {
    private static final int GROUP_WIDTH = 450;
    private static final int GROUP_HEIGHT = -1;

    public void show(final TGViewContext context) {
        Shell parent = (Shell)context.getAttribute("parent");
        final TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        dialog.setText(TuxGuitar.getProperty("composition.properties"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)this.makeGroupLayout(5));
        group.setLayoutData((Object)new GridData(450, -1));
        group.setText(TuxGuitar.getProperty("composition.properties"));
        Label nameLabel = new Label((Composite)group, 0);
        nameLabel.setLayoutData((Object)this.makeLabelData());
        nameLabel.setText(TuxGuitar.getProperty("composition.name") + ":");
        final Text nameText = new Text((Composite)group, 2048);
        nameText.setLayoutData((Object)this.makeTextData());
        nameText.setText(song.getName());
        Label artistLabel = new Label((Composite)group, 0);
        artistLabel.setLayoutData((Object)this.makeLabelData());
        artistLabel.setText(TuxGuitar.getProperty("composition.artist") + ":");
        final Text artistText = new Text((Composite)group, 2048);
        artistText.setLayoutData((Object)this.makeTextData());
        artistText.setText(song.getArtist());
        Label albumLabel = new Label((Composite)group, 0);
        albumLabel.setLayoutData((Object)this.makeLabelData());
        albumLabel.setText(TuxGuitar.getProperty("composition.album") + ":");
        final Text albumText = new Text((Composite)group, 2048);
        albumText.setLayoutData((Object)this.makeTextData());
        albumText.setText(song.getAlbum());
        Label authorLabel = new Label((Composite)group, 0);
        authorLabel.setLayoutData((Object)this.makeLabelData());
        authorLabel.setText(TuxGuitar.getProperty("composition.author") + ":");
        final Text authorText = new Text((Composite)group, 2048);
        authorText.setLayoutData((Object)this.makeTextData());
        authorText.setText(song.getAuthor());
        Label dateLabel = new Label((Composite)group, 0);
        dateLabel.setLayoutData((Object)this.makeLabelData());
        dateLabel.setText(TuxGuitar.getProperty("composition.date") + ":");
        final Text dateText = new Text((Composite)group, 2048);
        dateText.setLayoutData((Object)this.makeTextData());
        dateText.setText(song.getDate());
        Label copyrightLabel = new Label((Composite)group, 0);
        copyrightLabel.setLayoutData((Object)this.makeLabelData());
        copyrightLabel.setText(TuxGuitar.getProperty("composition.copyright") + ":");
        final Text copyrightText = new Text((Composite)group, 2048);
        copyrightText.setLayoutData((Object)this.makeTextData());
        copyrightText.setText(song.getCopyright());
        Label writerLabel = new Label((Composite)group, 0);
        writerLabel.setLayoutData((Object)this.makeLabelData());
        writerLabel.setText(TuxGuitar.getProperty("composition.writer") + ":");
        final Text writerText = new Text((Composite)group, 2048);
        writerText.setLayoutData((Object)this.makeTextData());
        writerText.setText(song.getWriter());
        Label transcriberLabel = new Label((Composite)group, 0);
        transcriberLabel.setLayoutData((Object)this.makeLabelData());
        transcriberLabel.setText(TuxGuitar.getProperty("composition.transcriber") + ":");
        final Text transcriberText = new Text((Composite)group, 2048);
        transcriberText.setLayoutData((Object)this.makeTextData());
        transcriberText.setText(song.getTranscriber());
        Label commentsLabel = new Label((Composite)group, 0);
        commentsLabel.setLayoutData((Object)this.makeLabelData());
        commentsLabel.setText(TuxGuitar.getProperty("composition.comments") + ":");
        final Text commentsText = new Text((Composite)group, 2626);
        commentsText.setLayoutData((Object)this.makeTextAreaData());
        commentsText.setText(song.getComments());
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String name = nameText.getText();
                String artist = artistText.getText();
                String album = albumText.getText();
                String author = authorText.getText();
                String date = dateText.getText();
                String copyright = copyrightText.getText();
                String writer = writerText.getText();
                String transcriber = transcriberText.getText();
                String comments = commentsText.getText();
                TGSongInfoDialog.this.updateSongInfo(context.getContext(), song, name, artist, album, author, date, copyright, writer, transcriber, comments);
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridLayout makeGroupLayout(int spacing) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = spacing;
        layout.marginBottom = spacing;
        layout.marginLeft = spacing;
        layout.marginRight = spacing;
        layout.verticalSpacing = spacing;
        layout.horizontalSpacing = spacing;
        return layout;
    }

    private GridData makeTextAreaData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 100;
        return data;
    }

    private GridData makeTextData() {
        return new GridData(4, 4, true, true);
    }

    private GridData makeLabelData() {
        return new GridData(131072, 0x1000000, false, true);
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    public void updateSongInfo(TGContext context, TGSong song, String name, String artist, String album, String author, String date, String copyright, String writer, String transcriber, String comments) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.composition.change-info");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
        tgActionProcessor.setAttribute("name", (Object)name);
        tgActionProcessor.setAttribute("artist", (Object)artist);
        tgActionProcessor.setAttribute("album", (Object)album);
        tgActionProcessor.setAttribute("author", (Object)author);
        tgActionProcessor.setAttribute("date", (Object)date);
        tgActionProcessor.setAttribute("copyright", (Object)copyright);
        tgActionProcessor.setAttribute("writer", (Object)writer);
        tgActionProcessor.setAttribute("transcriber", (Object)transcriber);
        tgActionProcessor.setAttribute("comments", (Object)comments);
        tgActionProcessor.processOnNewThread();
    }
}

