/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.clef;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGClefDialog {
    public void show(final TGViewContext context) {
        Shell parent = (Shell)context.getAttribute("parent");
        final TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("composition.clef"));
        Group clef = new Group((Composite)dialog, 16);
        clef.setLayout((Layout)new GridLayout(2, false));
        clef.setLayoutData((Object)new GridData(4, 4, true, true));
        clef.setText(TuxGuitar.getProperty("composition.clef"));
        Label numeratorLabel = new Label((Composite)clef, 0);
        numeratorLabel.setText(TuxGuitar.getProperty("composition.clef") + ":");
        final Combo clefs = new Combo((Composite)clef, 12);
        clefs.add(TuxGuitar.getProperty("composition.clef.treble"));
        clefs.add(TuxGuitar.getProperty("composition.clef.bass"));
        clefs.add(TuxGuitar.getProperty("composition.clef.tenor"));
        clefs.add(TuxGuitar.getProperty("composition.clef.alto"));
        clefs.select(measure.getClef() - 1);
        clefs.setLayoutData((Object)this.getComboData());
        Group check = new Group((Composite)dialog, 16);
        check.setLayout((Layout)new GridLayout());
        check.setLayoutData((Object)new GridData(4, 4, true, true));
        check.setText(TuxGuitar.getProperty("options"));
        final Button toEnd = new Button((Composite)check, 32);
        toEnd.setText(TuxGuitar.getProperty("composition.clef.to-the-end"));
        toEnd.setSelection(true);
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGClefDialog.this.changeClef(context.getContext(), song, track, measure, clefs.getSelectionIndex() + 1, toEnd.getSelection());
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getComboData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 150;
        return data;
    }

    protected GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    public void changeClef(TGContext context, TGSong song, TGTrack track, TGMeasure measure, Integer value, Boolean applyToEnd) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.composition.change-clef");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute("clef", (Object)value);
        tgActionProcessor.setAttribute("applyToEnd", (Object)applyToEnd);
        tgActionProcessor.processOnNewThread();
    }
}

