/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.chord;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordSettings;

public class TGChordSettingsDialog {
    private boolean updated;
    private Shell dialog;
    private Button emptyStringChords = null;
    private Spinner chordsToDisplay = null;
    private Combo typeCombo = null;
    private Spinner minFret = null;
    private Spinner maxFret = null;

    public boolean open(Shell parent) {
        this.updated = false;
        this.dialog = DialogUtils.newDialog(parent, 67680);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("settings"));
        this.init();
        DialogUtils.openDialog(this.dialog, 11);
        return this.updated;
    }

    protected void init() {
        Group group = new Group((Composite)this.dialog, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("chord.settings.tip"));
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.initTypeCombo(composite);
        this.initChordsToDisplay(composite);
        this.initEmptyStringChords(composite);
        this.initFretSearch(composite);
        Composite buttons = new Composite((Composite)this.dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGChordSettingsDialog.this.dispose(true);
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGChordSettingsDialog.this.dispose(false);
            }
        });
        this.dialog.setDefaultButton(buttonOK);
    }

    private GridData getGridData(int minimumWidth, int minimumHeight) {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = minimumWidth;
        data.minimumHeight = minimumHeight;
        return data;
    }

    private GridData getGridData() {
        return this.getGridData(125, 0);
    }

    private GridData getButtonData() {
        return this.getGridData(80, 25);
    }

    private Spinner makeSpinner(Composite parent, String label, int value, int min, int max) {
        this.newLabel(parent, label);
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setMinimum(min);
        spinner.setMaximum(max);
        spinner.setSelection(value);
        spinner.setLayoutData((Object)this.getGridData());
        return spinner;
    }

    private Label newLabel(Composite parent, String text) {
        Label label = new Label(parent, 256);
        label.setText(text);
        return label;
    }

    private void initTypeCombo(Composite parent) {
        this.newLabel(parent, TuxGuitar.getProperty("chord.settings.type"));
        this.typeCombo = new Combo(parent, 12);
        this.typeCombo.setLayoutData((Object)this.getGridData());
        this.typeCombo.add(TuxGuitar.getProperty("chord.settings.type.most-common"));
        this.typeCombo.add(TuxGuitar.getProperty("chord.settings.type.inversions"));
        this.typeCombo.add(TuxGuitar.getProperty("chord.settings.type.close-voiced"));
        this.typeCombo.add(TuxGuitar.getProperty("chord.settings.type.open-voiced"));
        this.typeCombo.select(TGChordSettings.instance().getChordTypeIndex());
    }

    private void initChordsToDisplay(Composite parent) {
        this.chordsToDisplay = this.makeSpinner(parent, TuxGuitar.getProperty("chord.settings.chords-to-display"), TGChordSettings.instance().getChordsToDisplay(), 1, 100);
    }

    private void initEmptyStringChords(Composite parent) {
        this.emptyStringChords = new Button(parent, 32);
        this.emptyStringChords.setSelection(TGChordSettings.instance().isEmptyStringChords());
        this.emptyStringChords.setText(TuxGuitar.getProperty("chord.settings.open-chords"));
        this.emptyStringChords.setSize(100, 20);
        this.emptyStringChords.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
    }

    private void initFretSearch(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayout((Layout)new GridLayout(4, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        group.setText(TuxGuitar.getProperty("chord.settings.search-frets"));
        this.minFret = this.makeSpinner((Composite)group, TuxGuitar.getProperty("chord.settings.minimum-fret"), TGChordSettings.instance().getFindChordsMin(), 0, 15);
        this.maxFret = this.makeSpinner((Composite)group, TuxGuitar.getProperty("chord.settings.maximum-fret"), TGChordSettings.instance().getFindChordsMax(), 2, 25);
        this.minFret.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGChordSettingsDialog.this.checkMinimumFretValue();
            }
        });
        this.maxFret.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGChordSettingsDialog.this.checkMaximumFretValue();
            }
        });
    }

    protected void checkMinimumFretValue() {
        int minSelection;
        int maxSelection = this.maxFret.getSelection();
        if (maxSelection < (minSelection = this.minFret.getSelection())) {
            this.maxFret.setSelection(minSelection);
        }
    }

    protected void checkMaximumFretValue() {
        int minSelection;
        int maxSelection = this.maxFret.getSelection();
        if (maxSelection < (minSelection = this.minFret.getSelection())) {
            this.maxFret.setSelection(minSelection);
        }
    }

    private void update() {
        TGChordSettings.instance().setChordTypeIndex(this.typeCombo.getSelectionIndex());
        TGChordSettings.instance().setEmptyStringChords(this.emptyStringChords.getSelection());
        TGChordSettings.instance().setChordsToDisplay(this.chordsToDisplay.getSelection());
        TGChordSettings.instance().setFindChordsMax(this.maxFret.getSelection());
        TGChordSettings.instance().setFindChordsMin(this.minFret.getSelection());
    }

    protected void dispose(boolean updated) {
        this.updated = updated;
        if (this.updated) {
            this.update();
        }
        this.dialog.dispose();
    }
}

