/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.chord;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.TGMusicKeyUtils;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordCreatorListener;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordCreatorUtil;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordDatabase;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordDialog;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordSettingsDialog;
import org.herac.tuxguitar.app.view.util.TGCursorController;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGChordSelector
extends Composite {
    public static final String[][] KEY_NAMES = new String[][]{TGMusicKeyUtils.getSharpKeyNames("chord"), TGMusicKeyUtils.getFlatKeyNames("chord")};
    private TGChordDialog dialog;
    private TGCursorController cursorController;
    private int[] tuning;
    private org.eclipse.swt.widgets.List tonicList;
    private org.eclipse.swt.widgets.List chordList;
    private org.eclipse.swt.widgets.List alterationList;
    private Button sharpButton;
    private Button flatButton;
    private Combo bassCombo;
    private Button addCheck;
    private org.eclipse.swt.widgets.List plusMinusList;
    private org.eclipse.swt.widgets.List _5List;
    private org.eclipse.swt.widgets.List _9List;
    private org.eclipse.swt.widgets.List _11List;
    private boolean refresh;

    public TGChordSelector(TGChordDialog dialog, Composite parent, int style, int[] tuning) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.dialog = dialog;
        this.tuning = tuning;
        this.refresh = true;
        this.init();
    }

    public void init() {
        Composite tonicComposite = new Composite((Composite)this, 0);
        tonicComposite.setLayout((Layout)this.dialog.gridLayout(1, false, 0, 0));
        tonicComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tonicList = new org.eclipse.swt.widgets.List(tonicComposite, 2048);
        this.tonicList.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonsComposite = new Composite(tonicComposite, 0);
        buttonsComposite.setLayout((Layout)this.dialog.gridLayout(2, true, 0, 0));
        GridData buttonGd = new GridData(4, 128, true, false);
        buttonGd.heightHint = 28;
        buttonGd.widthHint = 28;
        this.sharpButton = new Button(buttonsComposite, 2);
        this.sharpButton.setLayoutData((Object)buttonGd);
        this.flatButton = new Button(buttonsComposite, 2);
        this.flatButton.setLayoutData((Object)buttonGd);
        this.sharpButton.setText("#");
        this.flatButton.setText("b");
        this.chordList = new org.eclipse.swt.widgets.List((Composite)this, 2048);
        this.chordList.setLayoutData((Object)new GridData(4, 4, true, true));
        Label separator = new Label(tonicComposite, 258);
        separator.setLayoutData((Object)new GridData(4, 1024, true, true));
        Button customizeButton = new Button(tonicComposite, 8);
        customizeButton.setLayoutData((Object)new GridData(4, 1024, true, false));
        customizeButton.setText(TuxGuitar.getProperty("settings"));
        customizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (new TGChordSettingsDialog().open(TGChordSelector.this.getShell())) {
                    TGSynchronizer.getInstance((TGContext)TGChordSelector.this.getDialog().getContext().getContext()).executeLater(new Runnable(){

                        public void run() throws TGException {
                            TGChordSelector.this.showChord();
                            TGChordSelector.this.getChordList().redraw();
                        }
                    });
                }
            }
        });
        this.initChordWidgets();
        this.insertTonicNames(true);
        for (int i = 0; i < TGChordDatabase.length(); ++i) {
            this.chordList.add(TGChordDatabase.get(i).getName());
        }
        this.chordList.setSelection(0);
        String[] alterationNames = this.getAlterationNames();
        for (int i = 0; i < alterationNames.length; ++i) {
            this.alterationList.add(alterationNames[i]);
        }
        this.alterationList.setSelection(0);
        String[] plusMinus = this.getPlusMinus("");
        for (int i = 0; i < plusMinus.length; ++i) {
            this.plusMinusList.add(plusMinus[i]);
        }
        this.plusMinusList.setSelection(0);
        String[] plus5Minus = this.getPlusMinus("/5");
        for (int i = 0; i < plus5Minus.length; ++i) {
            this._5List.add(plus5Minus[i]);
        }
        this._5List.setSelection(0);
        String[] plus9Minus = this.getPlusMinus("/9");
        for (int i = 0; i < plus9Minus.length; ++i) {
            this._9List.add(plus9Minus[i]);
        }
        this._9List.setSelection(0);
        String[] plus11Minus = this.getPlusMinus("/11");
        for (int i = 0; i < plus11Minus.length; ++i) {
            this._11List.add(plus11Minus[i]);
        }
        this._11List.setSelection(0);
        this.tonicList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TGChordSelector.this.getRefresh() && TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null) {
                    TGChordSelector.this.getBassCombo().select(TGChordSelector.this.getTonicList().getSelectionIndex());
                    TGChordSelector.this.showChord();
                }
            }
        });
        this.bassCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TGChordSelector.this.getRefresh() && TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null) {
                    TGChordSelector.this.showChord();
                }
            }
        });
        this.chordList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null) {
                    TGChordSelector.this.adjustWidgetAvailability();
                    if (TGChordSelector.this.getRefresh()) {
                        TGChordSelector.this.showChord();
                    }
                }
            }
        });
        this.alterationList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null) {
                    TGChordSelector.this.adjustWidgetAvailability();
                    if (TGChordSelector.this.getRefresh()) {
                        TGChordSelector.this.showChord();
                    }
                }
            }
        });
        this.addCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null) {
                    TGChordSelector.this.adjustWidgetAvailability();
                    if (TGChordSelector.this.getRefresh()) {
                        TGChordSelector.this.showChord();
                    }
                }
            }
        });
        this._5List.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null && TGChordSelector.this.getRefresh()) {
                    TGChordSelector.this.showChord();
                }
            }
        });
        this._9List.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null && TGChordSelector.this.getRefresh()) {
                    TGChordSelector.this.showChord();
                }
            }
        });
        this._11List.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null && TGChordSelector.this.getRefresh()) {
                    TGChordSelector.this.showChord();
                }
            }
        });
        this.plusMinusList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null && TGChordSelector.this.getRefresh()) {
                    TGChordSelector.this.showChord();
                }
            }
        });
        this.sharpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGChordSelector.this.insertTonicNames(true);
            }
        });
        this.flatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGChordSelector.this.insertTonicNames(false);
            }
        });
        this.adjustWidgetAvailability();
    }

    protected void initChordWidgets() {
        Composite alterationComposite = new Composite((Composite)this, 0);
        alterationComposite.setLayout((Layout)this.dialog.gridLayout(1, true, 0, 0));
        alterationComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite aboveComposite = new Composite(alterationComposite, 0);
        aboveComposite.setLayout((Layout)this.dialog.gridLayout(2, true, 0, 0));
        aboveComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite firstComposite = new Composite(aboveComposite, 0);
        firstComposite.setLayout((Layout)this.dialog.gridLayout(1, false, 0, 0));
        firstComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.alterationList = new org.eclipse.swt.widgets.List(firstComposite, 2048);
        this.alterationList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.plusMinusList = new org.eclipse.swt.widgets.List(firstComposite, 2048);
        this.plusMinusList.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite secondComposite = new Composite(aboveComposite, 0);
        secondComposite.setLayout((Layout)this.dialog.gridLayout(1, false, 0, 0));
        secondComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this._5List = new org.eclipse.swt.widgets.List(secondComposite, 2048);
        this._5List.setLayoutData((Object)new GridData(4, 4, true, true));
        this._9List = new org.eclipse.swt.widgets.List(secondComposite, 2048);
        this._9List.setLayoutData((Object)new GridData(4, 4, true, true));
        this._11List = new org.eclipse.swt.widgets.List(secondComposite, 2048);
        this._11List.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite bassComposite = new Composite(alterationComposite, 0);
        bassComposite.setLayout((Layout)this.dialog.gridLayout(1, true, 0, 0));
        bassComposite.setLayoutData((Object)new GridData(4, 1024, true, true));
        this.addCheck = new Button(bassComposite, 16416);
        this.addCheck.setText("add");
        this.addCheck.setLayoutData((Object)new GridData(4, 1024, true, true));
        Label separator = new Label(bassComposite, 258);
        separator.setLayoutData((Object)new GridData(4, 1024, true, true));
        Label bText = new Label(bassComposite, 16384);
        bText.setLayoutData((Object)new GridData(4, 1024, true, false));
        bText.setText(TuxGuitar.getProperty("chord.bass"));
        this.bassCombo = new Combo(bassComposite, 12);
        this.bassCombo.setLayoutData((Object)new GridData(4, 1024, true, false));
    }

    protected void insertTonicNames(boolean sharp) {
        int indexC;
        String[] names = KEY_NAMES[sharp ? 0 : 1];
        this.flatButton.setSelection(!sharp);
        this.sharpButton.setSelection(sharp);
        int indexL = this.tonicList.getSelectionIndex();
        if (indexL == -1) {
            indexL = 0;
        }
        if ((indexC = this.bassCombo.getSelectionIndex()) == -1) {
            indexC = 0;
        }
        this.tonicList.removeAll();
        this.bassCombo.removeAll();
        for (int i = 0; i < names.length; ++i) {
            this.tonicList.add(names[i]);
            this.bassCombo.add(names[i]);
        }
        this.tonicList.setSelection(indexL);
        this.bassCombo.select(indexC);
    }

    private String[] getPlusMinus(String text) {
        String[] names = new String[]{" ", text + "+", text + "-"};
        return names;
    }

    private String[] getAlterationNames() {
        String[] names = new String[]{" ", "9", "11", "13"};
        return names;
    }

    protected void showChord() {
        this.loadCursor(1);
        TGChordCreatorListener listener = new TGChordCreatorListener(){

            @Override
            public void notifyChords(final TGChordCreatorUtil instance, final List<TGChord> chords) {
                TGSynchronizer.getInstance((TGContext)TGChordSelector.this.getDialog().getContext().getContext()).executeLater(new Runnable(){

                    public void run() {
                        if (instance.isValidProcess() && !TGChordSelector.this.getDialog().isDisposed()) {
                            TGChordSelector.this.getDialog().getList().setChords(chords);
                            TGChordSelector.this.loadCursor(0);
                        }
                    }
                });
            }
        };
        TGChordCreatorUtil.getChords(listener, this.tuning, this.chordList.getSelectionIndex(), this.alterationList.getSelectionIndex(), this.plusMinusList.getSelectionIndex(), this.addCheck.getSelection(), this._5List.getSelectionIndex(), this._9List.getSelectionIndex(), this._11List.getSelectionIndex(), this.bassCombo.getSelectionIndex(), this.tonicList.getSelectionIndex(), this.sharpButton.getSelection());
    }

    protected void updateWidget(org.eclipse.swt.widgets.List widget, boolean enabled) {
        widget.setEnabled(enabled);
        if (!enabled) {
            widget.setSelection(0);
        }
    }

    protected void updateWidget(Button widget, boolean enabled) {
        widget.setEnabled(enabled);
        if (!enabled) {
            widget.setSelection(false);
        }
    }

    public void adjustWidgets(int tonic, int chordBasic, int alteration, int bass, int plusMinus, int addBoolean, int index5, int index9, int index11) {
        this.setRefresh(false);
        this.tonicList.setSelection(tonic);
        this.alterationList.setSelection(alteration);
        this.bassCombo.select(bass);
        this.plusMinusList.setSelection(plusMinus);
        this.addCheck.setSelection(addBoolean != 0);
        this._5List.setSelection(index5);
        this._9List.setSelection(index9);
        this._11List.setSelection(index11);
        this.chordList.setSelection(chordBasic);
        this.adjustWidgetAvailability();
        this.setRefresh(true);
        this.showChord();
    }

    protected void adjustWidgetAvailability() {
        String chordName = TGChordDatabase.get(this.getChordList().getSelectionIndex()).getName();
        if (chordName.equals("dim") || chordName.equals("dim7") || chordName.equals("aug") || chordName.equals("5")) {
            this.updateWidget(this.getAlterationList(), false);
            this.updateWidget(this.getAddCheck(), false);
            this.updateWidget(this.get_9List(), false);
            this.updateWidget(this.get_11List(), false);
            this.updateWidget(this.getPlusMinusList(), false);
            if (!chordName.equals("5")) {
                this.updateWidget(this.get_5List(), false);
            } else {
                this.updateWidget(this.get_5List(), true);
            }
        } else {
            this.updateWidget(this.getAlterationList(), true);
            this.updateWidget(this.get_5List(), true);
        }
        if (this.alterationList.isEnabled()) {
            int currentIndex = this.alterationList.getSelectionIndex();
            this.updateWidget(this.plusMinusList, currentIndex > 0);
            this.updateWidget(this.addCheck, currentIndex > 0);
            this.updateWidget(this._9List, currentIndex >= 2 && !this.addCheck.getSelection());
            this.updateWidget(this._11List, currentIndex >= 3 && !this.addCheck.getSelection());
        }
    }

    public void loadCursor(int cursorStyle) {
        if (!this.isDisposed()) {
            if (this.cursorController == null || !this.cursorController.isControlling((Control)this.getShell())) {
                this.cursorController = new TGCursorController(this.dialog.getContext().getContext(), (Control)this.getShell());
            }
            this.cursorController.loadCursor(cursorStyle);
        }
    }

    public boolean getRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public void setTuning(int[] tuning) {
        this.tuning = tuning;
    }

    public int[] getTuning() {
        return this.tuning;
    }

    protected TGChordDialog getDialog() {
        return this.dialog;
    }

    protected org.eclipse.swt.widgets.List getTonicList() {
        return this.tonicList;
    }

    protected org.eclipse.swt.widgets.List getChordList() {
        return this.chordList;
    }

    protected org.eclipse.swt.widgets.List getAlterationList() {
        return this.alterationList;
    }

    protected Button getSharpButton() {
        return this.sharpButton;
    }

    protected Button getFlatButton() {
        return this.flatButton;
    }

    protected Combo getBassCombo() {
        return this.bassCombo;
    }

    protected Button getAddCheck() {
        return this.addCheck;
    }

    protected org.eclipse.swt.widgets.List getPlusMinusList() {
        return this.plusMinusList;
    }

    protected org.eclipse.swt.widgets.List get_5List() {
        return this._5List;
    }

    protected org.eclipse.swt.widgets.List get_9List() {
        return this._9List;
    }

    protected org.eclipse.swt.widgets.List get_11List() {
        return this._11List;
    }
}

