/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.chord;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordDialog;
import org.herac.tuxguitar.song.models.TGChord;

public class TGChordCustomList
extends Composite {
    private TGChordDialog dialog;
    private List chords;

    public TGChordCustomList(TGChordDialog dialog, Composite parent, int style, int height) {
        super(parent, style);
        this.setLayout((Layout)dialog.gridLayout(1, false, 0, 0));
        this.setLayoutData(this.makeGridData(height));
        this.dialog = dialog;
        this.init();
    }

    public GridData makeGridData(int height) {
        GridData data = new GridData(4, 128, true, true);
        data.heightHint = height;
        return data;
    }

    public void init() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chords = new List(composite, 2816);
        this.chords.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chords.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TGChordCustomList.this.getDialog().getEditor() != null) {
                    TGChordCustomList.this.showChord(TGChordCustomList.this.getChords().getSelectionIndex());
                }
            }
        });
        Composite buttons = new Composite((Composite)this, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        Button add = new Button(buttons, 8);
        add.setText(TuxGuitar.getProperty("add"));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGChordCustomList.this.addCustomChord();
            }
        });
        Button rename = new Button(buttons, 8);
        rename.setText(TuxGuitar.getProperty("rename"));
        rename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGChordCustomList.this.renameCustomChord(TGChordCustomList.this.getChords().getSelectionIndex());
            }
        });
        Button remove = new Button(buttons, 8);
        remove.setText(TuxGuitar.getProperty("remove"));
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGChordCustomList.this.removeCustomChord(TGChordCustomList.this.getChords().getSelectionIndex());
            }
        });
        this.loadChords();
    }

    private void loadChords() {
        int selectionIndex = this.chords.getSelectionIndex();
        this.chords.removeAll();
        for (int i = 0; i < TuxGuitar.getInstance().getCustomChordManager().countChords(); ++i) {
            TGChord chord = TuxGuitar.getInstance().getCustomChordManager().getChord(i);
            if (chord == null) continue;
            this.chords.add(chord.getName());
        }
        if (selectionIndex >= 0 && selectionIndex < this.chords.getItemCount()) {
            this.chords.select(selectionIndex);
        } else if (selectionIndex > 0 && selectionIndex - 1 < this.chords.getItemCount()) {
            this.chords.select(selectionIndex - 1);
        }
    }

    protected void showChord(int index) {
        TGChord chord = TuxGuitar.getInstance().getCustomChordManager().getChord(index);
        if (chord != null) {
            this.dialog.getEditor().setChord(chord);
        }
    }

    protected void addCustomChord() {
        TGChord chord = this.dialog.getEditor().getChord();
        if (chord != null) {
            NameDialog nDialog = new NameDialog();
            nDialog.name = this.dialog.getEditor().getChordName().getText().trim();
            String name = nDialog.open();
            if (name != null) {
                if (name.length() == 0) {
                    TGMessageDialogUtil.errorMessage(this.getDialog().getContext().getContext(), this.getShell(), TuxGuitar.getProperty("chord.custom.name-empty-error"));
                    return;
                }
                if (TuxGuitar.getInstance().getCustomChordManager().existOtherEqualCustomChord(name, -1)) {
                    TGMessageDialogUtil.errorMessage(this.getDialog().getContext().getContext(), this.getShell(), TuxGuitar.getProperty("chord.custom.name-exist-error"));
                    return;
                }
                chord.setName(name);
                TuxGuitar.getInstance().getCustomChordManager().addChord(chord);
                this.loadChords();
            }
        }
    }

    protected void renameCustomChord(int index) {
        String name;
        TGChord chord = TuxGuitar.getInstance().getCustomChordManager().getChord(index);
        if (chord != null && (name = new NameDialog(chord.getName()).open()) != null) {
            if (name.length() == 0) {
                TGMessageDialogUtil.errorMessage(this.getDialog().getContext().getContext(), this.getShell(), TuxGuitar.getProperty("chord.custom.name-empty-error"));
                return;
            }
            if (TuxGuitar.getInstance().getCustomChordManager().existOtherEqualCustomChord(name, index)) {
                TGMessageDialogUtil.errorMessage(this.getDialog().getContext().getContext(), this.getShell(), TuxGuitar.getProperty("chord.custom.name-exist-error"));
                return;
            }
            TuxGuitar.getInstance().getCustomChordManager().renameChord(index, name);
            this.loadChords();
        }
    }

    protected void removeCustomChord(int index) {
        if (index >= 0 && index < TuxGuitar.getInstance().getCustomChordManager().countChords()) {
            TuxGuitar.getInstance().getCustomChordManager().removeChord(index);
            this.loadChords();
        }
    }

    protected TGChordDialog getDialog() {
        return this.dialog;
    }

    protected List getChords() {
        return this.chords;
    }

    private class NameDialog {
        protected String name;

        public NameDialog(String name) {
            this.name = name;
        }

        public NameDialog() {
            this(new String());
        }

        public String open() {
            final Shell dialog = DialogUtils.newDialog(TuxGuitar.getInstance().getShell(), 67680);
            dialog.setLayout((Layout)new GridLayout());
            dialog.setText(TuxGuitar.getProperty("chord.custom"));
            Group group = new Group((Composite)dialog, 16);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("chord.custom"));
            Composite composite = new Composite((Composite)group, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)this.getMainData());
            Label label = new Label(composite, 16384);
            label.setText(TuxGuitar.getProperty("chord.name") + ":");
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
            final Text text = new Text(composite, 2052);
            text.setLayoutData((Object)new GridData(4, 4, true, true));
            text.setText(this.name);
            Composite buttons = new Composite((Composite)dialog, 0);
            buttons.setLayout((Layout)new GridLayout(2, false));
            buttons.setLayoutData((Object)new GridData(131072, 4, true, true));
            Button buttonOK = new Button(buttons, 8);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData((Object)this.getButtonData());
            buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    NameDialog.this.name = text.getText();
                    dialog.dispose();
                }
            });
            Button buttonCancel = new Button(buttons, 8);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData((Object)this.getButtonData());
            buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    NameDialog.this.name = null;
                    dialog.dispose();
                }
            });
            dialog.setDefaultButton(buttonOK);
            DialogUtils.openDialog(dialog, 11);
            return this.name;
        }

        private GridData getMainData() {
            GridData data = new GridData(4, 4, true, true);
            data.minimumWidth = 300;
            return data;
        }

        private GridData getButtonData() {
            GridData data = new GridData(4, 4, true, true);
            data.minimumWidth = 80;
            data.minimumHeight = 25;
            return data;
        }
    }
}

