/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.browser.main;

import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.browser.TGBrowserCollection;
import org.herac.tuxguitar.app.tools.browser.TGBrowserManager;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserFactory;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserBar;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserDialog;

public class TGBrowserMenuBar
extends TGBrowserBar {
    private Menu menu;
    private Menu newCollection;
    private Menu openCollection;
    private Menu removeCollection;
    private MenuItem menuFileItem;
    private MenuItem menuCollectionItem;
    private MenuItem menuGoItem;
    private MenuItem open;
    private MenuItem exit;
    private MenuItem newItem;
    private MenuItem openItem;
    private MenuItem removeItem;
    private MenuItem close;
    private MenuItem root;
    private MenuItem back;
    private MenuItem refresh;

    public TGBrowserMenuBar(TGBrowserDialog browser) {
        super(browser);
    }

    public void init(Shell shell) {
        this.menu = new Menu((Decorations)shell, 2);
        Menu menuFile = new Menu((Decorations)shell, 4);
        this.menuFileItem = new MenuItem(this.menu, 64);
        this.menuFileItem.setMenu(menuFile);
        this.open = new MenuItem(menuFile, 8);
        this.open.setImage(TuxGuitar.getInstance().getIconManager().getFileOpen());
        this.open.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGBrowserMenuBar.this.getBrowser().openElement();
            }
        });
        new MenuItem(menuFile, 2);
        this.exit = new MenuItem(menuFile, 8);
        this.exit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGBrowserMenuBar.this.getBrowser().getShell().dispose();
            }
        });
        Menu menuCollection = new Menu((Decorations)shell, 4);
        this.menuCollectionItem = new MenuItem(this.menu, 64);
        this.menuCollectionItem.setMenu(menuCollection);
        this.newCollection = new Menu((Decorations)menuCollection.getShell(), 4);
        this.newItem = new MenuItem(menuCollection, 64);
        this.newItem.setImage(TuxGuitar.getInstance().getIconManager().getBrowserNew());
        this.newItem.setMenu(this.newCollection);
        this.updateTypes();
        this.openCollection = new Menu((Decorations)menuCollection.getShell(), 4);
        this.openItem = new MenuItem(menuCollection, 64);
        this.openItem.setImage(TuxGuitar.getInstance().getIconManager().getFileOpen());
        this.openItem.setMenu(this.openCollection);
        this.removeCollection = new Menu((Decorations)menuCollection.getShell(), 4);
        this.removeItem = new MenuItem(menuCollection, 64);
        this.removeItem.setMenu(this.removeCollection);
        new MenuItem(menuCollection, 2);
        this.close = new MenuItem(menuCollection, 8);
        this.close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGBrowserMenuBar.this.closeCollection();
            }
        });
        Menu menuGo = new Menu((Decorations)shell, 4);
        this.menuGoItem = new MenuItem(this.menu, 64);
        this.menuGoItem.setMenu(menuGo);
        this.root = new MenuItem(menuGo, 8);
        this.root.setImage(TuxGuitar.getInstance().getIconManager().getBrowserRoot());
        this.root.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGBrowserMenuBar.this.getBrowser().getConnection().cdRoot(3);
            }
        });
        this.back = new MenuItem(menuGo, 8);
        this.back.setImage(TuxGuitar.getInstance().getIconManager().getBrowserBack());
        this.back.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGBrowserMenuBar.this.getBrowser().getConnection().cdUp(4);
            }
        });
        this.refresh = new MenuItem(menuGo, 8);
        this.refresh.setImage(TuxGuitar.getInstance().getIconManager().getBrowserRefresh());
        this.refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGBrowserMenuBar.this.getBrowser().getConnection().listElements(5);
            }
        });
        shell.setMenuBar(this.menu);
    }

    public void updateItems() {
        this.open.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.root.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.back.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.refresh.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.newItem.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.openItem.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.removeItem.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.close.setEnabled(!this.getBrowser().getConnection().isLocked());
    }

    public void loadProperties() {
        this.menuFileItem.setText(TuxGuitar.getProperty("browser.menu.file"));
        this.menuCollectionItem.setText(TuxGuitar.getProperty("browser.menu.collection"));
        this.menuGoItem.setText(TuxGuitar.getProperty("browser.menu.go"));
        this.open.setText(TuxGuitar.getProperty("browser.open"));
        this.exit.setText(TuxGuitar.getProperty("browser.exit"));
        this.newItem.setText(TuxGuitar.getProperty("browser.collection.new"));
        this.openItem.setText(TuxGuitar.getProperty("browser.collection.open"));
        this.removeItem.setText(TuxGuitar.getProperty("browser.collection.remove"));
        this.close.setText(TuxGuitar.getProperty("browser.collection.close"));
        this.root.setText(TuxGuitar.getProperty("browser.go-root"));
        this.back.setText(TuxGuitar.getProperty("browser.go-back"));
        this.refresh.setText(TuxGuitar.getProperty("browser.refresh"));
    }

    public void updateCollections(TGBrowserCollection selection) {
        MenuItem[] openItems = this.openCollection.getItems();
        for (int i = 0; i < openItems.length; ++i) {
            openItems[i].dispose();
        }
        MenuItem[] removeItems = this.removeCollection.getItems();
        for (int i = 0; i < removeItems.length; ++i) {
            removeItems[i].dispose();
        }
        Iterator<TGBrowserCollection> it = TGBrowserManager.getInstance(this.getBrowser().getContext()).getCollections();
        while (it.hasNext()) {
            final TGBrowserCollection collection = it.next();
            if (collection.getData() == null) continue;
            MenuItem openItem = new MenuItem(this.openCollection, 8);
            openItem.setText(collection.getData().getTitle());
            openItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TGBrowserMenuBar.this.openCollection(collection);
                }
            });
            if (selection != null && selection.equals(collection)) {
                openItem.setSelection(true);
            }
            MenuItem removeItem = new MenuItem(this.removeCollection, 8);
            removeItem.setText(collection.getData().getTitle());
            removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TGBrowserMenuBar.this.removeCollection(collection);
                }
            });
            if (selection == null || !selection.equals(collection)) continue;
            removeItem.setSelection(true);
        }
    }

    public void updateTypes() {
        MenuItem[] items = this.newCollection.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        Iterator<TGBrowserFactory> bookTypes = TGBrowserManager.getInstance(this.getBrowser().getContext()).getFactories();
        while (bookTypes.hasNext()) {
            final TGBrowserFactory bookType = bookTypes.next();
            MenuItem item = new MenuItem(this.newCollection, 8);
            item.setText(bookType.getName());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TGBrowserMenuBar.this.newCollection(bookType.getType());
                }
            });
        }
    }

    public void reload(Shell shell) {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.init(shell);
        this.loadProperties();
        this.updateItems();
    }
}

