/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.table;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.herac.tuxguitar.app.view.component.table.TGTable;
import org.herac.tuxguitar.app.view.component.table.TGTableCanvasPainter;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterListenerLocked;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterLocked;
import org.herac.tuxguitar.graphics.TGPainter;

public class TGTableRow {
    private TGTable table;
    private Composite row;
    private CLabel number;
    private CLabel soloMute;
    private CLabel name;
    private CLabel instrument;
    private Composite painter;
    private MouseListener mouseListenerLabel;
    private MouseListener mouseListenerCanvas;
    private TGTableCanvasPainter paintListenerCanvas;

    public TGTableRow(TGTable table) {
        this.table = table;
        this.init();
    }

    public void init() {
        MouseListenerLabel mouseListenerLabel = new MouseListenerLabel();
        MouseListenerCanvas mouseListenerCanvas = new MouseListenerCanvas();
        this.row = new Composite(this.table.getRowControl(), 0);
        this.row.setLayoutData((Object)new GridData(4, 128, true, false));
        this.number = new CLabel(this.row, 16384);
        this.number.addMouseListener((MouseListener)mouseListenerLabel);
        this.table.addRowItem(this.table.getColumnNumber(), (Control)this.number, true);
        this.soloMute = new CLabel(this.row, 16384);
        this.soloMute.addMouseListener((MouseListener)mouseListenerLabel);
        this.table.addRowItem(this.table.getColumnSoloMute(), (Control)this.soloMute, true);
        this.name = new CLabel(this.row, 16384);
        this.name.addMouseListener((MouseListener)mouseListenerLabel);
        this.table.addRowItem(this.table.getColumnName(), (Control)this.name, true);
        this.instrument = new CLabel(this.row, 16384);
        this.instrument.addMouseListener((MouseListener)mouseListenerLabel);
        this.table.addRowItem(this.table.getColumnInstrument(), (Control)this.instrument, true);
        this.painter = new Composite(this.row, 0x20000000);
        this.painter.addMouseListener((MouseListener)mouseListenerCanvas);
        this.painter.addPaintListener((PaintListener)new TGBufferedPainterListenerLocked(this.table.getContext(), new TGTableRowPaintHandle()));
        this.table.addRowItem(this.table.getColumnCanvas(), (Control)this.painter, false);
        this.row.pack();
    }

    public void setBackground(Color background) {
        this.number.setBackground(background);
        this.soloMute.setBackground(background);
        this.name.setBackground(background);
        this.instrument.setBackground(background);
    }

    public void setForeground(Color foreground) {
        this.number.setForeground(foreground);
        this.soloMute.setForeground(foreground);
        this.name.setForeground(foreground);
        this.instrument.setForeground(foreground);
    }

    public void dispose() {
        this.row.dispose();
    }

    public Composite getPainter() {
        return this.painter;
    }

    public CLabel getInstrument() {
        return this.instrument;
    }

    public CLabel getName() {
        return this.name;
    }

    public CLabel getNumber() {
        return this.number;
    }

    public CLabel getSoloMute() {
        return this.soloMute;
    }

    public MouseListener getMouseListenerLabel() {
        return this.mouseListenerLabel;
    }

    public void setMouseListenerLabel(MouseListener mouseListenerLabel) {
        this.mouseListenerLabel = mouseListenerLabel;
    }

    public MouseListener getMouseListenerCanvas() {
        return this.mouseListenerCanvas;
    }

    public void setMouseListenerCanvas(MouseListener mouseListenerCanvas) {
        this.mouseListenerCanvas = mouseListenerCanvas;
    }

    public TGTableCanvasPainter getPaintListenerCanvas() {
        return this.paintListenerCanvas;
    }

    public void setPaintListenerCanvas(TGTableCanvasPainter paintListenerCanvas) {
        this.paintListenerCanvas = paintListenerCanvas;
    }

    private class TGTableRowPaintHandle
    implements TGBufferedPainterLocked.TGBufferedPainterHandle {
        public void paintControl(TGPainter painter) {
            if (TGTableRow.this.getPaintListenerCanvas() != null) {
                TGTableRow.this.getPaintListenerCanvas().paintTrack(TGTableRow.this, painter);
            }
        }

        public Composite getPaintableControl() {
            return TGTableRow.this.getPainter();
        }
    }

    private class MouseListenerCanvas
    implements MouseListener {
        public void mouseDoubleClick(MouseEvent e) {
            if (TGTableRow.this.getMouseListenerCanvas() != null) {
                TGTableRow.this.getMouseListenerCanvas().mouseDoubleClick(e);
            }
        }

        public void mouseDown(MouseEvent e) {
            if (TGTableRow.this.getMouseListenerCanvas() != null) {
                TGTableRow.this.getMouseListenerCanvas().mouseDown(e);
            }
        }

        public void mouseUp(MouseEvent e) {
            if (TGTableRow.this.getMouseListenerCanvas() != null) {
                TGTableRow.this.getMouseListenerCanvas().mouseUp(e);
            }
        }
    }

    private class MouseListenerLabel
    implements MouseListener {
        public void mouseDoubleClick(MouseEvent e) {
            if (TGTableRow.this.getMouseListenerLabel() != null) {
                TGTableRow.this.getMouseListenerLabel().mouseDoubleClick(e);
            }
        }

        public void mouseDown(MouseEvent e) {
            if (TGTableRow.this.getMouseListenerLabel() != null) {
                TGTableRow.this.getMouseListenerLabel().mouseDown(e);
            }
        }

        public void mouseUp(MouseEvent e) {
            if (TGTableRow.this.getMouseListenerLabel() != null) {
                TGTableRow.this.getMouseListenerLabel().mouseUp(e);
            }
        }
    }
}

