/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.util;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DialogUtils {
    public static final int OPEN_STYLE_WAIT = 1;
    public static final int OPEN_STYLE_PACK = 2;
    public static final int OPEN_STYLE_LAYOUT = 4;
    public static final int OPEN_STYLE_CENTER = 8;
    public static final int OPEN_STYLE_MAXIMIZED = 16;

    public static final Shell newDialog(Display display, int style) {
        return new Shell(display, style);
    }

    public static final Shell newDialog(Shell parent, int style) {
        return new Shell(parent, style);
    }

    public static final void openDialog(Shell dialog, int style) {
        DialogUtils.openDialog(dialog, dialog.getParent().getShell(), style);
    }

    public static final void openDialog(Shell dialog, Shell parent, int style) {
        Display display = dialog.getDisplay();
        if ((style & 2) != 0) {
            dialog.pack();
        }
        if ((style & 4) != 0) {
            dialog.layout();
        }
        if ((style & 0x10) != 0) {
            dialog.setMaximized(true);
        } else if ((style & 8) != 0) {
            int x = Math.max(0, parent.getBounds().x + (parent.getBounds().width - dialog.getSize().x) / 2);
            int y = Math.max(0, parent.getBounds().y + (parent.getBounds().height - dialog.getSize().y) / 2);
            dialog.setLocation(x, y);
        }
        dialog.open();
        if ((style & 1) != 0) {
            while (!display.isDisposed() && !dialog.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }
}

