/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.channel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGUndoableChannelGeneric
extends TGUndoableEditBase {
    private int doAction;
    private List<TGChannel> undoChannels;
    private List<TGChannel> redoChannels;

    private TGUndoableChannelGeneric(TGContext context) {
        super(context);
    }

    @Override
    public void redo() throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.setChannels(this.getSong(), this.cloneChannels(this.getSongManager().getFactory(), this.redoChannels));
        this.doAction = 1;
    }

    @Override
    public void undo() throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.setChannels(this.getSong(), this.cloneChannels(this.getSongManager().getFactory(), this.undoChannels));
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableChannelGeneric startUndo(TGContext context) {
        TGUndoableChannelGeneric undoable = new TGUndoableChannelGeneric(context);
        undoable.doAction = 1;
        undoable.undoChannels = undoable.getClonedChannels();
        return undoable;
    }

    public TGUndoableChannelGeneric endUndo() {
        this.redoChannels = this.getClonedChannels();
        return this;
    }

    private List<TGChannel> getClonedChannels() {
        ArrayList<TGChannel> channels = new ArrayList<TGChannel>();
        Iterator it = this.getSongManager().getChannels(this.getSong()).iterator();
        while (it.hasNext()) {
            channels.add((TGChannel)it.next());
        }
        return this.cloneChannels(new TGFactory(), channels);
    }

    public List<TGChannel> cloneChannels(TGFactory factory, List<TGChannel> channels) {
        ArrayList<TGChannel> clonedChannels = new ArrayList<TGChannel>();
        for (TGChannel channel : channels) {
            clonedChannels.add(channel.clone(factory));
        }
        return clonedChannels;
    }

    public void setChannels(TGSong song, List<TGChannel> channels) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.channel.set-channels");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute("channels", channels);
        this.processByPassUndoableAction(tgActionProcessor);
    }
}

